/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.vykon.vykonPro.enums.BDateModeEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPeakTracker
extends BComponent {
    public static final Property enabled = BPeakTracker.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property facets = BPeakTracker.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property dateMode = BPeakTracker.newProperty((int)256, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BDateModeEnum.TYPE)), null);
    public static final Property billingCycleStartDay = BPeakTracker.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)28));
    public static final Property in = BPeakTracker.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property lastReset = BPeakTracker.newProperty((int)9, (BValue)BAbsTime.NULL, null);
    public static final Property januaryPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property januaryTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property februaryPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property februaryTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property marchPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property marchTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property aprilPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property aprilTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property mayPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property mayTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property junePeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property juneTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property julyPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property julyTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property augustPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property augustTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property septemberPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property septemberTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property octoberPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property octoberTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property novemberPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property novemberTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property decemberPeak = BPeakTracker.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property decemberTimestamp = BPeakTracker.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BPeakTracker.newAction((int)4, null);
    public static final Action ticketExpired = BPeakTracker.newAction((int)4, null);
    public static final Action resetPeaks = BPeakTracker.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPeakTracker.class);
    BAbsTime now = null;
    Clock.Ticket ticket = null;
    private static final BIcon icon = BIcon.std((String)"arrowUp.png");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BEnum getDateMode() {
        return (BEnum)this.get(dateMode);
    }

    public void setDateMode(BEnum v) {
        this.set(dateMode, (BValue)v, null);
    }

    public int getBillingCycleStartDay() {
        return this.getInt(billingCycleStartDay);
    }

    public void setBillingCycleStartDay(int v) {
        this.setInt(billingCycleStartDay, v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public BAbsTime getLastReset() {
        return (BAbsTime)this.get(lastReset);
    }

    public void setLastReset(BAbsTime v) {
        this.set(lastReset, (BValue)v, null);
    }

    public BStatusNumeric getJanuaryPeak() {
        return (BStatusNumeric)this.get(januaryPeak);
    }

    public void setJanuaryPeak(BStatusNumeric v) {
        this.set(januaryPeak, (BValue)v, null);
    }

    public BAbsTime getJanuaryTimestamp() {
        return (BAbsTime)this.get(januaryTimestamp);
    }

    public void setJanuaryTimestamp(BAbsTime v) {
        this.set(januaryTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getFebruaryPeak() {
        return (BStatusNumeric)this.get(februaryPeak);
    }

    public void setFebruaryPeak(BStatusNumeric v) {
        this.set(februaryPeak, (BValue)v, null);
    }

    public BAbsTime getFebruaryTimestamp() {
        return (BAbsTime)this.get(februaryTimestamp);
    }

    public void setFebruaryTimestamp(BAbsTime v) {
        this.set(februaryTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getMarchPeak() {
        return (BStatusNumeric)this.get(marchPeak);
    }

    public void setMarchPeak(BStatusNumeric v) {
        this.set(marchPeak, (BValue)v, null);
    }

    public BAbsTime getMarchTimestamp() {
        return (BAbsTime)this.get(marchTimestamp);
    }

    public void setMarchTimestamp(BAbsTime v) {
        this.set(marchTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getAprilPeak() {
        return (BStatusNumeric)this.get(aprilPeak);
    }

    public void setAprilPeak(BStatusNumeric v) {
        this.set(aprilPeak, (BValue)v, null);
    }

    public BAbsTime getAprilTimestamp() {
        return (BAbsTime)this.get(aprilTimestamp);
    }

    public void setAprilTimestamp(BAbsTime v) {
        this.set(aprilTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getMayPeak() {
        return (BStatusNumeric)this.get(mayPeak);
    }

    public void setMayPeak(BStatusNumeric v) {
        this.set(mayPeak, (BValue)v, null);
    }

    public BAbsTime getMayTimestamp() {
        return (BAbsTime)this.get(mayTimestamp);
    }

    public void setMayTimestamp(BAbsTime v) {
        this.set(mayTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getJunePeak() {
        return (BStatusNumeric)this.get(junePeak);
    }

    public void setJunePeak(BStatusNumeric v) {
        this.set(junePeak, (BValue)v, null);
    }

    public BAbsTime getJuneTimestamp() {
        return (BAbsTime)this.get(juneTimestamp);
    }

    public void setJuneTimestamp(BAbsTime v) {
        this.set(juneTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getJulyPeak() {
        return (BStatusNumeric)this.get(julyPeak);
    }

    public void setJulyPeak(BStatusNumeric v) {
        this.set(julyPeak, (BValue)v, null);
    }

    public BAbsTime getJulyTimestamp() {
        return (BAbsTime)this.get(julyTimestamp);
    }

    public void setJulyTimestamp(BAbsTime v) {
        this.set(julyTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getAugustPeak() {
        return (BStatusNumeric)this.get(augustPeak);
    }

    public void setAugustPeak(BStatusNumeric v) {
        this.set(augustPeak, (BValue)v, null);
    }

    public BAbsTime getAugustTimestamp() {
        return (BAbsTime)this.get(augustTimestamp);
    }

    public void setAugustTimestamp(BAbsTime v) {
        this.set(augustTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getSeptemberPeak() {
        return (BStatusNumeric)this.get(septemberPeak);
    }

    public void setSeptemberPeak(BStatusNumeric v) {
        this.set(septemberPeak, (BValue)v, null);
    }

    public BAbsTime getSeptemberTimestamp() {
        return (BAbsTime)this.get(septemberTimestamp);
    }

    public void setSeptemberTimestamp(BAbsTime v) {
        this.set(septemberTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getOctoberPeak() {
        return (BStatusNumeric)this.get(octoberPeak);
    }

    public void setOctoberPeak(BStatusNumeric v) {
        this.set(octoberPeak, (BValue)v, null);
    }

    public BAbsTime getOctoberTimestamp() {
        return (BAbsTime)this.get(octoberTimestamp);
    }

    public void setOctoberTimestamp(BAbsTime v) {
        this.set(octoberTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getNovemberPeak() {
        return (BStatusNumeric)this.get(novemberPeak);
    }

    public void setNovemberPeak(BStatusNumeric v) {
        this.set(novemberPeak, (BValue)v, null);
    }

    public BAbsTime getNovemberTimestamp() {
        return (BAbsTime)this.get(novemberTimestamp);
    }

    public void setNovemberTimestamp(BAbsTime v) {
        this.set(novemberTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getDecemberPeak() {
        return (BStatusNumeric)this.get(decemberPeak);
    }

    public void setDecemberPeak(BStatusNumeric v) {
        this.set(decemberPeak, (BValue)v, null);
    }

    public BAbsTime getDecemberTimestamp() {
        return (BAbsTime)this.get(decemberTimestamp);
    }

    public void setDecemberTimestamp(BAbsTime v) {
        this.set(decemberTimestamp, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void ticketExpired() {
        this.invoke(ticketExpired, null, null);
    }

    public void resetPeaks() {
        this.invoke(resetPeaks, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.getEnabled()) {
            return;
        }
        this.calculate();
        this.initClockTicket();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void atSteadyState() {
        this.calculate();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)in) || slot.equals((Object)januaryPeak) || slot.equals((Object)februaryPeak) || slot.equals((Object)marchPeak) || slot.equals((Object)aprilPeak) || slot.equals((Object)mayPeak) || slot.equals((Object)junePeak) || slot.equals((Object)julyPeak) || slot.equals((Object)augustPeak) || slot.equals((Object)septemberPeak) || slot.equals((Object)octoberPeak) || slot.equals((Object)novemberPeak) || slot.equals((Object)decemberPeak)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime value) {
        if (this.getEnabled()) {
            this.initClockTicket();
        }
    }

    private void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.now = Clock.time();
        BMonth currentMonth = this.now.getMonth();
        int currentYear = this.now.getYear();
        int currentDay = this.now.getDay();
        BAbsTime firstOfMonth = null;
        BAbsTime nextMonth = null;
        if (this.getDateMode().getOrdinal() == 0) {
            firstOfMonth = BAbsTime.make((int)currentYear, (BMonth)currentMonth, (int)1, (int)0, (int)0, (int)15, (int)0);
            nextMonth = firstOfMonth.nextMonth();
        } else if (currentDay < this.getBillingCycleStartDay()) {
            nextMonth = BAbsTime.make((int)currentYear, (BMonth)currentMonth, (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)15, (int)0);
        } else {
            firstOfMonth = BAbsTime.make((int)currentYear, (BMonth)currentMonth, (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)15, (int)0);
            nextMonth = firstOfMonth.nextMonth();
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)nextMonth, (Action)ticketExpired, null);
    }

    public void doTicketExpired() {
        this.doCalculate();
        this.initClockTicket();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (prop.equals(in) && this.getEnabled()) {
            if (this.getIn().getStatus().isValid()) {
                this.calculate();
            }
        } else if (prop.equals(enabled)) {
            if (this.getEnabled()) {
                this.initClockTicket();
                this.doCalculate();
            } else if (this.ticket != null) {
                this.ticket.cancel();
            }
        } else if (prop.equals(dateMode)) {
            this.initClockTicket();
        } else if (prop.equals(billingCycleStartDay) && this.getDateMode().getOrdinal() == 1) {
            this.initClockTicket();
        }
    }

    public void doCalculate() {
        this.now = Clock.time();
        int month = this.now.getMonth().getMonthOfYear();
        int year = this.now.getYear();
        int day = this.now.getDay();
        double inValue = this.getIn().getValue();
        if (this.getDateMode().getOrdinal() == 0) {
            this.checkPeak(inValue, month, year);
        } else {
            int billDay = this.getBillingCycleStartDay();
            if (day < billDay) {
                BAbsTime prevMonth = this.now.prevMonth();
                this.checkPeak(inValue, prevMonth.getMonth().getMonthOfYear(), prevMonth.getYear());
            } else {
                this.checkPeak(inValue, month, year);
            }
        }
    }

    public void doResetPeaks() {
        this.now = Clock.time();
        this.setLastReset(this.now);
        this.getJanuaryPeak().setValue(0.0);
        this.setJanuaryTimestamp(BAbsTime.NULL);
        this.getFebruaryPeak().setValue(0.0);
        this.setFebruaryTimestamp(BAbsTime.NULL);
        this.getMarchPeak().setValue(0.0);
        this.setMarchTimestamp(BAbsTime.NULL);
        this.getAprilPeak().setValue(0.0);
        this.setAprilTimestamp(BAbsTime.NULL);
        this.getMayPeak().setValue(0.0);
        this.setMayTimestamp(BAbsTime.NULL);
        this.getJunePeak().setValue(0.0);
        this.setJuneTimestamp(BAbsTime.NULL);
        this.getJulyPeak().setValue(0.0);
        this.setJulyTimestamp(BAbsTime.NULL);
        this.getAugustPeak().setValue(0.0);
        this.setAugustTimestamp(BAbsTime.NULL);
        this.getSeptemberPeak().setValue(0.0);
        this.setSeptemberTimestamp(BAbsTime.NULL);
        this.getOctoberPeak().setValue(0.0);
        this.setOctoberTimestamp(BAbsTime.NULL);
        this.getNovemberPeak().setValue(0.0);
        this.setNovemberTimestamp(BAbsTime.NULL);
        this.getDecemberPeak().setValue(0.0);
        this.setDecemberTimestamp(BAbsTime.NULL);
        this.calculate();
    }

    private void checkPeak(double v, int m, int y) {
        switch (m) {
            case 1: {
                if (!(v >= this.getJanuaryPeak().getValue()) && this.getJanuaryTimestamp().getYear() == y) break;
                this.getJanuaryPeak().setValue(v);
                this.setJanuaryTimestamp(this.now);
                break;
            }
            case 2: {
                if (!(v >= this.getFebruaryPeak().getValue()) && this.getFebruaryTimestamp().getYear() == y) break;
                this.getFebruaryPeak().setValue(v);
                this.setFebruaryTimestamp(this.now);
                break;
            }
            case 3: {
                if (!(v >= this.getMarchPeak().getValue()) && this.getMarchTimestamp().getYear() == y) break;
                this.getMarchPeak().setValue(v);
                this.setMarchTimestamp(this.now);
                break;
            }
            case 4: {
                if (!(v >= this.getAprilPeak().getValue()) && this.getAprilTimestamp().getYear() == y) break;
                this.getAprilPeak().setValue(v);
                this.setAprilTimestamp(this.now);
                break;
            }
            case 5: {
                if (!(v >= this.getMayPeak().getValue()) && this.getMayTimestamp().getYear() == y) break;
                this.getMayPeak().setValue(v);
                this.setMayTimestamp(this.now);
                break;
            }
            case 6: {
                if (!(v >= this.getJunePeak().getValue()) && this.getJuneTimestamp().getYear() == y) break;
                this.getJunePeak().setValue(v);
                this.setJuneTimestamp(this.now);
                break;
            }
            case 7: {
                if (!(v >= this.getJulyPeak().getValue()) && this.getJulyTimestamp().getYear() == y) break;
                this.getJulyPeak().setValue(v);
                this.setJulyTimestamp(this.now);
                break;
            }
            case 8: {
                if (!(v >= this.getAugustPeak().getValue()) && this.getAugustTimestamp().getYear() == y) break;
                this.getAugustPeak().setValue(v);
                this.setAugustTimestamp(this.now);
                break;
            }
            case 9: {
                if (!(v >= this.getSeptemberPeak().getValue()) && this.getSeptemberTimestamp().getYear() == y) break;
                this.getSeptemberPeak().setValue(v);
                this.setSeptemberTimestamp(this.now);
                break;
            }
            case 10: {
                if (!(v >= this.getOctoberPeak().getValue()) && this.getOctoberTimestamp().getYear() == y) break;
                this.getOctoberPeak().setValue(v);
                this.setOctoberTimestamp(this.now);
                break;
            }
            case 11: {
                if (!(v >= this.getNovemberPeak().getValue()) && this.getNovemberTimestamp().getYear() == y) break;
                this.getNovemberPeak().setValue(v);
                this.setNovemberTimestamp(this.now);
                break;
            }
            case 12: {
                if (!(v >= this.getDecemberPeak().getValue()) && this.getDecemberTimestamp().getYear() == y) break;
                this.getDecemberPeak().setValue(v);
                this.setDecemberTimestamp(this.now);
            }
        }
    }

    public BStatusNumeric[] getPeaks() {
        BStatusNumeric[] peaks = new BStatusNumeric[]{(BStatusNumeric)this.getJanuaryPeak().newCopy(), (BStatusNumeric)this.getFebruaryPeak().newCopy(), (BStatusNumeric)this.getMarchPeak().newCopy(), (BStatusNumeric)this.getAprilPeak().newCopy(), (BStatusNumeric)this.getMayPeak().newCopy(), (BStatusNumeric)this.getJunePeak().newCopy(), (BStatusNumeric)this.getJulyPeak().newCopy(), (BStatusNumeric)this.getAugustPeak().newCopy(), (BStatusNumeric)this.getSeptemberPeak().newCopy(), (BStatusNumeric)this.getOctoberPeak().newCopy(), (BStatusNumeric)this.getNovemberPeak().newCopy(), (BStatusNumeric)this.getDecemberPeak().newCopy()};
        return peaks;
    }

    public BAbsTime[] getTimestamps() {
        BAbsTime[] tstamps = new BAbsTime[]{(BAbsTime)this.getJanuaryTimestamp().newCopy(), (BAbsTime)this.getFebruaryTimestamp().newCopy(), (BAbsTime)this.getMarchTimestamp().newCopy(), (BAbsTime)this.getAprilTimestamp().newCopy(), (BAbsTime)this.getMayTimestamp().newCopy(), (BAbsTime)this.getJuneTimestamp().newCopy(), (BAbsTime)this.getJulyTimestamp().newCopy(), (BAbsTime)this.getAugustTimestamp().newCopy(), (BAbsTime)this.getSeptemberTimestamp().newCopy(), (BAbsTime)this.getOctoberTimestamp().newCopy(), (BAbsTime)this.getNovemberTimestamp().newCopy(), (BAbsTime)this.getDecemberTimestamp().newCopy()};
        return tstamps;
    }

    public BIcon getIcon() {
        return icon;
    }
}

