/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BInUseEnum;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="input", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10), @NiagaraProperty(name="propagateFlags", type="BStatus", defaultValue="BStatus.ok"), @NiagaraProperty(name="deviationFacets", type="BFacets", defaultValue="BFacets.makeNumeric(BUnit.DEFAULT, 1)"), @NiagaraProperty(name="averageDeviation", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=11), @NiagaraProperty(name="maximumDeviation", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=11), @NiagaraProperty(name="inServiceFacets", type="BFacets", defaultValue="BFacets.makeBoolean()"), @NiagaraProperty(name="inService", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=8), @NiagaraProperty(name="masterSelected", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="masterInUse", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0)", flags=65), @NiagaraProperty(name="sampleCount", type="BInteger", defaultValue="BInteger.make(12)", flags=8, facets={@Facet(name="BFacets.MIN", value="BInteger.make(2)"), @Facet(name="BFacets.MAX", value="BInteger.make(60)")}), @NiagaraProperty(name="sampleRate", type="BRelTime", defaultValue="BRelTime.makeSeconds(5)", flags=8, facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)")}), @NiagaraProperty(name="debug", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="calculate", flags=4), @NiagaraAction(name="reset", flags=256)})
public class BRollingAvg
extends BNumericPoint {
    public static final Property input = BRollingAvg.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property propagateFlags = BRollingAvg.newProperty((int)0, (BValue)BStatus.ok, null);
    public static final Property deviationFacets = BRollingAvg.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)1), null);
    public static final Property averageDeviation = BRollingAvg.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property maximumDeviation = BRollingAvg.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property inServiceFacets = BRollingAvg.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property inService = BRollingAvg.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property masterSelected = BRollingAvg.newProperty((int)65, (boolean)false, null);
    public static final Property masterInUse = BRollingAvg.newProperty((int)65, (BValue)BDynamicEnum.make((int)0), null);
    public static final Property sampleCount = BRollingAvg.newProperty((int)8, (int)BInteger.make((int)12).getInt(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)2)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)60))));
    public static final Property sampleRate = BRollingAvg.newProperty((int)8, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property debug = BRollingAvg.newProperty((int)4, (boolean)false, null);
    public static final Action calculate = BRollingAvg.newAction((int)4, null);
    public static final Action reset = BRollingAvg.newAction((int)256, null);
    public static final Type TYPE = Sys.loadType(BRollingAvg.class);
    private static final BIcon icon = BIcon.std((String)"control/math/average.png");
    private static final BFacets PROPAGATE_FACETS = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"kitControl:PropagateFlagsFE"));
    private Clock.Ticket ticket;
    private BStatusNumeric[] sensorSample;
    private int elements;
    private int count;
    private BStatusNumeric averageOutput = new BStatusNumeric();
    private static BRelTime DEF_TIME = BRelTime.makeSeconds((int)5);
    static final Context noExecuteContext = new BasicContext();

    public BStatusNumeric getInput() {
        return (BStatusNumeric)this.get(input);
    }

    public void setInput(BStatusNumeric v) {
        this.set(input, (BValue)v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public BFacets getDeviationFacets() {
        return (BFacets)this.get(deviationFacets);
    }

    public void setDeviationFacets(BFacets v) {
        this.set(deviationFacets, (BValue)v, null);
    }

    public BStatusNumeric getAverageDeviation() {
        return (BStatusNumeric)this.get(averageDeviation);
    }

    public void setAverageDeviation(BStatusNumeric v) {
        this.set(averageDeviation, (BValue)v, null);
    }

    public BStatusNumeric getMaximumDeviation() {
        return (BStatusNumeric)this.get(maximumDeviation);
    }

    public void setMaximumDeviation(BStatusNumeric v) {
        this.set(maximumDeviation, (BValue)v, null);
    }

    public BFacets getInServiceFacets() {
        return (BFacets)this.get(inServiceFacets);
    }

    public void setInServiceFacets(BFacets v) {
        this.set(inServiceFacets, (BValue)v, null);
    }

    public BStatusBoolean getInService() {
        return (BStatusBoolean)this.get(inService);
    }

    public void setInService(BStatusBoolean v) {
        this.set(inService, (BValue)v, null);
    }

    public boolean getMasterSelected() {
        return this.getBoolean(masterSelected);
    }

    public void setMasterSelected(boolean v) {
        this.setBoolean(masterSelected, v, null);
    }

    public BDynamicEnum getMasterInUse() {
        return (BDynamicEnum)this.get(masterInUse);
    }

    public void setMasterInUse(BDynamicEnum v) {
        this.set(masterInUse, (BValue)v, null);
    }

    public int getSampleCount() {
        return this.getInt(sampleCount);
    }

    public void setSampleCount(int v) {
        this.setInt(sampleCount, v, null);
    }

    public BRelTime getSampleRate() {
        return (BRelTime)this.get(sampleRate);
    }

    public void setSampleRate(BRelTime v) {
        this.set(sampleRate, (BValue)v, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.initialize();
        this.updateTimer();
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)input) || slot.equals((Object)out)) {
            return this.getFacets();
        }
        if (slot.equals((Object)averageDeviation) || slot.equals((Object)maximumDeviation)) {
            return this.getDeviationFacets();
        }
        if (slot.equals((Object)propagateFlags)) {
            return PROPAGATE_FACETS;
        }
        if (slot.equals((Object)inService)) {
            return this.getInServiceFacets();
        }
        if (slot.equals((Object)masterInUse)) {
            return BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BInUseEnum.TYPE));
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(sampleRate)) {
            this.updateTimer();
        } else if (property.equals(sampleCount)) {
            this.initialize();
        }
    }

    void updateTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BRelTime interval = this.getSampleRate().getMillis() >= 1000L ? this.getSampleRate() : DEF_TIME;
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)interval, (Action)calculate, null);
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        out.setStatus(this.averageOutput.getStatus());
        ((BStatusNumeric)out).setValue(this.averageOutput.getValue());
    }

    public void doReset() {
        this.initialize();
        this.calculate();
    }

    public void doCalculate() {
        this.updateTimer();
        for (int i = this.count - 1; i >= 1; --i) {
            this.sensorSample[i] = this.sensorSample[i - 1];
        }
        this.sensorSample[0] = (BStatusNumeric)this.getInput().newCopy();
        if (this.elements < this.count) {
            ++this.elements;
        }
        double total = 0.0;
        double deviationTotal = 0.0;
        double deviationMax = Double.NEGATIVE_INFINITY;
        int valid = 0;
        int lastValid = -1;
        BStatus mergedStatus = BStatus.ok;
        for (int j = 0; j <= this.elements - 1; ++j) {
            if (this.sensorSample[j].getStatus().isNull() || Double.isInfinite(this.sensorSample[j].getValue()) || Double.isNaN(this.sensorSample[j].getValue())) continue;
            total += this.sensorSample[j].getValue();
            mergedStatus = BStatus.make((int)(mergedStatus.getBits() | this.sensorSample[j].getStatus().getBits()));
            if (valid > 0) {
                double deviation = Math.abs(this.sensorSample[lastValid].getValue() - this.sensorSample[j].getValue());
                deviationTotal += deviation;
                if (deviation > deviationMax) {
                    deviationMax = deviation;
                }
                if (this.getDebug()) {
                    System.out.println(j + " - value = " + this.sensorSample[j] + " | deviation = " + deviation);
                }
            } else if (this.getDebug()) {
                System.out.println(j + " - value = " + this.sensorSample[j]);
            }
            ++valid;
            lastValid = j;
        }
        if (valid > 0) {
            this.averageOutput.setValue(total / (double)valid);
            this.averageOutput.setStatus(this.propagate(mergedStatus));
            if (valid > 1) {
                this.set("averageDeviation", (BValue)new BStatusNumeric(deviationTotal / (double)(valid - 1), BStatus.ok), noExecuteContext);
            } else {
                this.set("averageDeviation", (BValue)new BStatusNumeric(Double.NaN, BStatus.nullStatus), noExecuteContext);
            }
        } else {
            this.averageOutput.setValue(Double.NaN);
            this.averageOutput.setStatus(BStatus.nullStatus);
            this.set("averageDeviation", (BValue)new BStatusNumeric(Double.NaN, BStatus.nullStatus), noExecuteContext);
        }
        this.set("maximumDeviation", (BValue)new BStatusNumeric(deviationMax), noExecuteContext);
        if (this.getDebug()) {
            System.out.println("avg = " + this.averageOutput + " | avgDeviation = " + this.getAverageDeviation() + " | maxDeviation = " + this.getMaximumDeviation());
        }
    }

    void initialize() {
        this.count = this.getSampleCount();
        this.sensorSample = new BStatusNumeric[this.count];
        this.elements = 0;
    }

    public BStatus propagate(BStatus s) {
        return BStatus.make((int)(s.getBits() & this.getPropagateFlags().getBits()));
    }

    public BIcon getIcon() {
        return icon;
    }
}

