/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.point;

import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNumericCovTotalizerExt
extends BPointExtension {
    public static final Property totalFacets = BNumericCovTotalizerExt.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property total = BNumericCovTotalizerExt.newProperty((int)1, (BValue)new BStatusNumeric(0.0), null);
    public static final Property timeOfTotalReset = BNumericCovTotalizerExt.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Action resetTotal = BNumericCovTotalizerExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNumericCovTotalizerExt.class);
    private double lastValue;

    public BFacets getTotalFacets() {
        return (BFacets)this.get(totalFacets);
    }

    public void setTotalFacets(BFacets v) {
        this.set(totalFacets, (BValue)v, null);
    }

    public BStatusNumeric getTotal() {
        return (BStatusNumeric)this.get(total);
    }

    public void setTotal(BStatusNumeric v) {
        this.set(total, (BValue)v, null);
    }

    public BAbsTime getTimeOfTotalReset() {
        return (BAbsTime)this.get(timeOfTotalReset);
    }

    public void setTimeOfTotalReset(BAbsTime v) {
        this.set(timeOfTotalReset, (BValue)v, null);
    }

    public void resetTotal() {
        this.invoke(resetTotal, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)total)) {
            return this.getTotalFacets();
        }
        return super.getSlotFacets(slot);
    }

    public boolean requiresPointSubscription() {
        return true;
    }

    public boolean isParentLegal(BComponent parent) {
        if (!super.isParentLegal(parent)) {
            return false;
        }
        return parent instanceof BNumericPoint;
    }

    public void started() throws Exception {
        super.started();
        this.lastValue = 0.0;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric out = (BStatusNumeric)o;
        if (out.getStatus().isValid()) {
            double value = out.getValue();
            if (value != this.lastValue) {
                this.getTotal().setValue(this.getTotal().getValue() + value);
            }
            this.lastValue = value;
        }
    }

    public void doResetTotal() {
        this.getTotal().setValue(0.0);
        this.setTimeOfTotalReset(Clock.time());
    }
}

