/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.util;

import com.tridium.history.audit.BAuditHistoryService;
import com.tridium.history.audit.BAuditRecord;
import com.vykon.vykonPro.point.BAuditExt;
import com.vykon.vykonPro.util.BVykonProWorker;
import javax.baja.control.BControlPoint;
import javax.baja.history.BHistoryRecord;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraAction(name="checkRecord", flags=16, parameterType="history:HistoryRecord", defaultValue="new BAuditRecord()")
@NiagaraProperty(name="worker", type="BVykonProWorker", defaultValue="new BVykonProWorker()")
public class BActionAuditService
extends BAbstractService
implements BIService {
    public static final Property worker = BActionAuditService.newProperty((int)0, (BValue)new BVykonProWorker(), null);
    public static final Action checkRecord = BActionAuditService.newAction((int)16, (BValue)new BAuditRecord(), null);
    public static final Type TYPE = Sys.loadType(BActionAuditService.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"navOnly/histories.png");

    public BVykonProWorker getWorker() {
        return (BVykonProWorker)this.get(worker);
    }

    public void setWorker(BVykonProWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public void checkRecord(BHistoryRecord parameter) {
        this.invoke(checkRecord, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BServiceContainer;
    }

    public void serviceStarted() throws Exception {
        this.checkLink();
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
    }

    public void stationStarted() {
        this.checkLink();
    }

    private void checkLink() {
        BAuditHistoryService service = (BAuditHistoryService)Sys.getService((Type)BAuditHistoryService.TYPE);
        if (service != null && !this.isLinkTarget((Slot)checkRecord)) {
            BLink link = new BLink(service.getHandleOrd(), "lastRecord", "checkRecord", true);
            if (this.get("auditLInk") == null) {
                this.add("auditLink", (BValue)link);
            } else {
                this.set("auditLink", (BValue)link, null);
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == checkRecord) {
            return this.getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public void doCheckRecord(BHistoryRecord record) {
        BOrd targetOrd;
        BComponent comp;
        BAuditRecord rec = (BAuditRecord)record;
        if (rec.getOperation().equals("Invoked") && rec.getTarget().startsWith("/") && (comp = (BComponent)(targetOrd = BOrd.make((String)("station:|slot:" + rec.getTarget()))).resolve().get()) != null && comp instanceof BControlPoint) {
            BAuditExt[] extensions = (BAuditExt[])((BControlPoint)comp).getChildren(BAuditExt.class);
            for (int i = 0; i < extensions.length; ++i) {
                extensions[i].checkRecord(rec);
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

