/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.util;

import com.vykon.vykonPro.util.BVykonProService;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BConnectionFailover
extends BComponent {
    public static final Property status = BConnectionFailover.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BConnectionFailover.newProperty((int)3, (String)"", null);
    public static final Property enabled = BConnectionFailover.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property restoreMode = BConnectionFailover.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"automatic", (String)"manual"));
    public static final Property pingFrequency = BConnectionFailover.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property pingHost = BConnectionFailover.newProperty((int)264, (String)"enter host address here", null);
    public static final Property pingPort = BConnectionFailover.newProperty((int)256, (int)80, null);
    public static final Property pingTimeout = BConnectionFailover.newProperty((int)0, (int)5, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"), (String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property pingFailureLimit = BConnectionFailover.newProperty((int)0, (int)3, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberOfPingFails = BConnectionFailover.newProperty((int)1, (int)0, null);
    public static final Property pingStatus = BConnectionFailover.newProperty((int)9, (BValue)new BStatusString(), null);
    public static final Property pingFail = BConnectionFailover.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property lastPingTime = BConnectionFailover.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action ping = BConnectionFailover.newAction((int)16, null);
    public static final Action resetFail = BConnectionFailover.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BConnectionFailover.class);
    private static final BIcon icon = BIcon.std((String)"gears.png");
    Clock.Ticket ticket;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public boolean getRestoreMode() {
        return this.getBoolean(restoreMode);
    }

    public void setRestoreMode(boolean v) {
        this.setBoolean(restoreMode, v, null);
    }

    public BRelTime getPingFrequency() {
        return (BRelTime)this.get(pingFrequency);
    }

    public void setPingFrequency(BRelTime v) {
        this.set(pingFrequency, (BValue)v, null);
    }

    public String getPingHost() {
        return this.getString(pingHost);
    }

    public void setPingHost(String v) {
        this.setString(pingHost, v, null);
    }

    public int getPingPort() {
        return this.getInt(pingPort);
    }

    public void setPingPort(int v) {
        this.setInt(pingPort, v, null);
    }

    public int getPingTimeout() {
        return this.getInt(pingTimeout);
    }

    public void setPingTimeout(int v) {
        this.setInt(pingTimeout, v, null);
    }

    public int getPingFailureLimit() {
        return this.getInt(pingFailureLimit);
    }

    public void setPingFailureLimit(int v) {
        this.setInt(pingFailureLimit, v, null);
    }

    public int getNumberOfPingFails() {
        return this.getInt(numberOfPingFails);
    }

    public void setNumberOfPingFails(int v) {
        this.setInt(numberOfPingFails, v, null);
    }

    public BStatusString getPingStatus() {
        return (BStatusString)this.get(pingStatus);
    }

    public void setPingStatus(BStatusString v) {
        this.set(pingStatus, (BValue)v, null);
    }

    public BStatusBoolean getPingFail() {
        return (BStatusBoolean)this.get(pingFail);
    }

    public void setPingFail(BStatusBoolean v) {
        this.set(pingFail, (BValue)v, null);
    }

    public BAbsTime getLastPingTime() {
        return (BAbsTime)this.get(lastPingTime);
    }

    public void setLastPingTime(BAbsTime v) {
        this.set(lastPingTime, (BValue)v, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void resetFail() {
        this.invoke(resetFail, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
        if (this.getEnabled()) {
            this.initClockTicket();
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    private final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public void clockChanged(BRelTime value) {
        if (this.getEnabled()) {
            this.initClockTicket();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(pingFrequency) && this.getEnabled()) {
            this.initClockTicket();
        }
        if (property.equals(enabled) && this.getEnabled()) {
            this.initClockTicket();
        }
    }

    void initClockTicket() {
        BRelTime period;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if ((period = this.getPingFrequency()).getMillis() < 60000L) {
            period = BRelTime.MINUTE;
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)period, (Action)ping, null);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == ping) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() throws Exception {
        this.initClockTicket();
        if (this.getStatus().isFault()) {
            this.checkForService();
            if (this.getStatus().isFault()) {
                return;
            }
        }
        if (this.getPingHost().length() == 0) {
            this.getPingStatus().setValue("ping host not set");
            return;
        }
        try (Socket socket = new Socket();){
            InetSocketAddress isa = new InetSocketAddress(InetAddress.getByName(this.getPingHost()), this.getPingPort());
            socket.connect(isa, this.getPingTimeout() * 1000);
            this.getPingStatus().setValue("ping successfull " + this.getPingHost());
            if (this.getPingFail().getValue() && this.getRestoreMode()) {
                this.getPingFail().setValue(false);
            }
            this.setNumberOfPingFails(0);
        }
        this.setLastPingTime(Clock.time());
    }

    public void doResetFail() {
        this.getPingFail().setValue(false);
        this.setNumberOfPingFails(0);
        this.getPingStatus().setValue("cleared ping fail state at time - " + Clock.time());
    }

    public BIcon getIcon() {
        return icon;
    }
}

