/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public final class ScheduleValidator {
    private ScheduleValidator() {
    }

    public static void validate(BAbstractSchedule schedule, Context cx) throws Exception {
        ScheduleValidator.validate(schedule, Lexicon.make((String)"schedule", (Context)cx));
    }

    public static void validate(BAbstractSchedule schedule) throws Exception {
        ScheduleValidator.validate(schedule, Lexicon.make((String)"schedule"));
    }

    private static void validate(BAbstractSchedule schedule, Lexicon lex) throws Exception {
        if (schedule instanceof BDateRangeSchedule) {
            BDateRangeSchedule sch = (BDateRangeSchedule)schedule;
            ScheduleValidator.verify(sch.getStart(), lex);
            ScheduleValidator.verify(sch.getEnd(), lex);
            int start = sch.getStart().getYear();
            int end = sch.getEnd().getYear();
            if (start >= 0 && end >= 0) {
                if (start > end) {
                    throw new RuntimeException(lex.getText("daterange.startAfterEnd"));
                }
                if (start == end) {
                    start = sch.getStart().getMonth();
                    end = sch.getEnd().getMonth();
                    if (start >= 0 && end >= 0) {
                        if (start > end) {
                            throw new RuntimeException(lex.getText("daterange.startAfterEnd"));
                        }
                        if (start == end) {
                            start = sch.getStart().getDay();
                            end = sch.getEnd().getDay();
                            if (start >= 0 && end >= 0 && start > end) {
                                throw new RuntimeException(lex.getText("daterange.startAfterEnd"));
                            }
                        }
                    }
                }
            }
        } else if (schedule instanceof BDateSchedule) {
            ScheduleValidator.verify((BDateSchedule)schedule, lex);
        }
    }

    private static void verify(BDateSchedule sch, Lexicon lex) {
        BAbsTime t;
        int d = sch.getDay();
        int m = sch.getMonth();
        int y = sch.getYear();
        int w = sch.getWeekday();
        if (w >= 0 && d > 0 && m >= 0 && y >= 0 && (t = BAbsTime.make((int)sch.getYear(), (BMonth)BMonth.make((int)sch.getMonth()), (int)sch.getDay())).getWeekday().getOrdinal() != sch.getWeekday()) {
            throw new RuntimeException(lex.getText("date.invalidDate") + ": " + (Object)((Object)sch));
        }
        if (d > 0 && m >= 0) {
            int dim;
            if (y < 0) {
                y = Clock.time().getYear();
            }
            if (d > (dim = BAbsTime.getDaysInMonth((int)y, (BMonth)BMonth.make((int)m)))) {
                throw new RuntimeException(lex.getText("date.invalidDate") + ": " + (Object)((Object)sch));
            }
        }
    }
}

