/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import com.tridium.sys.metrics.Metrics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="union", type="boolean", defaultValue="true", flags=0x10000000)})
public class BCompositeSchedule
extends BAbstractSchedule {
    @Generated
    public static final Property status = BCompositeSchedule.newProperty((int)75, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BCompositeSchedule.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property union = BCompositeSchedule.newProperty((int)0x10000000, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCompositeSchedule.class);
    private BAbstractSchedule[] cache = null;
    private int hint = 20;
    private boolean fatalFault;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public boolean getUnion() {
        return this.getBoolean(union);
    }

    @Generated
    public void setUnion(boolean v) {
        this.setBoolean(union, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void add(BAbstractSchedule sch) {
        String name = "sch";
        int i = 0;
        while (this.get(name + i) != null) {
            ++i;
        }
        this.add(name + i, (BValue)sch);
    }

    @Override
    public BAbstractSchedule getOutputSource(BAbsTime at) {
        if (!this.isEffective(at)) {
            return null;
        }
        if (this.getEffectiveValue() != null) {
            return this;
        }
        BAbstractSchedule[] children = this.getSchedules();
        int len = children.length;
        for (int i = 0; i < len; ++i) {
            BAbstractSchedule out = children[i].getOutputSource(at);
            if (out == null) continue;
            return out;
        }
        return null;
    }

    public BCompositeSchedule initUnion(boolean value) {
        this.setUnion(value);
        return this;
    }

    @Override
    public boolean isEffective(BAbsTime at) {
        if (this.fatalFault) {
            return false;
        }
        if (this.getAlwaysEffective()) {
            return true;
        }
        BAbstractSchedule[] children = this.getSchedules();
        int i = children.length;
        boolean younion = this.getUnion();
        boolean effective = true;
        if (younion) {
            effective = false;
        }
        while (--i >= 0) {
            boolean val = children[i].isEffective(at);
            if (younion) {
                if (!(effective = effective || val)) continue;
                return true;
            }
            effective = effective && val;
        }
        return effective;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                if (!(this.get((Property)a) instanceof BAbstractSchedule)) break;
                this.cache = null;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                this.cache = null;
                break;
            }
            case 12: {
                this.cache = null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        if (!Metrics.incrementSchedule((BComplex)this)) {
            this.fatalFault = true;
            BAbstractSchedule.log.severe("Exceeded schedule limit for globalCapacity");
            this.setFaultCause("Exceeded schedule limit for globalCapacity");
            this.setStatus(BStatus.fault);
            BValue out = this.get("out");
            if (out instanceof BStatusBoolean) {
                ((BStatusBoolean)out).setStatusFault(true);
            }
        }
    }

    public BAbstractSchedule[] getSchedules() {
        BAbstractSchedule[] tmp;
        if (this.cache != null) {
            return this.cache;
        }
        BAbstractSchedule[] ret = null;
        SlotCursor c = this.loadSlots().getProperties();
        int count = 0;
        while (c.next()) {
            BValue o = c.get();
            if (!(o instanceof BAbstractSchedule)) continue;
            if (ret == null) {
                ret = new BAbstractSchedule[this.hint];
            }
            ret[count] = (BAbstractSchedule)o;
            if (++count != this.hint) continue;
            this.hint += 20;
            tmp = new BAbstractSchedule[this.hint];
            System.arraycopy(ret, 0, tmp, 0, count);
            ret = tmp;
        }
        if (count == 0) {
            this.cache = new BAbstractSchedule[0];
            return this.cache;
        }
        if (ret.length != count) {
            tmp = new BAbstractSchedule[count];
            System.arraycopy(ret, 0, tmp, 0, count);
            ret = tmp;
        }
        if (count > 0) {
            this.hint = count;
        }
        this.cache = ret;
        return ret;
    }

    @Override
    public BAbsTime nextEvent(BAbsTime after) {
        if (this.fatalFault) {
            return null;
        }
        BAbstractSchedule[] children = this.getSchedules();
        if (children.length == 0) {
            return null;
        }
        boolean intersection = !this.getUnion();
        boolean effective = false;
        int len = children.length;
        BAbsTime soonest = null;
        BAbsTime tmp = null;
        for (int i = 0; i < len; ++i) {
            tmp = children[i].nextEvent(after);
            if (tmp == null) {
                effective = children[i].isEffective(after);
                if (!(intersection ? !effective : effective)) continue;
                return null;
            }
            if (soonest == null) {
                soonest = tmp;
                continue;
            }
            if (tmp.compareTo((Object)soonest) >= 0) continue;
            soonest = tmp;
        }
        return soonest;
    }
}

