/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import java.util.Vector;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDaySchedule
extends BCompositeSchedule {
    @Generated
    public static final Type TYPE = Sys.loadType(BDaySchedule.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean add(BTimeSchedule range, Context cx) {
        BTimeSchedule[] kids = (BTimeSchedule[])this.getChildren(BTimeSchedule.class);
        int len = kids.length;
        BTime start = range.getStart();
        BTime finish = range.getFinish();
        boolean midnightFinish = finish.equals((Object)BTime.MIDNIGHT);
        boolean midnightStart = start.equals((Object)BTime.MIDNIGHT);
        while (--len >= 0) {
            boolean bothAfter;
            BTime kidStart = kids[len].getStart();
            BTime kidFinish = kids[len].getFinish();
            boolean midnightKidFinish = kidFinish.equals((Object)BTime.MIDNIGHT);
            boolean bothBefore = !midnightFinish && start.isBefore(kidStart) && !finish.isAfter(kidStart);
            boolean bl = bothAfter = !midnightStart && !midnightKidFinish && !start.isBefore(kidFinish) && (!finish.isBefore(kidFinish) || midnightFinish);
            if (bothBefore || bothAfter) continue;
            return false;
        }
        this.add("time?", (BValue)range, cx);
        return true;
    }

    public boolean add(BTimeSchedule range) {
        return this.add(range, null);
    }

    public boolean add(BTime start, BTime finish, BStatusValue value) {
        return this.add(start, finish, value, null);
    }

    public boolean add(BTime start, BTime finish, BStatusValue value, Context cx) {
        BTimeSchedule sch = new BTimeSchedule(start, finish);
        sch.setEffectiveValue(value);
        return this.add(sch, cx);
    }

    public boolean addTrigger(int hour, int min) {
        return this.add(new BTimeSchedule(BTime.make((int)hour, (int)min, (int)0), BTime.make((int)hour, (int)min, (int)20)));
    }

    public BDaySchedule clear() {
        Vector<Property> v = new Vector<Property>();
        SlotCursor c = this.getProperties();
        while (c.next(BTimeSchedule.class)) {
            v.addElement(c.property());
        }
        int i = v.size();
        while (--i >= 0) {
            this.remove((Property)v.elementAt(i));
        }
        return this;
    }

    public BTimeSchedule effectiveAt(BTime time) {
        Object[] kids = this.getChildren(BTimeSchedule.class);
        int len = kids.length;
        while (--len >= 0) {
            if (!BDaySchedule.cast(kids[len]).isEffective(time)) continue;
            return BDaySchedule.cast(kids[len]);
        }
        return null;
    }

    public BTimeSchedule[] getTimesInOrder() {
        BTimeSchedule[] ret = (BTimeSchedule[])this.getChildren(BTimeSchedule.class);
        int i = ret.length;
        while (--i > 0) {
            int j = i;
            while (--j >= 0) {
                if (!ret[i].getStart().isBefore(ret[j].getStart())) continue;
                BTimeSchedule tmp = ret[j];
                ret[j] = ret[i];
                ret[i] = tmp;
            }
        }
        return ret;
    }

    private static final BTimeSchedule cast(Object o) {
        return (BTimeSchedule)((Object)o);
    }
}

