/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import javax.baja.converters.BNumericToSimpleMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.EllipseGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="value", type="double", defaultValue="0"), @NiagaraProperty(name="text", type="String", defaultValue=""), @NiagaraProperty(name="startAngle", type="int", defaultValue="240"), @NiagaraProperty(name="arcAngle", type="int", defaultValue="300"), @NiagaraProperty(name="min", type="double", defaultValue="0"), @NiagaraProperty(name="max", type="double", defaultValue="100"), @NiagaraProperty(name="numDivisions", type="int", defaultValue="10"), @NiagaraProperty(name="numSubDivisions", type="int", defaultValue="5"), @NiagaraProperty(name="showSubDivisions", type="boolean", defaultValue="true"), @NiagaraProperty(name="valueVisible", type="boolean", defaultValue="true"), @NiagaraProperty(name="valueFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="scaleVisible", type="boolean", defaultValue="true"), @NiagaraProperty(name="scaleFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="needlePen", type="BPen", defaultValue="BPen.DEFAULT"), @NiagaraProperty(name="needleBrush", type="BBrush", defaultValue="BColor.red.toBrush()"), @NiagaraProperty(name="background", type="BBrush", defaultValue="BColor.make(0xcccccc).toBrush()"), @NiagaraProperty(name="foreground", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="fillCircle", type="boolean", defaultValue="true"), @NiagaraProperty(name="ranges", type="BNumericToSimpleMap", defaultValue="BNumericToSimpleMap.NULL", flags=4)})
public class BAnalogMeter
extends BWidget {
    @Generated
    public static final Property value = BAnalogMeter.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property text = BAnalogMeter.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property startAngle = BAnalogMeter.newProperty((int)0, (int)240, null);
    @Generated
    public static final Property arcAngle = BAnalogMeter.newProperty((int)0, (int)300, null);
    @Generated
    public static final Property min = BAnalogMeter.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property max = BAnalogMeter.newProperty((int)0, (int)100, null);
    @Generated
    public static final Property numDivisions = BAnalogMeter.newProperty((int)0, (int)10, null);
    @Generated
    public static final Property numSubDivisions = BAnalogMeter.newProperty((int)0, (int)5, null);
    @Generated
    public static final Property showSubDivisions = BAnalogMeter.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property valueVisible = BAnalogMeter.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property valueFont = BAnalogMeter.newProperty((int)0, (BValue)BFont.NULL, null);
    @Generated
    public static final Property scaleVisible = BAnalogMeter.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property scaleFont = BAnalogMeter.newProperty((int)0, (BValue)BFont.NULL, null);
    @Generated
    public static final Property needlePen = BAnalogMeter.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    @Generated
    public static final Property needleBrush = BAnalogMeter.newProperty((int)0, (BValue)BColor.red.toBrush(), null);
    @Generated
    public static final Property background = BAnalogMeter.newProperty((int)0, (BValue)BColor.make((int)0xCCCCCC).toBrush(), null);
    @Generated
    public static final Property foreground = BAnalogMeter.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Property fillCircle = BAnalogMeter.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property ranges = BAnalogMeter.newProperty((int)4, (BValue)BNumericToSimpleMap.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAnalogMeter.class);
    static Lexicon lex = Lexicon.make((String)"kitPx");
    static BFont defValueFont = BFont.make((String)lex.getText("analogMeter.value.font"));
    static BFont defScaleFont = BFont.make((String)lex.getText("analogMeter.scale.font"));
    private static final double TO_RAD = Math.PI / 180;
    private static final double HALF_PI = 1.5707963267948966;
    private static final double THREE_HALF_PI = 4.71238898038469;
    private static final double TWO_PI = Math.PI * 2;
    private double size = 0.0;
    private double px = 0.0;
    private double py = 0.0;
    private double radius = 0.0;
    private double cx = 0.0;
    private double cy = 0.0;
    private IGeom geom = null;

    @Generated
    public double getValue() {
        return this.getDouble(value);
    }

    @Generated
    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    @Generated
    public String getText() {
        return this.getString(text);
    }

    @Generated
    public void setText(String v) {
        this.setString(text, v, null);
    }

    @Generated
    public int getStartAngle() {
        return this.getInt(startAngle);
    }

    @Generated
    public void setStartAngle(int v) {
        this.setInt(startAngle, v, null);
    }

    @Generated
    public int getArcAngle() {
        return this.getInt(arcAngle);
    }

    @Generated
    public void setArcAngle(int v) {
        this.setInt(arcAngle, v, null);
    }

    @Generated
    public double getMin() {
        return this.getDouble(min);
    }

    @Generated
    public void setMin(double v) {
        this.setDouble(min, v, null);
    }

    @Generated
    public double getMax() {
        return this.getDouble(max);
    }

    @Generated
    public void setMax(double v) {
        this.setDouble(max, v, null);
    }

    @Generated
    public int getNumDivisions() {
        return this.getInt(numDivisions);
    }

    @Generated
    public void setNumDivisions(int v) {
        this.setInt(numDivisions, v, null);
    }

    @Generated
    public int getNumSubDivisions() {
        return this.getInt(numSubDivisions);
    }

    @Generated
    public void setNumSubDivisions(int v) {
        this.setInt(numSubDivisions, v, null);
    }

    @Generated
    public boolean getShowSubDivisions() {
        return this.getBoolean(showSubDivisions);
    }

    @Generated
    public void setShowSubDivisions(boolean v) {
        this.setBoolean(showSubDivisions, v, null);
    }

    @Generated
    public boolean getValueVisible() {
        return this.getBoolean(valueVisible);
    }

    @Generated
    public void setValueVisible(boolean v) {
        this.setBoolean(valueVisible, v, null);
    }

    @Generated
    public BFont getValueFont() {
        return (BFont)this.get(valueFont);
    }

    @Generated
    public void setValueFont(BFont v) {
        this.set(valueFont, (BValue)v, null);
    }

    @Generated
    public boolean getScaleVisible() {
        return this.getBoolean(scaleVisible);
    }

    @Generated
    public void setScaleVisible(boolean v) {
        this.setBoolean(scaleVisible, v, null);
    }

    @Generated
    public BFont getScaleFont() {
        return (BFont)this.get(scaleFont);
    }

    @Generated
    public void setScaleFont(BFont v) {
        this.set(scaleFont, (BValue)v, null);
    }

    @Generated
    public BPen getNeedlePen() {
        return (BPen)this.get(needlePen);
    }

    @Generated
    public void setNeedlePen(BPen v) {
        this.set(needlePen, (BValue)v, null);
    }

    @Generated
    public BBrush getNeedleBrush() {
        return (BBrush)this.get(needleBrush);
    }

    @Generated
    public void setNeedleBrush(BBrush v) {
        this.set(needleBrush, (BValue)v, null);
    }

    @Generated
    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    @Generated
    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    @Generated
    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    @Generated
    public void setForeground(BBrush v) {
        this.set(foreground, (BValue)v, null);
    }

    @Generated
    public boolean getFillCircle() {
        return this.getBoolean(fillCircle);
    }

    @Generated
    public void setFillCircle(boolean v) {
        this.setBoolean(fillCircle, v, null);
    }

    @Generated
    public BNumericToSimpleMap getRanges() {
        return (BNumericToSimpleMap)this.get(ranges);
    }

    @Generated
    public void setRanges(BNumericToSimpleMap v) {
        this.set(ranges, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        this.setPreferredSize(100.0, 100.0);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.getStartAngle() <= 180 && this.getArcAngle() <= 180 && !this.getFillCircle()) {
            BFont sfont;
            double temp = h * 2.0;
            this.size = Math.min(w - 1.0, temp - 1.0);
            BFont vfont = this.getValueFont();
            if (vfont.isNull()) {
                vfont = defValueFont;
            }
            if ((sfont = this.getScaleFont()).isNull()) {
                sfont = defScaleFont;
            }
            double diff = 0.0;
            if (this.getValueVisible()) {
                diff = vfont.getHeight() + vfont.getDescent();
            } else if (this.getScaleVisible()) {
                diff = sfont.getHeight();
            }
            if (this.size / 2.0 + diff >= h) {
                this.size = (h - diff - 1.0) * 2.0;
            }
            this.px = (w - this.size) / 2.0;
            this.py = (temp - this.size) / 2.0 - diff;
            this.cx = this.px + this.size / 2.0;
            this.cy = this.py + this.size / 2.0;
        } else {
            this.size = Math.min(w - 1.0, h - 1.0);
            this.px = (w - this.size) / 2.0;
            this.py = (h - this.size) / 2.0;
            this.cx = this.px + this.size / 2.0;
            this.cy = this.py + this.size / 2.0;
        }
        this.radius = this.size / 2.0;
        this.geom = this.getFillCircle() ? new EllipseGeom(this.px, this.py, this.size, this.size) : null;
    }

    public void paint(Graphics g) {
        BFont sfont;
        double value = this.getValue();
        double sa = this.getStartAngle();
        double aa = this.getArcAngle();
        double mn = this.getMin();
        double mx = this.getMax();
        BFont vfont = this.getValueFont();
        if (vfont.isNull()) {
            vfont = defValueFont;
        }
        if ((sfont = this.getScaleFont()).isNull()) {
            sfont = defScaleFont;
        }
        if (!this.getBackground().isNull()) {
            g.setBrush(this.getBackground());
            if (this.geom != null) {
                g.fill(this.geom);
            }
        }
        g.setBrush(this.getForeground());
        if (this.geom != null) {
            g.stroke(this.geom);
        }
        double angle = sa;
        angle = value <= mn ? sa * (Math.PI / 180) : (value >= mx ? (sa - aa) * (Math.PI / 180) : (sa - (value - mn) / (mx - mn) * aa) * (Math.PI / 180));
        int dx = (int)(Math.cos(angle) * this.radius);
        int dy = (int)(Math.sin(angle) * this.radius);
        BPen currentPen = g.getPen();
        g.setPen(this.getNeedlePen());
        g.setBrush(this.getNeedleBrush());
        g.strokeLine(this.cx, this.cy, this.cx + (double)dx, this.cy - (double)dy);
        g.setPen(currentPen);
        String s = this.getText();
        g.setFont(vfont);
        g.setBrush(this.getForeground());
        if (this.getValueVisible()) {
            g.drawString(s, this.cx - vfont.width(s) / 2.0, this.cy + vfont.getHeight());
        }
        int numDiv = this.getNumDivisions();
        int subDiv = this.getNumSubDivisions();
        double subAngle = aa / (double)numDiv;
        double dv = (mx - mn) / (double)numDiv;
        g.setFont(sfont);
        for (int i = 0; i <= numDiv; ++i) {
            double a = (sa - subAngle * (double)i) * (Math.PI / 180);
            double cos = Math.cos(a);
            double sin = Math.sin(a);
            double tx = this.cx + (double)((int)(cos * this.radius));
            double ty = this.cy - (double)((int)(sin * this.radius));
            double tx2 = this.cx + (double)((int)(cos * this.radius * 0.95));
            double ty2 = this.cy - (double)((int)(sin * this.radius * 0.95));
            g.strokeLine(tx, ty, tx2, ty2);
            if (this.getShowSubDivisions() && i < numDiv) {
                double sda = subAngle / (double)subDiv;
                for (int j = 0; j <= subDiv; ++j) {
                    double za = (sa - subAngle * (double)i - sda * (double)j) * (Math.PI / 180);
                    double scos = Math.cos(za);
                    double ssin = Math.sin(za);
                    double stx = this.cx + (double)((int)(scos * this.radius));
                    double sty = this.cy - (double)((int)(ssin * this.radius));
                    double stx2 = this.cx + (double)((int)(scos * this.radius * 0.98));
                    double sty2 = this.cy - (double)((int)(ssin * this.radius * 0.98));
                    g.strokeLine(stx, sty, stx2, sty2);
                }
            }
            if (!this.getScaleVisible()) continue;
            double tx3 = this.cx + (double)((int)(cos * this.radius * 0.9));
            double ty3 = this.cy - (double)((int)(sin * this.radius * 0.9));
            String str = Integer.toString((int)(mn + dv * (double)i));
            if (a == 0.0 || a == Math.PI) {
                ty3 += sfont.getAscent() / 2.0;
            } else if (a == 1.5707963267948966) {
                ty3 += sfont.getAscent();
            } else if (a > 0.0 && a < Math.PI) {
                ty3 += sfont.getAscent();
            }
            if (a < 0.0) {
                a = -a;
            }
            if (a == 1.5707963267948966 || a == 4.71238898038469) {
                tx3 -= sfont.width(str) / 2.0;
            } else if (a >= 0.0 && a < 1.5707963267948966) {
                tx3 -= sfont.width(str);
            } else if (a > 4.71238898038469 && a <= Math.PI * 2) {
                tx3 -= sfont.width(str);
            }
            g.drawString(str, tx3, ty3);
        }
    }
}

