/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BGroupLevelDef;
import javax.baja.hierarchy.BHierarchy;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BHierarchyTags;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.BListLevelDef;
import javax.baja.hierarchy.BNamedGroupDef;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconText;
import javax.baja.virtual.BVirtualComponent;

public final class MakeElemUtil {
    private static final Logger LOGGER = Logger.getLogger("hierarchy");
    private static final BIcon HIERARCHY_ELEM_ICON = BIcon.std((String)"r2/tree.png");
    private static final BIcon FALLBACK_ENTITY_ICON = BIcon.std((String)"object.png");
    private static final BIcon FALLBACK_GROUPING_ICON = BIcon.std((String)"folder.png");
    private static final LexiconText LEXICON_NAME_UNKNOWN = LexiconText.make((String)"hierarchy", (String)"name.unknown");
    private static final String[] EMPTY_STRING_ARR = new String[0];
    private static final BIDataValue[] EMPTY_DATA_VALUE_ARR = new BIDataValue[0];
    public static final Id ORD_IN_SESSION_ID = Id.newId((String)"n:ordInSession");
    public static final Id DISPLAY_NAME_ID = Id.newId((String)"n:displayName");
    public static final Id TYPE_ID = Id.newId((String)"n:type");

    private MakeElemUtil() {
    }

    private static BLevelElem makeElem(BLevelDef levelDef, BLevelElem parent, String name, String displayName, BIcon icon, String childPredicate, Entity entity, BHierarchyTags tags, BFacets newContextParams) {
        BFacets contextParams = MakeElemUtil.getResolvedContextParams(levelDef, entity, SlotPath.escape((String)name), childPredicate, parent != null ? parent.getContextParams() : BFacets.DEFAULT, newContextParams);
        tags.addOrSet(BLevelDef.DISPLAY_NAME_TAG_NAME, (BValue)BString.make((String)displayName));
        return new BLevelElem(levelDef, parent, name, icon, contextParams, tags.toFacets());
    }

    public static BLevelElem makeHierarchyElem(BHierarchy hierarchy, Context context) {
        return MakeElemUtil.makeElem(hierarchy, null, hierarchy.getName(), hierarchy.getDisplayName(context), HIERARCHY_ELEM_ICON, "", null, hierarchy.getTags(), BFacets.DEFAULT);
    }

    public static BLevelElem makeGroupElem(BGroupLevelDef groupDef, BLevelElem parent, String groupingBase, String groupName, BIDataValue groupTagValue, BIcon icon) {
        String groupBy = groupDef.getGroupBy();
        String childPredicate = groupingBase + '(' + groupBy + " = " + (groupTagValue instanceof BString ? '\"' + groupTagValue.toString() + '\"' : groupTagValue.toString()) + ')';
        BHierarchyTags tags = (BHierarchyTags)groupDef.getTags().newCopy();
        if (parent != null) {
            tags.merge(parent.getElemTags(), false);
        }
        tags.addOrSet(SlotPath.escape((String)groupBy.trim()), (BValue)groupTagValue);
        return MakeElemUtil.makeElem(groupDef, parent, groupName, groupName, icon, childPredicate, null, tags, BFacets.make((String)SlotPath.escape((String)groupBy), (BIDataValue)groupTagValue));
    }

    public static BLevelElem makeListElem(BListLevelDef listDef, BNamedGroupDef namedGroupDef, BLevelElem parent, BIcon icon, String groupingBase, Context context) {
        String childPredicate = groupingBase + '(' + namedGroupDef.getQuery() + ')';
        LOGGER.fine(() -> "BListLevelDef(" + listDef.getName() + ").getElements: neql: " + childPredicate);
        BHierarchyTags tags = (BHierarchyTags)listDef.getTags().newCopy();
        tags.merge(namedGroupDef.getTags());
        if (parent != null) {
            tags.merge(parent.getElemTags(), false);
        }
        return MakeElemUtil.makeElem(listDef, parent, namedGroupDef.getName(), namedGroupDef.getDisplayName(context), icon, childPredicate, null, tags, BFacets.DEFAULT);
    }

    public static BLevelElem makeEntityElem(Entity entity, BLevelDef levelDef, BLevelElem parent, Map<String, BIcon> iconCache, Context context) {
        BIcon icon;
        String displayName;
        String name;
        if (entity instanceof BComponent) {
            BComponent comp = (BComponent)entity;
            name = MakeElemUtil.toOrdInSession(comp).toString();
            displayName = comp.getDisplayName(context);
            icon = comp.getIcon();
        } else {
            Tags entityTags = entity.tags();
            Optional ordInSessionTagValue = entityTags.get(ORD_IN_SESSION_ID);
            if (ordInSessionTagValue.isPresent()) {
                name = ((BIDataValue)ordInSessionTagValue.get()).toString();
            } else {
                Optional ordToEntity = entity.getOrdToEntity();
                if (ordToEntity.isPresent() && !((BOrd)ordToEntity.get()).isNull()) {
                    name = ((BOrd)ordToEntity.get()).toString();
                } else {
                    throw new IllegalStateException("Cannot create level elem for entity  under level elem " + parent.getHierarchyOrd() + "; entity is missing n:ordInSession tag and ordToEntity");
                }
            }
            Optional displayNameTagValue = entityTags.get(DISPLAY_NAME_ID);
            if (displayNameTagValue.isPresent()) {
                displayName = ((BIDataValue)displayNameTagValue.get()).toString();
            } else {
                displayName = name;
                LOGGER.fine(() -> "Creating level elem for entity " + entity.getOrdToEntity().orElse(BOrd.NULL) + " under level elem " + parent.getHierarchyOrd() + "; entity is missing n:displayName tag; using elem name");
            }
            icon = MakeElemUtil.getEntityIcon(name, entityTags, iconCache);
        }
        BHierarchyTags tags = new BHierarchyTags();
        tags.merge(parent.getElemTags());
        return MakeElemUtil.makeElem(levelDef, parent, name, displayName, icon, "", entity, tags, BFacets.DEFAULT);
    }

    private static BIcon getEntityIcon(String entityName, Tags entityTags, Map<String, BIcon> iconCache) {
        String entityType = null;
        try {
            BIcon icon;
            entityType = ((BIDataValue)entityTags.get(TYPE_ID).get()).toString();
            if (iconCache != null && (icon = iconCache.get(entityType)) != null) {
                return icon;
            }
            icon = BTypeSpec.make((String)entityType).getInstance().getIcon();
            if (icon == null) {
                String type = entityType;
                LOGGER.fine(() -> "While getting icon for entity " + entityName + ", icon was null for type " + type);
                icon = FALLBACK_ENTITY_ICON;
            }
            if (iconCache != null) {
                iconCache.put(entityType, icon);
            }
            return icon;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e, () -> "Exception getting icon for entity " + entityName);
            if (entityType == null) {
                return FALLBACK_ENTITY_ICON;
            }
            if (iconCache != null) {
                iconCache.put(entityType, FALLBACK_ENTITY_ICON);
            }
            return FALLBACK_ENTITY_ICON;
        }
    }

    public static BIcon getGroupIcon(BComponent component) {
        if (!(component instanceof BGroupLevelDef) && !(component instanceof BNamedGroupDef)) {
            throw new IllegalArgumentException("Only types BGroupLevelDef and BNamedGroupDef are supported");
        }
        BValue icon = component.get("icon");
        return icon instanceof BIcon ? (BIcon)icon : FALLBACK_GROUPING_ICON;
    }

    public static String getGroupName(BIDataValue groupByValue, Context context) {
        String groupName = groupByValue.toString();
        if (groupName == null || groupName.isEmpty()) {
            groupName = LEXICON_NAME_UNKNOWN.getText(context);
        }
        return groupName;
    }

    public static BFacets getResolvedContextParams(BLevelDef levelDef, Entity entity, String pathName, String childPredicate, BFacets existing, BFacets newParams) {
        Tags entityTags = entity == null ? null : entity.tags();
        ConcurrentHashMap<String, Object> newValues = new ConcurrentHashMap<String, Object>();
        for (String key : existing.list()) {
            newValues.put(key, (BIDataValue)existing.getFacet(key));
        }
        BFacets queryContext = levelDef.getQueryContext();
        for (String key : queryContext.list()) {
            Optional tagValue;
            BIDataValue value = (BIDataValue)queryContext.getFacet(key);
            if (entity != null && value instanceof BString && (tagValue = entityTags.get(Id.newId((String)value.toString()))).isPresent()) {
                value = (BIDataValue)tagValue.get();
            }
            newValues.put(key, value);
        }
        for (String key : newParams.list()) {
            newValues.put(key, (BIDataValue)newParams.getFacet(key));
        }
        BOrd entityOrd = BOrd.NULL;
        if (entity instanceof BComponent) {
            entityOrd = MakeElemUtil.toOrdInSession((BComponent)entity);
        } else if (entity != null && entity.getOrdToEntity().isPresent()) {
            entityOrd = (BOrd)entity.getOrdToEntity().get();
        }
        newValues.put("entityOrd", entityOrd);
        BOrd hierarchyOrd = (BOrd)newValues.get("hierarchyOrd");
        String base = hierarchyOrd == null ? "hierarchy:" : hierarchyOrd.toString();
        newValues.put("hierarchyOrd", BOrd.make((String)(base + '/' + pathName)));
        newValues.put("levelDefPath", BString.make((String)MakeElemUtil.getLevelDefPath(levelDef)));
        newValues.put("childPredicate", BString.make((String)childPredicate));
        String entityTypeSpec = "baja:Component";
        if (entity != null) {
            Optional typeSpec = entityTags.get(TYPE_ID);
            if (typeSpec.isPresent()) {
                entityTypeSpec = ((BIDataValue)typeSpec.get()).toString();
            } else if (entity instanceof BObject) {
                entityTypeSpec = ((BObject)entity).getType().toString();
            }
        }
        newValues.put("typeSpec", BString.make((String)entityTypeSpec));
        return BFacets.make((String[])((ConcurrentHashMap.CollectionView)((Object)newValues.keySet())).toArray(EMPTY_STRING_ARR), (BIDataValue[])newValues.values().toArray(EMPTY_DATA_VALUE_ARR));
    }

    private static BOrd toOrdInSession(BComponent comp) {
        return comp.getType().is(BVirtualComponent.TYPE) ? comp.getNavOrd().relativizeToSession() : comp.getOrdInSession();
    }

    public static String getLevelDefPath(BLevelDef levelDef) {
        BHierarchyService service = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
        return levelDef.getSlotPath().toString().substring(service.getSlotPath().toString().length());
    }
}

