/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import com.tridium.hierarchy.HierarchyUtil;
import com.tridium.hierarchy.MakeElemUtil;
import com.tridium.hierarchy.QueryUtil;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BHierarchyTags;
import javax.baja.hierarchy.BIGroupingLevelDef;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.BLevelSort;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.user.BUser;
import javax.baja.util.CloseableIterator;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="groupBy", type="String", defaultValue=""), @NiagaraProperty(name="includeEmptyGroups", type="boolean", defaultValue="false"), @NiagaraProperty(name="sort", type="BLevelSort", defaultValue="BLevelSort.ascending"), @NiagaraProperty(name="tags", type="BHierarchyTags", defaultValue="new BHierarchyTags()")})
public class BGroupLevelDef
extends BLevelDef
implements BIGroupingLevelDef {
    @Generated
    public static final Property groupBy = BGroupLevelDef.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property includeEmptyGroups = BGroupLevelDef.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property sort = BGroupLevelDef.newProperty((int)0, (BValue)BLevelSort.ascending, null);
    @Generated
    public static final Property tags = BGroupLevelDef.newProperty((int)0, (BValue)new BHierarchyTags(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BGroupLevelDef.class);
    private static final Logger LOGGER = Logger.getLogger("hierarchy");

    @Generated
    public String getGroupBy() {
        return this.getString(groupBy);
    }

    @Generated
    public void setGroupBy(String v) {
        this.setString(groupBy, v, null);
    }

    @Generated
    public boolean getIncludeEmptyGroups() {
        return this.getBoolean(includeEmptyGroups);
    }

    @Generated
    public void setIncludeEmptyGroups(boolean v) {
        this.setBoolean(includeEmptyGroups, v, null);
    }

    @Generated
    public BLevelSort getSort() {
        return (BLevelSort)this.get(sort);
    }

    @Generated
    public void setSort(BLevelSort v) {
        this.set(sort, (BValue)v, null);
    }

    @Generated
    public BHierarchyTags getTags() {
        return (BHierarchyTags)this.get(tags);
    }

    @Generated
    public void setTags(BHierarchyTags v) {
        this.set(tags, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public BLevelElem[] getElements(BLevelElem parent, Context cx) {
        try {
            String groupingBase = HierarchyUtil.getGroupingBase(this, true, parent);
            String groupByStr = this.getGroupBy().trim();
            String neql = "neql:" + groupingBase + '(' + groupByStr + ')';
            if (!this.getIncludeEmptyGroups()) {
                Optional<String> excludeEmptiesQuery = HierarchyUtil.getExcludeEmptyGroupsQuery(this);
                if (excludeEmptiesQuery.isPresent()) {
                    neql = neql + excludeEmptiesQuery.get();
                } else {
                    LOGGER.warning(() -> "Could not resolve elements for " + this.getName() + " because a subsequent level def is not valid.");
                    return EMPTY_LEVEL_ELEMS;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BGroupLevelDef(" + this.getName() + ").getElements: " + neql);
            }
            BOrd neqlQuery = BOrd.make((String)neql);
            BUser user = HierarchyUtil.getUser();
            Context queryContext = HierarchyUtil.createQueryContext(user, cx, parent, new AbstractMap.SimpleEntry<String, BString>("distinctTag", BString.make((String)groupByStr)));
            LinkedHashMap<String, BLevelElem> groupElems = new LinkedHashMap<String, BLevelElem>();
            try (CloseableIterator<Entity> queryResults = QueryUtil.resolveQueryOnScopes(this, neqlQuery, null, this.getHierarchyService().getHierarchyTimeout(), queryContext);){
                BIcon groupIcon = MakeElemUtil.getGroupIcon(this);
                Id groupByTagId = Id.newId((String)groupByStr);
                while (queryResults.hasNext()) {
                    Entity entity = (Entity)queryResults.next();
                    Optional groupTagValue = entity.tags().get(groupByTagId);
                    if (!groupTagValue.isPresent()) continue;
                    String groupName = MakeElemUtil.getGroupName((BIDataValue)groupTagValue.get(), queryContext);
                    groupElems.computeIfAbsent(groupName, k -> MakeElemUtil.makeGroupElem(this, parent, groupingBase, groupName, (BIDataValue)groupTagValue.get(), groupIcon));
                }
            }
            BLevelElem[] elems = groupElems.values().toArray(new BLevelElem[0]);
            BGroupLevelDef.sortElems(elems, this.getSort());
            return elems;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e, () -> "Could not resolve elements for " + this.getName());
            return EMPTY_LEVEL_ELEMS;
        }
    }

    public String toString(Context cx) {
        return "Group Level Def groupBy:  " + this.getGroupBy();
    }
}

