/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import com.tridium.hierarchy.HierarchyUtil;
import com.tridium.hierarchy.MakeElemUtil;
import com.tridium.hierarchy.QueryUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BIEntityLevelDef;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.BLevelSort;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.user.BUser;
import javax.baja.util.CloseableIterator;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="inboundRelationIds", type="String", defaultValue=""), @NiagaraProperty(name="outboundRelationIds", type="String", defaultValue=""), @NiagaraProperty(name="filterExpression", type="String", defaultValue=""), @NiagaraProperty(name="repeatRelation", type="boolean", defaultValue="false"), @NiagaraProperty(name="cachingRepeatLimit", type="int", defaultValue="5", facets={@Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="sort", type="BLevelSort", defaultValue="BLevelSort.ascending"), @NiagaraProperty(name="relationId", type="String", defaultValue="", flags=5, deprecated=true), @NiagaraProperty(name="inbound", type="boolean", defaultValue="true", flags=5, deprecated=true)})
public class BRelationLevelDef
extends BLevelDef
implements BIEntityLevelDef {
    @Generated
    public static final Property inboundRelationIds = BRelationLevelDef.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property outboundRelationIds = BRelationLevelDef.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property filterExpression = BRelationLevelDef.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property repeatRelation = BRelationLevelDef.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property cachingRepeatLimit = BRelationLevelDef.newProperty((int)0, (int)5, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Property sort = BRelationLevelDef.newProperty((int)0, (BValue)BLevelSort.ascending, null);
    @Deprecated
    @Generated
    public static final Property relationId = BRelationLevelDef.newProperty((int)5, (String)"", null);
    @Deprecated
    @Generated
    public static final Property inbound = BRelationLevelDef.newProperty((int)5, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRelationLevelDef.class);

    @Generated
    public String getInboundRelationIds() {
        return this.getString(inboundRelationIds);
    }

    @Generated
    public void setInboundRelationIds(String v) {
        this.setString(inboundRelationIds, v, null);
    }

    @Generated
    public String getOutboundRelationIds() {
        return this.getString(outboundRelationIds);
    }

    @Generated
    public void setOutboundRelationIds(String v) {
        this.setString(outboundRelationIds, v, null);
    }

    @Generated
    public String getFilterExpression() {
        return this.getString(filterExpression);
    }

    @Generated
    public void setFilterExpression(String v) {
        this.setString(filterExpression, v, null);
    }

    @Generated
    public boolean getRepeatRelation() {
        return this.getBoolean(repeatRelation);
    }

    @Generated
    public void setRepeatRelation(boolean v) {
        this.setBoolean(repeatRelation, v, null);
    }

    @Generated
    public int getCachingRepeatLimit() {
        return this.getInt(cachingRepeatLimit);
    }

    @Generated
    public void setCachingRepeatLimit(int v) {
        this.setInt(cachingRepeatLimit, v, null);
    }

    @Generated
    public BLevelSort getSort() {
        return (BLevelSort)this.get(sort);
    }

    @Generated
    public void setSort(BLevelSort v) {
        this.set(sort, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getRelationId() {
        return this.getString(relationId);
    }

    @Deprecated
    @Generated
    public void setRelationId(String v) {
        this.setString(relationId, v, null);
    }

    @Deprecated
    @Generated
    public boolean getInbound() {
        return this.getBoolean(inbound);
    }

    @Deprecated
    @Generated
    public void setInbound(boolean v) {
        this.setBoolean(inbound, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.getRelationId().isEmpty()) {
            BHierarchyService.log.warning(() -> "Old relation level id exists and the value is: " + this.getRelationId());
        }
        if (this.getOutboundRelationIds().isEmpty() && this.getInboundRelationIds().isEmpty() && !this.getRelationId().isEmpty()) {
            BHierarchyService.log.fine(() -> "Mapping old config.bog to use new relation level definition format. Deprecated::relationId :" + this.getRelationId());
            if (this.getInbound()) {
                this.setInboundRelationIds(this.getRelationId());
            } else {
                this.setOutboundRelationIds(this.getRelationId());
            }
        }
        this.setRelationId("");
        this.setInbound(false);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == cachingRepeatLimit) {
            int minLimit = cachingRepeatLimit.getFacets().geti("min", 1);
            int value = this.getInt(property);
            if (value < minLimit) {
                this.setInt(property, minLimit);
                BHierarchyService.log.fine(() -> "Coerced cachingRepeatLimit value of " + value + " to minimum value of " + minLimit);
            }
        }
    }

    @Override
    public BLevelElem[] getElements(BLevelElem parent, Context cx) {
        try {
            Throwable throwable;
            CloseableIterator<Entity> entities;
            Optional<String> neql;
            BOrd traverseBaseOrd = HierarchyUtil.getTraverseBaseOrd(parent);
            String outboundRelationsIds = this.getOutboundRelationIds().trim();
            String inboundRelationIds = this.getInboundRelationIds().trim();
            String filterExpression = this.getFilterExpression().trim();
            BUser user = HierarchyUtil.getUser();
            Context queryContext = HierarchyUtil.createQueryContext(user, cx, parent, new Map.Entry[0]);
            if (BHierarchyService.log.isLoggable(Level.FINE)) {
                if (!outboundRelationsIds.isEmpty()) {
                    BHierarchyService.log.fine("BRelationLevelDef(" + this.getName() + ").getElements: " + traverseBaseOrd + " -> " + outboundRelationsIds);
                }
                if (!inboundRelationIds.isEmpty()) {
                    BHierarchyService.log.fine("BRelationLevelDef(" + this.getName() + ").getElements: " + traverseBaseOrd + " <- " + inboundRelationIds);
                }
                if (!filterExpression.isEmpty()) {
                    BHierarchyService.log.fine("  filter=" + filterExpression);
                }
                BHierarchyService.log.fine("  context=" + queryContext.getFacets());
            }
            BRelTime queryTimeout = this.getHierarchyService().getHierarchyTimeout();
            LinkedHashMap<BOrd, BLevelElem> levelElems = new LinkedHashMap<BOrd, BLevelElem>();
            ConcurrentHashMap<String, BIcon> iconCache = new ConcurrentHashMap<String, BIcon>();
            for (String relationId : HierarchyUtil.RELATION_ID_SPLIT.split(outboundRelationsIds)) {
                neql = HierarchyUtil.getTraverseNeqlPredicate(relationId, false, filterExpression);
                if (!neql.isPresent()) continue;
                entities = QueryUtil.resolveQueryOnScopes(this, BOrd.make((String)neql.get()), traverseBaseOrd, queryTimeout, queryContext);
                throwable = null;
                try {
                    while (entities.hasNext()) {
                        this.addToElements((Entity)entities.next(), levelElems, parent, iconCache, queryContext);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entities != null) {
                        if (throwable != null) {
                            try {
                                entities.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            entities.close();
                        }
                    }
                }
            }
            for (String relationId : HierarchyUtil.RELATION_ID_SPLIT.split(inboundRelationIds)) {
                neql = HierarchyUtil.getTraverseNeqlPredicate(relationId, true, filterExpression);
                if (!neql.isPresent()) continue;
                entities = QueryUtil.resolveQueryOnScopes(this, BOrd.make((String)neql.get()), traverseBaseOrd, queryTimeout, queryContext);
                throwable = null;
                try {
                    while (entities.hasNext()) {
                        this.addToElements((Entity)entities.next(), levelElems, parent, iconCache, queryContext);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (entities != null) {
                        if (throwable != null) {
                            try {
                                entities.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            entities.close();
                        }
                    }
                }
            }
            BLevelElem[] elems = levelElems.values().toArray(new BLevelElem[0]);
            BRelationLevelDef.sortElems(elems, this.getSort());
            return elems;
        }
        catch (Exception e) {
            BHierarchyService.log.log(Level.SEVERE, e, () -> "Could not resolve elements for " + this.getName());
            return EMPTY_LEVEL_ELEMS;
        }
    }

    private void addToElements(Entity entity, Map<BOrd, BLevelElem> levelElems, BLevelElem parent, Map<String, BIcon> iconCache, Context context) {
        Optional ord = entity.getOrdToEntity();
        if (!ord.isPresent() || levelElems.containsKey(ord.get())) {
            return;
        }
        levelElems.put((BOrd)ord.get(), MakeElemUtil.makeEntityElem(entity, this, parent, iconCache, context));
    }

    public String toString(Context cx) {
        String result = "Relation Level Def: ";
        String outboundIds = this.getOutboundRelationIds().trim();
        String inboundIds = this.getInboundRelationIds().trim();
        String filter = this.getFilterExpression().trim();
        if (!outboundIds.isEmpty()) {
            result = result + "out: " + outboundIds + (inboundIds.isEmpty() ? "" : "; in: " + inboundIds) + (filter.isEmpty() ? "" : "; filter: " + filter);
        } else if (!inboundIds.isEmpty()) {
            result = result + "in: " + inboundIds + (filter.isEmpty() ? "" : "; filter: " + filter);
        }
        return result;
    }
}

