/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.comm;

import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AceLinkMessage
extends LinkMessage {
    private static final int BEGIN_CHAR = 127;
    private static final int END_CHAR = 126;
    private static final int ESCAPE_CHAR = 46;
    private static final int ESCAPED_BEGIN_CHAR = 128;
    private static final int ESCAPED_END_CHAR = 129;
    private static final int ESCAPED_ESCAPE_CHAR = 209;

    public AceLinkMessage(int maxLen) {
        super(maxLen);
    }

    public boolean receive(InputStream in) throws Exception {
        OutputStream os = this.getOutputStream();
        boolean done = false;
        boolean read = false;
        int cnt = 0;
        while (!done) {
            int x = in.read();
            if (x < 0) {
                return false;
            }
            int n = x;
            if (n == 127) {
                if (read) {
                    return false;
                }
                read = true;
                continue;
            }
            if (!read) continue;
            if (n == 126) {
                done = true;
            }
            if (done) break;
            if (n == 46) {
                switch (in.read()) {
                    case 128: {
                        n = 127;
                        break;
                    }
                    case 129: {
                        n = 126;
                        break;
                    }
                    case 209: {
                        n = 46;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            os.write(n);
            if (++cnt < 4096) continue;
            return false;
        }
        this.setLength(this.getLength() - 2);
        return true;
    }

    public boolean setMessage(NMessage msg) throws Exception {
        byte[] b = new byte[4098];
        TypedOutputStream to = new TypedOutputStream(b);
        msg.toOutputStream((OutputStream)to);
        int appMsgLen = to.size();
        int crc = this.calcCrc(b, appMsgLen);
        b[appMsgLen++] = (byte)(crc >> 8 & 0xFF);
        b[appMsgLen++] = (byte)(crc & 0xFF);
        OutputStream os = this.getOutputStream();
        os.write(127);
        block5: for (int i = 0; i < appMsgLen; ++i) {
            switch (b[i]) {
                case 127: {
                    os.write(46);
                    os.write(128);
                    continue block5;
                }
                case 126: {
                    os.write(46);
                    os.write(129);
                    continue block5;
                }
                case 46: {
                    os.write(46);
                    os.write(209);
                    continue block5;
                }
                default: {
                    os.write(b[i]);
                }
            }
        }
        os.write(126);
        this.address = msg.getAddress();
        if (this.address == null) {
            throw new BajaRuntimeException("No address set");
        }
        return false;
    }

    int calcCrc(byte[] b, int len) {
        int crc = 0;
        for (int i = 0; i < len; ++i) {
            crc += b[i];
        }
        return crc;
    }
}

