/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.comm;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.message.AceCov;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.AceObjPropValue;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BCommConfig;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComplex;
import javax.baja.sys.Type;

public class AceListener
implements ICommListener {
    BAceNetwork net;
    private static Logger COV_LOG = BAceNetwork.COV_LOG;

    public AceListener(BCommConfig ccfg) {
        this.net = (BAceNetwork)DrUtil.getParent((BComplex)ccfg, (Type)BAceNetwork.TYPE);
    }

    public void receiveMessage(NMessage nMsg) {
        if (!(nMsg instanceof AceMessage)) {
            return;
        }
        switch (((AceMessage)nMsg).getType()) {
            case 4: {
                this.processCov((AceCov)nMsg);
                break;
            }
            case 63: {
                break;
            }
            default: {
                System.out.println("received unhandled message type");
            }
        }
    }

    void processCov(AceCov cov) {
        BAceDevice dev = this.net.getDevice(cov.getAddress());
        if (dev == null) {
            this.net.log().warning("can't find device for " + cov.getAddress());
            return;
        }
        if (COV_LOG.isLoggable(Level.FINEST)) {
            COV_LOG.finest("rcv:" + cov.toTraceString());
        }
        AceObjPropValue[] opvs = cov.getPropVals();
        for (int i = 0; i < opvs.length; ++i) {
            int oid = opvs[i].objectId;
            int pid = opvs[i].propertyId;
            BAceComponent comp = dev.getComponent(oid);
            if (comp != null) {
                comp.updateValue(pid, opvs[i].primVal);
            }
            dev.updateProxyPoint(oid, pid, opvs[i].primVal);
        }
    }
}

