/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.component;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.enums.BAceCompQueryTypeEnum;
import com.tridium.ace.message.AceComponentQuery;
import com.tridium.ace.message.AceComponentQueryResp;
import com.tridium.ace.message.AceComponentReq;
import com.tridium.ace.message.AceComponentReqResp;
import com.tridium.ace.message.AceError;
import com.tridium.ace.message.AceInvoke;
import com.tridium.ace.message.AceLinkReq;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.AceObjPropValue;
import com.tridium.ace.message.AceRead;
import com.tridium.ace.message.AceReadResponse;
import com.tridium.ace.message.AceWrite;
import com.tridium.ace.sys.AceException;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BIStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

public class AceUtil {
    public static final Lexicon lex = Lexicon.make((String)"ace");
    private static Logger RD_WR_LOG = BAceNetwork.RD_WR_LOG;
    private static int X_BIT_OFFSET = 8;
    private static int Y_BIT_OFFSET = 16;
    private static int WIDTH_BIT_OFFSET = 24;
    private static int X_BIT_LENGTH = 8;
    private static int Y_BIT_LENGTH = 8;
    private static int WIDTH_BIT_LENGTH = 5;
    private static int SECGROUPS_BIT_OFFSET = 0;
    private static int SECGROUPS_BIT_LENGTH = 4;
    private static int META_SIZE = 32;

    public static boolean invokeAction(NComm comm, BAddress adr, int objectId, int pid, BAcePrimitive v, boolean expectResp) {
        return AceUtil.invokeAction(comm, adr, objectId, pid, v, expectResp, 0);
    }

    public static boolean invokeAction(NComm comm, BAddress adr, int objectId, int pid, BAcePrimitive v, boolean expectResp, int t) {
        try {
            AceInvoke msg = AceInvoke.make(objectId, pid, v);
            msg.setAddress(adr);
            if (t > msg.getResponseTimeOut()) {
                msg.setResponseTimeOut(t);
            }
            if (expectResp) {
                AceMessage rsp = (AceMessage)comm.sendRequest((NMessage)msg);
                return !rsp.isError();
            }
            comm.sendMessage((NMessage)msg);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void addComponent(final BAceComponent cp, Context cx) {
        final BAceDevice dev = cp.dev();
        if (dev == null || BNNetwork.noWrite.equals(cx)) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Knob[] knbs;
                    BLink[] lnks;
                    AceComponentReq msg = AceComponentReq.makeAdd(cp);
                    msg.setAddress(dev.getAddress());
                    AceMessage rsp = (AceMessage)dev.getAceNetwork().ncomm().sendRequest((NMessage)msg);
                    if (rsp.isError()) {
                        return;
                    }
                    int oid = ((AceComponentReqResp)rsp).getObjectId();
                    cp.setObjectId(oid);
                    cp.updateMeta(BNNetwork.noWrite);
                    AceWrite wmsg = AceWrite.make(oid, 0, cp.getPrimitive(BAceComponent.meta));
                    wmsg.setAddress(dev.getAddress());
                    IntHashMap.Iterator iterator = cp.getPropTable().iterator();
                    while (iterator.hasNext()) {
                        BAcePrimitive prim;
                        boolean isModInput;
                        Property p = (Property)iterator.next();
                        int pId = iterator.key();
                        if (pId < 2) continue;
                        BValue val = cp.get(p.getName());
                        boolean isConfig = p.getFacets().getb("config", false);
                        boolean bl = isModInput = p.getFacets().getb("input", false) && !Flags.isLinkTarget((BComplex)cp, (Slot)p) && !AceUtil.isDefaultValue(val);
                        if (!isConfig && !isModInput || Flags.isReadonly((BComplex)cp, (Slot)p) || (prim = cp.getPrimitive(p)) == null) continue;
                        wmsg.addPropValue(oid, pId, prim);
                    }
                    if (wmsg != null) {
                        if (RD_WR_LOG.isLoggable(Level.FINE)) {
                            RD_WR_LOG.fine("send:" + wmsg.toTraceString());
                        }
                        rsp = (AceMessage)dev.getAceNetwork().ncomm().sendRequest((NMessage)wmsg);
                        if (RD_WR_LOG.isLoggable(Level.FINE)) {
                            RD_WR_LOG.fine("rcv:" + rsp.toTraceString());
                        }
                    }
                    for (BLink lnk : lnks = cp.getLinks()) {
                        if (((BAceLink)lnk).getSourceAceComponent().getObjectId() < 0) continue;
                        AceUtil.addLink(cp, (BAceLink)lnk, null);
                    }
                    for (Knob knb : knbs = cp.getKnobs()) {
                        if (((BAceComponent)knb.getTargetComponent()).getObjectId() < 0) continue;
                        AceUtil.addLink(cp, (BAceLink)knb.getLink(), null);
                    }
                    if (lnks.length > 0 || knbs.length > 0) {
                        BAceComponent.getAppComp(cp).autoOrder();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        dev.getAceNetwork().postAsync(r);
    }

    private static boolean isDefaultValue(BValue val) {
        if (val instanceof BIStatusValue && ((BIStatusValue)val).getStatus().isNull()) {
            return true;
        }
        return val.getType().getInstance().equivalent((Object)val);
    }

    public static void renameComponent(final BAceComponent cp, final Property prop, final String pathName, final String oldName, final String newName, Context cx) {
        final BAceDevice dev = cp.dev();
        if (dev == null || BNNetwork.noWrite.equals(cx)) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AceComponentReq msg = AceComponentReq.makeRename(pathName + oldName, newName);
                    msg.setAddress(dev.getAddress());
                    AceMessage rsp = (AceMessage)dev.getAceNetwork().ncomm().sendRequest((NMessage)msg);
                    if (rsp.isError()) {
                        BAceComponent.LOG.severe("Unable to rename " + oldName + " to " + newName);
                        cp.rename(prop, oldName, BNNetwork.noWrite);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        dev.getAceNetwork().postAsync(r);
    }

    public static void addLink(BAceComponent cp, final BAceLink lk, Context cx) {
        final BAceDevice dev = cp.dev();
        if (dev == null || BNNetwork.noWrite.equals(cx)) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AceLinkReq msg = AceLinkReq.makeAdd(lk);
                    msg.setAddress(dev.getAddress());
                    AceMessage rsp = (AceMessage)dev.getAceNetwork().ncomm().sendRequest((NMessage)msg);
                    if (rsp.isError()) {
                        dev.getAceNetwork().log().warning("Failed to addLink:" + (Object)((Object)lk));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        dev.getAceNetwork().postAsync(r);
    }

    public static void removeComponent(BAceComponent parent, final BAceComponent cp, final Context cx) {
        final BAceDevice dev = parent.dev();
        if (dev == null || BNNetwork.noWrite.equals(cx)) {
            return;
        }
        cp.verifyRegistration(false);
        final AceComponentReq msg = AceComponentReq.makeRemove(cp.getAceFullPathName());
        msg.setAddress(dev.getAddress());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AceMessage rsp = (AceMessage)dev.getAceNetwork().ncomm().sendRequest((NMessage)msg);
                    if (rsp.isError()) {
                        dev.getAceNetwork().log().warning("Failed to delete component " + cp.getDisplayName(cx));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        dev.getAceNetwork().postAsync(r);
    }

    public static void removeLink(BAceComponent cp, BAceLink lk, Context cx) {
        final BAceDevice dev = cp.dev();
        if (dev == null || BNNetwork.noWrite.equals(cx)) {
            return;
        }
        try {
            final AceLinkReq msg = AceLinkReq.makeRemove(lk);
            msg.setAddress(dev.getAddress());
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        AceMessage rsp = (AceMessage)dev.getAceNetwork().ncomm().sendRequest((NMessage)msg);
                        if (rsp.isError()) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            dev.getAceNetwork().postAsync(r);
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    public static void asyncWait(BAceNetwork net) {
        AsyncWait r = new AsyncWait();
        net.postAsync(r);
        while (r.wait) {
            DrUtil.wait((int)50);
        }
    }

    public static String getCompType(NComm comm, BAddress adr, String compName) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, compName, BAceCompQueryTypeEnum.compType);
        return resp.getCompType();
    }

    public static String getCompType(NComm comm, BAddress adr, int objectId) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, objectId, BAceCompQueryTypeEnum.compType);
        return resp.getCompType();
    }

    public static String getName(NComm comm, BAddress adr, String compName) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, compName, BAceCompQueryTypeEnum.name);
        return resp.getName();
    }

    public static String getName(NComm comm, BAddress adr, int objectId) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, objectId, BAceCompQueryTypeEnum.name);
        return resp.getName();
    }

    public static String getFullName(NComm comm, BAddress adr, int objectId) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, objectId, BAceCompQueryTypeEnum.fullName);
        return resp.getFullName();
    }

    public static int getObjectId(NComm comm, BAddress adr, String compName) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, compName, BAceCompQueryTypeEnum.objectId);
        return resp.getObjectId();
    }

    public static int getParentId(NComm comm, BAddress adr, String compName) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, compName, BAceCompQueryTypeEnum.parentId);
        return resp.getParentId();
    }

    public static int getParentId(NComm comm, BAddress adr, int objectId) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, objectId, BAceCompQueryTypeEnum.parentId);
        return resp.getParentId();
    }

    public static int[] getChildren(NComm comm, BAddress adr, String compName) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, compName, BAceCompQueryTypeEnum.children);
        return resp.getChildren();
    }

    public static int[] getChildren(NComm comm, BAddress adr, int objectId) throws Exception {
        AceComponentQueryResp resp = AceUtil.sendQuery(comm, adr, objectId, BAceCompQueryTypeEnum.children);
        return resp.getChildren();
    }

    public static AceComponentQueryResp sendQuery(NComm comm, BAddress adr, String compName, BAceCompQueryTypeEnum action) throws Exception {
        if (compName.equalsIgnoreCase("app")) {
            throw new BajaException("Can not query app object by name");
        }
        if (compName.startsWith("app.")) {
            compName = compName.substring(compName.indexOf(46) + 1);
        }
        if (compName.length() == 0) {
            throw new BajaException("Invalid name");
        }
        AceComponentQuery queryReg = AceComponentQuery.make(compName, action);
        queryReg.setAddress(adr);
        AceMessage resp = (AceMessage)comm.sendRequest((NMessage)queryReg);
        if (resp.isError()) {
            throw new BajaException(((AceError)resp).toExceptionMessage());
        }
        return (AceComponentQueryResp)resp;
    }

    public static AceComponentQueryResp sendQuery(BAceDevice dev, int objectId, BAceCompQueryTypeEnum action) throws Exception {
        return AceUtil.sendQuery(dev.getAceNetwork().ncomm(), dev.getAddress(), objectId, action);
    }

    public static AceComponentQueryResp sendQuery(NComm comm, BAddress adr, int objectId, BAceCompQueryTypeEnum action) throws Exception {
        AceComponentQuery queryReg = AceComponentQuery.make(objectId, action);
        queryReg.setAddress(adr);
        AceMessage resp = (AceMessage)comm.sendRequest((NMessage)queryReg);
        if (resp.isError()) {
            throw new BajaException(((AceError)resp).toExceptionMessage());
        }
        return (AceComponentQueryResp)resp;
    }

    public static int findService(BAceDevice dev, String type) throws Exception {
        return AceUtil.findService(dev.getAceNetwork().ncomm(), dev.getAddress(), type);
    }

    public static int findService(NComm comm, BAddress adr, String type) throws Exception {
        int[] folders;
        for (int id : folders = AceUtil.findTypeInstances(comm, adr, "core.sys::Folder", 0)) {
            int tgt = AceUtil.findFirstType(comm, adr, type, id);
            if (tgt <= 0) continue;
            return tgt;
        }
        return -1;
    }

    public static int findFirstType(NComm comm, BAddress adr, String type, int objectId) throws Exception {
        int[] children;
        for (int id : children = AceUtil.getChildren(comm, adr, objectId)) {
            String typ = AceUtil.getCompType(comm, adr, id);
            if (!typ.equals(type)) continue;
            return id;
        }
        return -1;
    }

    public static int[] findTypeInstances(NComm comm, BAddress adr, String type, int objectId) throws Exception {
        int[] children = AceUtil.getChildren(comm, adr, objectId);
        ArrayList<Integer> typs = new ArrayList<Integer>();
        for (int id : children) {
            String typ = AceUtil.getCompType(comm, adr, id);
            if (!typ.equals(type)) continue;
            typs.add(id);
        }
        return typs.stream().mapToInt(Integer::intValue).toArray();
    }

    public static AceObjPropValue[] readProps(NComm comm, BAddress adr, int objectId, int propId) throws Exception {
        AceRead readReq = AceRead.make(objectId, propId);
        readReq.setAddress(adr);
        if (RD_WR_LOG.isLoggable(Level.FINE)) {
            RD_WR_LOG.fine("send:" + readReq.toTraceString());
        }
        AceMessage resp = (AceMessage)comm.sendRequest((NMessage)readReq);
        if (RD_WR_LOG.isLoggable(Level.FINE)) {
            RD_WR_LOG.fine("rcv:" + resp.toTraceString());
        }
        if (resp.isError()) {
            throw new Exception(((AceError)resp).toExceptionMessage());
        }
        AceReadResponse rrsp = (AceReadResponse)resp;
        return rrsp.getPropVals();
    }

    public static boolean readBoolean(NComm comm, BAddress adr, int objectId, int propId) throws Exception {
        return AceUtil.readProps((NComm)comm, (BAddress)adr, (int)objectId, (int)propId)[0].primVal.getBoolean();
    }

    public static int readInt(NComm comm, BAddress adr, int objectId, int propId) throws Exception {
        return AceUtil.readProps((NComm)comm, (BAddress)adr, (int)objectId, (int)propId)[0].primVal.getInt();
    }

    public static long readLong(NComm comm, BAddress adr, int objectId, int propId) throws Exception {
        return AceUtil.readProps((NComm)comm, (BAddress)adr, (int)objectId, (int)propId)[0].primVal.getLong();
    }

    public static float readFloat(NComm comm, BAddress adr, int objectId, int propId) throws Exception {
        return AceUtil.readProps((NComm)comm, (BAddress)adr, (int)objectId, (int)propId)[0].primVal.getFloat();
    }

    public static double readDouble(NComm comm, BAddress adr, int objectId, int propId) throws Exception {
        return AceUtil.readProps((NComm)comm, (BAddress)adr, (int)objectId, (int)propId)[0].primVal.getDouble();
    }

    public static String readString(NComm comm, BAddress adr, int objectId, int propId) throws Exception {
        return AceUtil.readProps((NComm)comm, (BAddress)adr, (int)objectId, (int)propId)[0].primVal.getString();
    }

    public static int decodeSecurityGroupsFromMeta(int meta) {
        BitSet metaBits = AceUtil.encodeFromInt(meta);
        int secGroups = AceUtil.extractElementFromMetaBits(metaBits, SECGROUPS_BIT_OFFSET, SECGROUPS_BIT_LENGTH);
        return secGroups;
    }

    public static BWsAnnotation decodeWsAnnotationFromMeta(int meta) {
        BitSet metaBits = AceUtil.encodeFromInt(meta);
        int x = AceUtil.extractElementFromMetaBits(metaBits, X_BIT_OFFSET, X_BIT_LENGTH);
        int y = AceUtil.extractElementFromMetaBits(metaBits, Y_BIT_OFFSET, Y_BIT_LENGTH);
        int width = AceUtil.extractElementFromMetaBits(metaBits, WIDTH_BIT_OFFSET, WIDTH_BIT_LENGTH);
        return BWsAnnotation.make((int)x, (int)y, (int)width);
    }

    public static int encodeSecurityGroupsToMeta(int meta, int securityGroups) {
        BitSet metaBits = AceUtil.encodeFromInt(meta);
        BitSet secGroupBits = AceUtil.encodeFromInt(securityGroups);
        if (secGroupBits.length() > SECGROUPS_BIT_LENGTH) {
            throw new AceException(lex.getText("annotation.securityGroupsError"));
        }
        metaBits = AceUtil.addElementToMeta(metaBits, secGroupBits, 0, SECGROUPS_BIT_LENGTH);
        return AceUtil.decodeMetaToInt(metaBits);
    }

    public static int encodeWsAnnotationToMeta(int meta, BWsAnnotation annotation) {
        BitSet metaBits = AceUtil.encodeFromInt(meta);
        BitSet x = AceUtil.encodeFromInt(annotation.p);
        BitSet y = AceUtil.encodeFromInt(annotation.q);
        BitSet width = AceUtil.encodeFromInt(annotation.wixelWidth);
        int xi = AceUtil.decodeMetaToInt(x);
        int yi = AceUtil.decodeMetaToInt(y);
        int widthi = AceUtil.decodeMetaToInt(width);
        if (xi != annotation.p || yi != annotation.q || widthi != annotation.wixelWidth) {
            throw new AceException(lex.getText("annotation.valueConversionError", new Object[]{xi + 58 + annotation.p + 124 + yi + 58 + annotation.q + 124 + widthi + 58 + annotation.wixelWidth}));
        }
        if (x.length() > X_BIT_LENGTH || y.length() > Y_BIT_LENGTH || width.length() > WIDTH_BIT_LENGTH) {
            throw new AceException(lex.getText("annotation.wsAnnotationError"));
        }
        metaBits = AceUtil.addElementToMeta(metaBits, x, X_BIT_OFFSET, X_BIT_LENGTH);
        metaBits = AceUtil.addElementToMeta(metaBits, y, Y_BIT_OFFSET, Y_BIT_LENGTH);
        metaBits = AceUtil.addElementToMeta(metaBits, width, WIDTH_BIT_OFFSET, WIDTH_BIT_LENGTH);
        return AceUtil.decodeMetaToInt(metaBits);
    }

    private static int decodeMetaToInt(BitSet b) {
        if (b.length() > META_SIZE) {
            throw new AceException(lex.getText("annotation.metaDecodeError"));
        }
        int result = 0;
        for (int i = 0; i < b.length(); ++i) {
            result += b.get(i) ? 1 << i : 0;
        }
        return result;
    }

    private static BitSet encodeFromInt(int value) {
        BitSet bitSet = new BitSet();
        int index = 0;
        while (value != 0) {
            if (value % 2 != 0) {
                bitSet.set(index);
            }
            ++index;
            value >>>= 1;
        }
        return bitSet;
    }

    private static BitSet addElementToMeta(BitSet meta, BitSet toAdd, int offset, int length) {
        meta.clear(offset, offset + length);
        for (int i = 0; i < toAdd.length(); ++i) {
            if (!toAdd.get(i)) continue;
            meta.set(i + offset);
        }
        return meta;
    }

    private static int extractElementFromMetaBits(BitSet meta, int bitOffset, int bitCount) {
        int result = 0;
        for (int i = 0; i < bitCount; ++i) {
            result += meta.get(i + bitOffset) ? 1 << i : 0;
        }
        return result;
    }

    private static class AsyncWait
    implements Runnable {
        boolean wait = true;

        private AsyncWait() {
        }

        @Override
        public void run() {
            this.wait = false;
        }
    }
}

