/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.component;

import com.tridium.ace.component.BAceAction;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.datatypes.BIAceInteger;
import com.tridium.ace.enums.AceSystemFacets;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.util.PxUtil;
import java.util.List;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BNull;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="aceType", type="String", defaultValue="", flags=9), @NiagaraProperty(name="aceKit", type="String", defaultValue="", flags=1)})
public class BAceDynamicComp
extends BAceComponent {
    @Generated
    public static final Property aceType = BAceDynamicComp.newProperty((int)9, (String)"", null);
    @Generated
    public static final Property aceKit = BAceDynamicComp.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAceDynamicComp.class);
    private static final BFacets LEX_FACETS = BFacets.make((String)"lexicon", (String)"ace");
    private static final String[] DISALLOWED_SLOT_NAMES = new String[]{"slotFacets_"};

    @Generated
    public String getAceType() {
        return this.getString(aceType);
    }

    @Generated
    public void setAceType(String v) {
        this.setString(aceType, v, null);
    }

    @Generated
    public String getAceKit() {
        return this.getString(aceKit);
    }

    @Generated
    public void setAceKit(String v) {
        this.setString(aceKit, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAceDynamicComp() {
    }

    public BAceDynamicComp(String aceTypeName, String aceKitName) {
        this.setAceType(aceTypeName);
        this.setAceKit(aceKitName);
    }

    @Override
    public void started() throws Exception {
        if (this.getDynamicPropertiesArray().length <= 1) {
            this.doImportJson(true);
        }
        super.started();
    }

    @Override
    public void changed(Property p, Context cx) {
        String erngFct;
        super.changed(p, cx);
        if (p.getType().is(BEnumRange.TYPE) && (erngFct = p.getFacets().gets(BAceSlotTypeEnum.enumRange.getTag(), "")).length() > 0) {
            String[] props;
            BEnumRange erng = (BEnumRange)this.get(p);
            for (String pname : props = erngFct.split(",")) {
                BValue v;
                Property eprop = this.getProperty(pname);
                if (eprop == null || !((v = this.get(eprop)) instanceof BStatusEnum)) continue;
                int currOrd = ((BStatusEnum)v).getEnum().getOrdinal();
                BStatus st = ((BStatusEnum)v).getStatus();
                this.set(eprop, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)currOrd, (BEnumRange)erng), st));
            }
        }
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("workbench:PropertySheet");
        this.handleTypeFacet(agents, "agent");
        this.handleTypeFacet(agents, "preferredView");
        return PxUtil.movePxViewsToTop((AgentList)agents);
    }

    private void handleTypeFacet(AgentList agents, String typeFacet) {
        BValue v = this.get("typeFacets");
        if (v == null) {
            return;
        }
        String agent = ((BFacets)v).gets(typeFacet, "");
        if (agent.length() == 0) {
            return;
        }
        agents.add(agent);
        agents.toTop(agent);
    }

    @Override
    public String getAceTypeName() {
        return this.getAceType();
    }

    @Override
    public String getAceKitName() {
        return this.getAceKit();
    }

    public BLink linkTo(BComponent source, Slot sourceSlot, Slot targetSlot) {
        BAceLink link = new BAceLink(source, sourceSlot, targetSlot);
        this.add(null, (BValue)link, 2);
        link.activate();
        return link;
    }

    public void checkSetFlags(Slot slot, int flags, Context context) {
        if (context == Context.decoding || context == BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX || context == Context.commit || context == Context.skipRemoveCheck || context == Context.skipValidate) {
            return;
        }
        if (slot.isProperty() && !slot.asProperty().getType().is(BAceComponent.TYPE)) {
            throw new LocalizableRuntimeException("ace", "ace.cannotSetFlags");
        }
    }

    public void checkSetFacets(Slot slot, BFacets facets, Context context) {
        if (slot.isProperty() && slot.isDynamic() && !slot.asProperty().getType().is(BAceComponent.TYPE)) {
            throw new LocalizableRuntimeException("ace", "ace.cannotSetFacets");
        }
    }

    @Override
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (context != Context.decoding) {
            for (String disallowedSlotName : DISALLOWED_SLOT_NAMES) {
                if (!disallowedSlotName.equals(name)) continue;
                throw new LocalizableRuntimeException("ace", "ace.cannotAddSlot", new Object[]{name});
            }
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    @Override
    public void checkRename(Property prop, String newName, Context cx) {
        if (!prop.getType().is(BAceComponent.TYPE)) {
            throw new LocalizableRuntimeException("ace", "ace.cannotRenameSlot");
        }
        super.checkRename(prop, newName, cx);
    }

    @Override
    public void checkRemove(Property p, Context cx) {
        if (!(p.getType().is(BAceComponent.TYPE) || p.getType().is(BLink.TYPE) || Context.decoding.equals(cx))) {
            throw new LocalizableRuntimeException("ace", "ace.cannotRemoveSlot");
        }
        super.checkRemove(p, cx);
    }

    public void doImportJson(boolean online) {
        try {
            KitRegistry kr = this.getKitRegistry();
            if (kr == null) {
                throw new Exception(lex.getText("ace.getCatalogFailed"));
            }
            AceType aceType = kr.lookupType(this.getAceKit(), this.getAceType());
            this.loadFromAceType(aceType, online);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to import JSON definition for " + this.getName() + " [" + this.getAceKit() + "." + this.getAceType() + "]", e);
        }
    }

    public void loadFromAceType(AceType aceType, boolean online) {
        try {
            this.setAceType(aceType.getTypeName());
            if (!aceType.getFacets().equals((Object)BFacets.DEFAULT) && this.get("typeFacets") == null) {
                this.add("typeFacets", (BValue)aceType.getFacets(), 4);
            }
            List<AceSlot> col = aceType.getProperties();
            for (AceSlot p : col) {
                int slotIndex = p.getSlotId();
                if (slotIndex < 2) continue;
                int flags = 0;
                boolean ioPnt = false;
                boolean enumRange = false;
                boolean foundBoolText = false;
                String enumList = "";
                BValue v = null;
                BFacets facets = this.getFacets(p, slotIndex);
                AceSystemFacets systemFacets = p.getFacets();
                for (BAceSlotTypeEnum key : systemFacets.facets.keySet()) {
                    switch (key.getOrdinal()) {
                        case 1: 
                        case 2: {
                            BIDataValue value = systemFacets.facets.get((Object)key);
                            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)key.getTag(), (BIDataValue)value));
                            if (value != BBoolean.TRUE) break;
                            ioPnt = true;
                            break;
                        }
                        case 3: {
                            BIDataValue value = systemFacets.facets.get((Object)key);
                            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)key.getTag(), (BIDataValue)value));
                            if (value != BBoolean.TRUE) break;
                            flags &= 0xFFFFFFFD;
                            break;
                        }
                        case 4: {
                            if (systemFacets.facets.get((Object)key) != BBoolean.TRUE) break;
                            flags |= 1;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 13: 
                        case 20: 
                        case 23: 
                        case 26: {
                            if (systemFacets.facets.get((Object)key) != BBoolean.TRUE) break;
                            flags |= Flags.getByName((String)key.getTag()).getMask();
                            break;
                        }
                        case 25: {
                            enumList = systemFacets.facets.get((Object)key).toString();
                            break;
                        }
                        case 11: 
                        case 12: {
                            if (foundBoolText) break;
                            BIDataValue o = systemFacets.facets.get((Object)BAceSlotTypeEnum.falseText);
                            String falseText = o != null ? "%lexicon(ace:" + o.toString() + ")%" : "false";
                            o = systemFacets.facets.get((Object)BAceSlotTypeEnum.trueText);
                            String trueText = o != null ? "%lexicon(ace:" + o.toString() + ")%" : "true";
                            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.makeBoolean((String)trueText, (String)falseText));
                            foundBoolText = true;
                            break;
                        }
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 30: {
                            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)key.getTag(), (BIDataValue)systemFacets.facets.get((Object)key)));
                            break;
                        }
                        case 10: {
                            try {
                                BUnit units = BUnit.getUnit((String)systemFacets.facets.get((Object)key).toString());
                                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"units", (BIDataValue)units));
                            }
                            catch (UnitException e) {
                                LOG.log(Level.WARNING, "Invalid unit:" + systemFacets.facets.get((Object)key).toString());
                            }
                            break;
                        }
                        case 27: {
                            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)key.getTag(), (BIDataValue)systemFacets.facets.get((Object)key)));
                            enumRange = true;
                            break;
                        }
                        case 31: {
                            String ntyp = systemFacets.facets.get((Object)key).toString();
                            v = (BValue)BTypeSpec.make((String)ntyp).getResolvedType().getInstance();
                            if (v != null && v instanceof BIAceInteger) break;
                            LOG.log(Level.SEVERE, "Invalid niagaraType specified:" + ntyp);
                            break;
                        }
                    }
                }
                if (v == null) {
                    v = this.getDefaultValue(p, ioPnt, enumRange, enumList);
                }
                if (v == null) continue;
                Property prop = this.getProperty(p.getName());
                if (prop == null) {
                    this.add(p.getName(), v, flags, facets, Context.decoding);
                    continue;
                }
                this.setFacets((Slot)prop, facets, Context.decoding);
                this.setFlags((Slot)prop, flags, Context.decoding);
            }
            if (online) {
                List<AceSlot> actions = aceType.getActions();
                for (AceSlot a : actions) {
                    int slotIndex = a.getSlotId();
                    BFacets facets = this.getFacets(a, slotIndex);
                    BAceAction dact = new BAceAction();
                    if (this.getAction(a.getName()) != null) continue;
                    this.add(a.getName(), (BValue)dact, 0, facets, Context.decoding);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load from JComponent for " + this.getName() + " [" + this.getAceType() + "]", e);
        }
    }

    private BValue getDefaultValue(AceSlot p, boolean ioPnt, boolean enumRange, String enumList) throws Exception {
        BValue v = p.getDefaultValue() != null ? p.getDefaultValue() : this.resolveDefaultValue(p);
        if (enumList.length() > 0) {
            if (v == null) {
                return BEnumRange.DEFAULT;
            }
            int ord = (int)((BINumeric)v).getNumeric();
            BDynamicEnum denum = BDynamicEnum.make((int)ord, (BEnumRange)BAceDynamicComp.getEnumRange(enumList));
            v = v instanceof BStatusValue ? new BStatusEnum((BEnum)denum, BStatus.nullStatus) : denum;
        } else if (enumRange) {
            return BEnumRange.DEFAULT;
        }
        return v;
    }

    public static BEnumRange getEnumRange(String enumList) throws Exception {
        String erString;
        if (enumList.startsWith("|")) {
            String[] typ = enumList.substring(1).split(":");
            BEnum e = (BEnum)BTypeSpec.make((String)enumList.substring(1)).getResolvedType().getInstance();
            erString = e.getRange().encodeToString() + "?" + BFacets.make((String)"lexicon", (String)typ[0]).encodeToString();
        } else if (enumList.startsWith("!!")) {
            erString = enumList.substring(2);
        } else {
            if (enumList.startsWith("::")) {
                return BEnumRange.DEFAULT;
            }
            erString = enumList + "?" + LEX_FACETS.encodeToString();
        }
        return (BEnumRange)BEnumRange.DEFAULT.decodeFromString(erString);
    }

    private BValue resolveDefaultValue(AceSlot p) {
        BAcePrimitiveTypeEnum ptyp = p.getPrimType();
        switch (ptyp.getOrdinal()) {
            case 0: {
                return BNull.DEFAULT;
            }
            case 1: {
                return BBoolean.DEFAULT;
            }
            case 2: 
            case 3: 
            case 4: {
                return BInteger.DEFAULT;
            }
            case 5: {
                return BLong.DEFAULT;
            }
            case 9: {
                return new BStatusNumeric(0.0, BStatus.nullStatus);
            }
            case 6: {
                return BFloat.DEFAULT;
            }
            case 10: {
                return new BStatusNumeric(0.0, BStatus.nullStatus);
            }
            case 7: {
                return BDouble.DEFAULT;
            }
            case 11: {
                return new BStatusNumeric(0.0, BStatus.nullStatus);
            }
            case 13: {
                return BString.DEFAULT;
            }
            case 8: {
                return new BStatusBoolean(false, BStatus.nullStatus);
            }
            case 12: {
                return BBlob.DEFAULT;
            }
        }
        LOG.warning(lex.getText("ace.slotTypeError", new Object[]{ptyp.toString()}));
        return null;
    }

    private BFacets getFacets(AceSlot p, int propId) {
        BFacets fcts = BFacets.make((String)"type", (BIDataValue)BString.make((String)p.getPrimType().getTag()), (String)"pId", (BIDataValue)BInteger.make((int)propId));
        for (BAceSlotTypeEnum key : p.getFacetsMap().keySet()) {
            switch (key.getOrdinal()) {
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 21: 
                case 22: 
                case 24: 
                case 28: 
                case 29: {
                    fcts = BFacets.make((BFacets)fcts, (BFacets)BFacets.make((String)key.getTag(), (BIDataValue)p.getFacetsMap().get((Object)key)));
                }
            }
        }
        BIDataValue minValue = p.getFacetsMap().get((Object)BAceSlotTypeEnum.min);
        BIDataValue maxValue = p.getFacetsMap().get((Object)BAceSlotTypeEnum.max);
        BIDataValue precisionValue = p.getFacetsMap().get((Object)BAceSlotTypeEnum.precision);
        switch (p.getPrimType().getOrdinal()) {
            case 1: 
            case 8: {
                BIDataValue facetValue = p.getFacetsMap().get((Object)BAceSlotTypeEnum.trueText);
                if (facetValue != null) {
                    fcts = BFacets.make((BFacets)fcts, (String)"trueText", (BIDataValue)facetValue);
                }
                if ((facetValue = p.getFacetsMap().get((Object)BAceSlotTypeEnum.falseText)) != null) {
                    fcts = BFacets.make((BFacets)fcts, (String)"falseText", (BIDataValue)facetValue);
                }
                return fcts;
            }
            case 2: {
                return this.makeInt(p, fcts, minValue == null ? 0 : ((BNumber)minValue).getInt(), maxValue == null ? 255 : ((BNumber)maxValue).getInt());
            }
            case 3: {
                return this.makeInt(p, fcts, minValue == null ? 0 : ((BNumber)minValue).getInt(), maxValue == null ? 65535 : ((BNumber)maxValue).getInt());
            }
            case 4: {
                return this.makeInt(p, fcts, minValue == null ? Integer.MIN_VALUE : ((BNumber)minValue).getInt(), maxValue == null ? Integer.MAX_VALUE : ((BNumber)maxValue).getInt());
            }
            case 5: 
            case 9: {
                return this.makeNumeric(p, fcts, precisionValue == null ? 1 : ((BNumber)precisionValue).getInt(), minValue == null ? -9.223372036854776E18 : (double)((BNumber)minValue).getLong(), maxValue == null ? 9.223372036854776E18 : (double)((BNumber)maxValue).getLong());
            }
            case 6: 
            case 10: {
                return this.makeNumeric(p, fcts, precisionValue == null ? 1 : ((BNumber)precisionValue).getInt(), minValue == null ? Double.NEGATIVE_INFINITY : (double)((BNumber)minValue).getFloat(), maxValue == null ? Double.POSITIVE_INFINITY : (double)((BNumber)maxValue).getFloat());
            }
            case 7: 
            case 11: {
                return this.makeNumeric(p, fcts, precisionValue == null ? 1 : ((BNumber)precisionValue).getInt(), minValue == null ? Double.NEGATIVE_INFINITY : ((BNumber)minValue).getDouble(), maxValue == null ? Double.POSITIVE_INFINITY : ((BNumber)maxValue).getDouble());
            }
        }
        int len = p.getLen();
        if (len <= 0 || len > 32) {
            len = 32;
        }
        return BFacets.make((BFacets)fcts, (BFacets)BFacets.make((String)"length", (int)p.getLen()));
    }

    private BFacets makeInt(AceSlot p, BFacets fcts, int min, int max) {
        BIDataValue unitValue = p.getFacetsMap().get((Object)BAceSlotTypeEnum.unit);
        BUnit unit = unitValue == null ? BUnit.NULL : BUnit.getUnit((String)unitValue.toString());
        return BFacets.make((BFacets)fcts, (BFacets)BFacets.makeInt((BUnit)unit, (int)min, (int)max));
    }

    private BFacets makeNumeric(AceSlot p, BFacets fcts, int precision, double min, double max) {
        BIDataValue unitValue = p.getFacetsMap().get((Object)BAceSlotTypeEnum.unit);
        BUnit unit = unitValue == null ? BUnit.NULL : BUnit.getUnit((String)unitValue.toString());
        return BFacets.make((BFacets)fcts, (BFacets)BFacets.makeNumeric((BUnit)unit, (int)precision, (double)min, (double)max));
    }
}

