/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.json;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.units.BUnit;

public class JCatalogWriter {
    public static void encode(BOrd ord, BAceComponent component) throws Exception {
        BIFile f = (BIFile)ord.resolve().get();
        JCatalogWriter.encode(f.getOutputStream(), component);
    }

    public static void encode(OutputStream jOut, BAceComponent component) throws Exception {
        OutputStreamWriter sw = new OutputStreamWriter(jOut, Charset.forName("UTF-8"));
        JSONWriter jw = new JSONWriter((Appendable)sw);
        JCatalogWriter.encode(jw, component);
        sw.close();
    }

    public static void encode(JSONWriter jw, BAceComponent component) throws Exception {
        Property[] aceProps;
        jw.object();
        jw.key("type").object();
        jw.key("name").value((Object)component.getAceTypeName());
        jw.key("kitName").value((Object)component.getAceKitName());
        jw.endObject();
        jw.key("slots").array();
        for (Property p : aceProps = component.getDynamicPropertiesArray()) {
            String[] keys;
            BString ds;
            if (p.getName().equals("slotFacets_") || p.getName().equals("wsAnnotation")) continue;
            BFacets propFacets = p.getFacets();
            BString primTypeString = (BString)propFacets.get("type");
            BAcePrimitiveTypeEnum primType = BAcePrimitiveTypeEnum.make(primTypeString.getString());
            BInteger lenString = BInteger.DEFAULT;
            if (primType == BAcePrimitiveTypeEnum.byteArray) {
                lenString = (BInteger)p.getFacets().get("length");
            }
            jw.object();
            jw.key("name").value((Object)p.getName());
            jw.key("slotType").value((Object)BAcePrimitiveTypeEnum.getJsonName(primTypeString.getString()));
            if (lenString != BInteger.DEFAULT) {
                jw.key("length").value((long)lenString.getInt());
            }
            if ((ds = (BString)p.getFacets().get("default")) != null) {
                if (primType.isStatus()) {
                    if (primType.isBool()) {
                        BStatusBoolean defaultSB = (BStatusBoolean)p.getDefaultValue();
                        jw.key("default").value(defaultSB.getBoolean());
                    } else {
                        BStatusNumeric defaultSN = (BStatusNumeric)p.getDefaultValue();
                        jw.key("default").value(defaultSN.getNumeric());
                    }
                }
                if (primType.isInt()) {
                    BInteger defaultInt = (BInteger)p.getDefaultValue();
                    jw.key("default").value((long)defaultInt.getInt());
                } else if (primType.isLong()) {
                    BLong defaultLong = (BLong)p.getDefaultValue();
                    jw.key("default").value(defaultLong.getLong());
                } else if (primType.isFloat()) {
                    BDouble defaultDouble = (BDouble)p.getDefaultValue();
                    jw.key("default").value(defaultDouble.getDouble());
                } else if (primType.isByteArray()) {
                    BString defaultString = (BString)p.getDefaultValue();
                    jw.key("default").value((Object)defaultString.getString());
                }
            }
            JSONObject facetObj = new JSONObject();
            for (String key : keys = propFacets.list()) {
                if (key.equalsIgnoreCase("type") || key.equalsIgnoreCase("pId") || key.equalsIgnoreCase("length")) continue;
                BIDataValue facetValue = (BIDataValue)propFacets.getFacet(key);
                if (facetValue instanceof BIBoolean) {
                    facetObj.put(key, ((BIBoolean)facetValue).getBoolean());
                    continue;
                }
                if (facetValue instanceof BInteger) {
                    facetObj.put(key, ((BInteger)facetValue).getInt());
                    continue;
                }
                if (facetValue instanceof BLong) {
                    facetObj.put(key, ((BLong)facetValue).getLong());
                    continue;
                }
                if (facetValue instanceof BNumber) {
                    facetObj.put(key, ((BNumber)facetValue).getNumeric());
                    continue;
                }
                if (facetValue instanceof BUnit) {
                    facetObj.put(key, (Object)((BUnit)facetValue).getUnitName());
                    continue;
                }
                facetObj.put(key, (Object)((BString)facetValue).toString());
            }
            jw.key("facets").value((Object)facetObj);
            jw.endObject();
        }
        jw.endArray();
        jw.endObject();
    }
}

