/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.kit;

import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.ace.kit.LocalKitRegistry;
import com.tridium.ace.sys.AceException;
import java.io.IOException;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

public class ACE {
    public static Lexicon lex = Lexicon.make((String)"ace");
    private static KitRegistry kitRegistry;
    public static final boolean OFFLINE = false;
    public static final boolean ONLINE = true;
    public static final int ACE_DEFAULT_WIXEL_WIDTH = 12;
    public static final BWsAnnotation INIT_ANN;
    public static String VERSION;
    public static final String TYPE_FACETS = "typeFacets";
    public static final String ACE_SINGLETON = "singleton";
    public static final String ACE_AGENT = "agent";
    public static final String ACE_COMMAND = "command";
    public static final String ACE_PREFERRED_VIEW = "preferredView";
    public static final String ACE_CATALOG = "aceCatalog";
    public static BOrd DEFAULT_MODULE_CATALOG_ORD;
    private static KitRegistry defaultRegistry;
    public static final Context aceInternal;

    public static void addCatalogToRegistry(BIFile catalogFile) throws AceException {
        try {
            if (kitRegistry == null) {
                kitRegistry = new LocalKitRegistry(catalogFile);
            } else {
                kitRegistry.load(catalogFile.getInputStream());
            }
        }
        catch (IOException e) {
            throw new AceException(lex.getText("ace.catalogError", new Object[]{catalogFile.getFileName(), e.getLocalizedMessage()}), e);
        }
    }

    public static Catalog getKitRegistry(BOrd ord) {
        BIFile catalogFile = (BIFile)ord.resolve().get();
        if (catalogFile == null) {
            return null;
        }
        LocalKitRegistry catalog = new LocalKitRegistry(catalogFile);
        return catalog;
    }

    public static Catalog getKitRegistry(String catalogAddress) throws AceException {
        BOrd ord = BOrd.make((String)catalogAddress);
        BIFile catalogFile = (BIFile)ord.resolve().get();
        LocalKitRegistry catalog = new LocalKitRegistry(catalogFile);
        return catalog;
    }

    public static Catalog getDefaultRegistryCatalog() {
        if (defaultRegistry == null || defaultRegistry.isEmpty()) {
            BIFile catalogFile = (BIFile)DEFAULT_MODULE_CATALOG_ORD.resolve().get();
            defaultRegistry = new LocalKitRegistry(catalogFile);
        }
        return defaultRegistry;
    }

    static {
        INIT_ANN = BWsAnnotation.make((int)0, (int)0, (int)12, (int)0);
        VERSION = "0.1";
        DEFAULT_MODULE_CATALOG_ORD = BOrd.make((String)"module://aceEdge/rc/catalog/catalog.json");
        aceInternal = new BasicContext((Context)BFacets.make((String)"aceInternal", (boolean)true)){

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return obj != null && obj instanceof Context && ((Context)obj).getFacets().getb("aceInternal", false);
            }

            public String toString() {
                return "ace.aceInternal";
            }
        };
    }
}

