/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.kit;

import com.tridium.ace.app.App;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.CatalogHeader;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.sys.AceException;
import java.util.Collection;
import javax.baja.util.Lexicon;

public interface Catalog {
    public static final Lexicon lex = Lexicon.make((String)"ace");

    public Collection<CatalogKit> kits();

    public CatalogKit get(String var1);

    default public boolean isEmpty() {
        return this.kits().isEmpty();
    }

    default public AceType lookupType(String fullTypeName) {
        int index = fullTypeName.indexOf("::");
        if (index <= 0) {
            throw new AceException(lex.getText("invalid type", new Object[]{fullTypeName}));
        }
        String kitName = fullTypeName.substring(0, index);
        String typeName = fullTypeName.substring(index + 2);
        return this.lookupType(kitName, typeName);
    }

    default public AceType lookupType(String kitName, String typeName) {
        CatalogKit kit = this.get(kitName);
        if (kit == null) {
            throw new AceException(lex.getText("json.componentRegistryKitError", new Object[]{typeName, kitName}));
        }
        AceType aceType = kit.type(typeName);
        if (aceType == null) {
            throw new AceException(lex.getText("json.componentRegistryError", new Object[]{typeName, kitName}));
        }
        return aceType;
    }

    public void addDefaultApp(App var1);

    public App getDefaultApp();

    public void addCatalogHeader(CatalogHeader var1);

    public CatalogHeader getCatalogHeader();
}

