/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.app.App;
import com.tridium.ace.app.Link;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.point.AppComponentPoints;
import com.tridium.ace.point.BasePointGatherer;
import com.tridium.ace.point.ComponentCollector;
import com.tridium.ace.point.DevicePointDescriptions;
import com.tridium.ace.sys.BAceApp;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;

public class AcePointGatherer
extends BasePointGatherer {
    private final BAceDevice dev;

    public AcePointGatherer(BAceDevice dev, Catalog catalog) {
        super(catalog);
        this.dev = dev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherAllAppComponents(ComponentCollector collector) throws Exception {
        byte[] appEmb;
        Object object = this.dev.lock;
        synchronized (object) {
            this.dev.implSaveApp();
            appEmb = this.dev.implReadFile("app.ace");
            if (appEmb == null) {
                throw new BajaRuntimeException("Can't read app.ace");
            }
        }
        JAppReader aceAppReader = new JAppReader(true);
        App app = aceAppReader.decode(new ByteArrayInputStream(appEmb), this.catalog);
        HashMap<Integer, BAceComponent> aceComponents = new HashMap<Integer, BAceComponent>();
        BAceApp aceApp = aceAppReader.buildComponentTree(app, aceComponents, this.catalog);
        String missingModules = aceAppReader.verifyTypes();
        if (missingModules.length() > 1) {
            this.dev.getPoints().setUnloadedModules(missingModules);
        }
        this.gatherChildAppComponents(collector, aceApp, null);
        for (Link lnk : app.getLinks()) {
            AppComponentPoints acp = ((DevicePointDescriptions)collector).getAppComponent(lnk.getToComponentId());
            acp.setLinkTarget(lnk.getToSlotName());
        }
    }

    private void gatherChildAppComponents(ComponentCollector collector, BAceComponent parent, String parentFullName) {
        for (BAceComponent child : (BAceComponent[])parent.getChildren(BAceComponent.class)) {
            int childId = child.getObjectId();
            String typeName = child.getAceKitName() + "::" + child.getAceTypeName();
            String fullName = (parentFullName == null ? "" : parentFullName + ".") + child.getName();
            collector.foundAppComponentId(childId);
            collector.foundAppComponentTypeName(childId, typeName);
            collector.foundAppComponentFullName(childId, fullName);
            this.gatherComponentEnumRange(collector, child);
            if (!collector.hasKitComponent(typeName)) {
                this.gatherKitComponentPoints(collector, typeName);
            }
            this.gatherChildAppComponents(collector, child, fullName);
        }
    }

    private void gatherComponentEnumRange(ComponentCollector collector, BAceComponent comp) {
        if (comp.getEnumRangeProps() == null) {
            return;
        }
        IntHashMap.Iterator iterator = comp.getEnumRangeProps().iterator();
        while (iterator.hasNext()) {
            BValue val = (BValue)iterator.next();
            int pId = iterator.key();
            collector.foundAppComponentSlotEnumRange(comp.getObjectId(), pId, val);
        }
    }
}

