/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.point.AppPointDescriptor;
import com.tridium.ace.point.DevicePointDescriptions;
import com.tridium.ace.point.PointDescriptor;
import java.util.HashMap;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;

public class AppComponentPoints
extends HashMap<Integer, PointDescriptor> {
    private final DevicePointDescriptions device;
    private final int id;
    private String fullName;
    private String typeName;

    public AppComponentPoints(DevicePointDescriptions device, int id) {
        this.device = device;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasSolitaryPoint() {
        return this.device.hasSolitaryPoint(this.typeName);
    }

    public String getSlotName(int slotId) {
        return this.device.getSlotName(this.typeName, slotId);
    }

    public BAcePrimitiveTypeEnum getDataType(int slotId) {
        return this.device.getDataType(this.typeName, slotId);
    }

    public BAceSlotTypeEnum getSlotType(int slotId) {
        return this.device.getSlotType(this.typeName, slotId);
    }

    public boolean getConfig(int slotId) {
        return this.device.getConfig(this.typeName, slotId);
    }

    public BFacets getFacets(int slotId) {
        return this.device.getFacets(this.typeName, slotId);
    }

    public BValue getDefaultValue(int slotId) {
        return this.device.getDefaultValue(this.typeName, slotId);
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setPointEnumRange(int slotId, BValue value) {
        this.getPoint(slotId).setEnumRange(value);
    }

    public void setLinkTarget(String slotName) {
        int slotId = this.device.getSlotId(this.typeName, slotName);
        if (slotId < 0) {
            return;
        }
        this.getPoint(slotId).setLinkTarget(true);
    }

    public void setPointValue(int slotId, BStatusValue value) {
        this.getPoint(slotId).setValue(value);
    }

    private AppPointDescriptor getPoint(int slotId) {
        AppPointDescriptor point = (AppPointDescriptor)this.get(slotId);
        if (point == null) {
            point = new AppPointDescriptor(this, slotId);
            this.put(slotId, point);
        }
        return point;
    }
}

