/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.component.BAceDynamicComp;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.point.BAceProxyExt;
import com.tridium.ace.point.BBooleanActionPoint;
import com.tridium.ace.point.BNumericActionPoint;
import com.tridium.ace.point.BVoidActionPoint;
import com.tridium.ace.point.PointDescriptor;
import com.tridium.ndriver.discover.BINDiscoveryIcon;
import com.tridium.ndriver.discover.BNPointDiscoveryLeaf;
import com.tridium.ndriver.util.SfUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="statusValue", type="BStatusValue", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="point", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="compName", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="propName", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="compId", type="int", defaultValue="0", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="propId", type="int", defaultValue="0", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="dataType", type="BAcePrimitiveTypeEnum", defaultValue="BAcePrimitiveTypeEnum.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="slotType", type="BAceSlotTypeEnum", defaultValue="BAceSlotTypeEnum.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="config", type="boolean", defaultValue="false", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="hasDefault", type="boolean", defaultValue="false", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="defaultValue", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="rangeVal", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="isLinkTarget", type="boolean", defaultValue="false", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")})})
public class BAcePointDiscoveryLeaf
extends BNPointDiscoveryLeaf
implements BINDiscoveryIcon {
    @Generated
    public static final Property statusValue = BAcePointDiscoveryLeaf.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property point = BAcePointDiscoveryLeaf.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property compName = BAcePointDiscoveryLeaf.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property propName = BAcePointDiscoveryLeaf.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property compId = BAcePointDiscoveryLeaf.newProperty((int)0, (int)0, (BFacets)SfUtil.incl());
    @Generated
    public static final Property propId = BAcePointDiscoveryLeaf.newProperty((int)0, (int)0, (BFacets)SfUtil.incl());
    @Generated
    public static final Property facets = BAcePointDiscoveryLeaf.newProperty((int)0, (BValue)BFacets.DEFAULT, (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Property dataType = BAcePointDiscoveryLeaf.newProperty((int)0, (BValue)BAcePrimitiveTypeEnum.DEFAULT, (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Property slotType = BAcePointDiscoveryLeaf.newProperty((int)0, (BValue)BAceSlotTypeEnum.DEFAULT, (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Property config = BAcePointDiscoveryLeaf.newProperty((int)0, (boolean)false, (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Property hasDefault = BAcePointDiscoveryLeaf.newProperty((int)0, (boolean)false, (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Property defaultValue = BAcePointDiscoveryLeaf.newProperty((int)0, (String)"", (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Property rangeVal = BAcePointDiscoveryLeaf.newProperty((int)0, (String)"", (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Property isLinkTarget = BAcePointDiscoveryLeaf.newProperty((int)0, (boolean)false, (BFacets)SfUtil.incl((String)"un"));
    @Generated
    public static final Type TYPE = Sys.loadType(BAcePointDiscoveryLeaf.class);
    protected static final Logger LOG = Logger.getLogger("ace.comp");

    @Generated
    public BStatusValue getStatusValue() {
        return (BStatusValue)this.get(statusValue);
    }

    @Generated
    public void setStatusValue(BStatusValue v) {
        this.set(statusValue, (BValue)v, null);
    }

    @Generated
    public String getPoint() {
        return this.getString(point);
    }

    @Generated
    public void setPoint(String v) {
        this.setString(point, v, null);
    }

    @Generated
    public String getCompName() {
        return this.getString(compName);
    }

    @Generated
    public void setCompName(String v) {
        this.setString(compName, v, null);
    }

    @Generated
    public String getPropName() {
        return this.getString(propName);
    }

    @Generated
    public void setPropName(String v) {
        this.setString(propName, v, null);
    }

    @Generated
    public int getCompId() {
        return this.getInt(compId);
    }

    @Generated
    public void setCompId(int v) {
        this.setInt(compId, v, null);
    }

    @Generated
    public int getPropId() {
        return this.getInt(propId);
    }

    @Generated
    public void setPropId(int v) {
        this.setInt(propId, v, null);
    }

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public BAcePrimitiveTypeEnum getDataType() {
        return (BAcePrimitiveTypeEnum)this.get(dataType);
    }

    @Generated
    public void setDataType(BAcePrimitiveTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    @Generated
    public BAceSlotTypeEnum getSlotType() {
        return (BAceSlotTypeEnum)this.get(slotType);
    }

    @Generated
    public void setSlotType(BAceSlotTypeEnum v) {
        this.set(slotType, (BValue)v, null);
    }

    @Generated
    public boolean getConfig() {
        return this.getBoolean(config);
    }

    @Generated
    public void setConfig(boolean v) {
        this.setBoolean(config, v, null);
    }

    @Generated
    public boolean getHasDefault() {
        return this.getBoolean(hasDefault);
    }

    @Generated
    public void setHasDefault(boolean v) {
        this.setBoolean(hasDefault, v, null);
    }

    @Generated
    public String getDefaultValue() {
        return this.getString(defaultValue);
    }

    @Generated
    public void setDefaultValue(String v) {
        this.setString(defaultValue, v, null);
    }

    @Generated
    public String getRangeVal() {
        return this.getString(rangeVal);
    }

    @Generated
    public void setRangeVal(String v) {
        this.setString(rangeVal, v, null);
    }

    @Generated
    public boolean getIsLinkTarget() {
        return this.getBoolean(isLinkTarget);
    }

    @Generated
    public void setIsLinkTarget(boolean v) {
        this.setBoolean(isLinkTarget, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAcePointDiscoveryLeaf() {
        this(null);
    }

    public BAcePointDiscoveryLeaf(PointDescriptor pointDescriptor) {
        if (pointDescriptor != null) {
            this.setCompName(pointDescriptor.getAppComponentFullName());
            this.setPropName(pointDescriptor.getSlotName());
            String point = pointDescriptor.getAppComponentName();
            if (!pointDescriptor.isSolitary()) {
                point = point + "." + pointDescriptor.getSlotName();
            }
            this.setPoint(point);
            this.setCompId(pointDescriptor.getAppComponentId());
            this.setPropId(pointDescriptor.getSlotId());
            this.setDataType(pointDescriptor.getDataType());
            this.setSlotType(pointDescriptor.getSlotType());
            this.setConfig(pointDescriptor.getConfig());
            if (pointDescriptor.getFacets() != null) {
                this.setFacets(pointDescriptor.getFacets());
            }
            if (pointDescriptor.getDefaultValue() != null) {
                this.setHasDefault(true);
                this.setDefault(pointDescriptor.getDefaultValue());
            }
            if (pointDescriptor.getEnumRange() != null) {
                try {
                    BEnumRange er = (BEnumRange)pointDescriptor.getEnumRange();
                    this.setRangeVal(er.encodeToString());
                }
                catch (Exception e) {
                    LOG.warning("Exception caught in BAcePointDiscoveryLeaf " + (e.getMessage() != null ? e.getMessage() : ""));
                }
            }
            this.setIsLinkTarget(pointDescriptor.isLinkTarget());
        }
    }

    public String getDiscoveryName() {
        return this.getPoint();
    }

    public TypeInfo[] getValidDatabaseTypes() {
        ArrayList<TypeInfo> validTypes = new ArrayList<TypeInfo>();
        BAceSlotTypeEnum slotType = this.getSlotType();
        boolean isAction = slotType.isAction();
        if (isAction) {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    validTypes.add(BVoidActionPoint.TYPE.getTypeInfo());
                    break;
                }
                case 1: 
                case 8: {
                    validTypes.add(BBooleanActionPoint.TYPE.getTypeInfo());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    validTypes.add(BNumericActionPoint.TYPE.getTypeInfo());
                }
            }
        } else {
            boolean writable = (slotType.isInput() || this.getConfig()) && !this.getFacets().getb("noProxy", false) && !this.getIsLinkTarget();
            boolean isConfig = this.getConfig();
            switch (this.getDataType().getOrdinal()) {
                case 1: 
                case 8: {
                    if (isConfig) {
                        validTypes.add(BBooleanPoint.TYPE.getTypeInfo());
                    }
                    if (writable) {
                        validTypes.add(BBooleanWritable.TYPE.getTypeInfo());
                    }
                    if (isConfig) break;
                    validTypes.add(BBooleanPoint.TYPE.getTypeInfo());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    boolean isEnum = this.isEnum();
                    if (isConfig) {
                        if (isEnum) {
                            validTypes.add(BEnumPoint.TYPE.getTypeInfo());
                        } else {
                            validTypes.add(BNumericPoint.TYPE.getTypeInfo());
                            validTypes.add(BBooleanPoint.TYPE.getTypeInfo());
                            validTypes.add(BEnumPoint.TYPE.getTypeInfo());
                        }
                    }
                    if (writable) {
                        if (isEnum) {
                            validTypes.add(BEnumWritable.TYPE.getTypeInfo());
                        } else {
                            validTypes.add(BNumericWritable.TYPE.getTypeInfo());
                            validTypes.add(BBooleanWritable.TYPE.getTypeInfo());
                            validTypes.add(BEnumWritable.TYPE.getTypeInfo());
                        }
                    }
                    if (isConfig) break;
                    if (isEnum) {
                        validTypes.add(BEnumPoint.TYPE.getTypeInfo());
                        break;
                    }
                    validTypes.add(BNumericPoint.TYPE.getTypeInfo());
                    validTypes.add(BBooleanPoint.TYPE.getTypeInfo());
                    validTypes.add(BEnumPoint.TYPE.getTypeInfo());
                    break;
                }
                case 12: 
                case 13: {
                    if (isConfig) {
                        validTypes.add(BStringPoint.TYPE.getTypeInfo());
                    }
                    if (writable) {
                        validTypes.add(BStringWritable.TYPE.getTypeInfo());
                    }
                    if (isConfig) break;
                    validTypes.add(BStringPoint.TYPE.getTypeInfo());
                    break;
                }
            }
        }
        return validTypes.isEmpty() ? null : validTypes.toArray(new TypeInfo[0]);
    }

    private boolean isEnum() {
        return this.getFacets().get(BAceSlotTypeEnum.enumList.getTag()) != null;
    }

    public void updateTarget(BComponent target) {
        if (!(target instanceof BControlPoint)) {
            return;
        }
        BControlPoint cp = (BControlPoint)target;
        BAceProxyExt pext = (BAceProxyExt)((BControlPoint)target).getProxyExt();
        pext.setCompName(this.getCompName());
        pext.setPropName(this.getPropName());
        pext.setCompId(this.getCompId());
        pext.setPropId(this.getPropId());
        pext.setDataType(this.getDataType());
        pext.setSlotType(this.getSlotType());
        BFacets sysFacets = this.getFacets();
        BFacets f = null;
        if (cp instanceof BEnumPoint) {
            String enumList = sysFacets.gets(BAceSlotTypeEnum.enumList.getTag(), "");
            if (enumList.startsWith("::") && this.getRangeVal().length() > 1) {
                enumList = "!!" + this.getRangeVal();
            }
            try {
                f = BFacets.makeEnum((BEnumRange)BAceDynamicComp.getEnumRange(enumList));
            }
            catch (Exception e) {
                LOG.warning("invalid enumlist for " + this.getCompName() + ":" + this.getPropName() + "|" + enumList);
            }
        } else if (cp instanceof BNumericPoint) {
            f = BAcePointDiscoveryLeaf.addFacet(BAceSlotTypeEnum.min.getTag(), f, sysFacets);
            f = BAcePointDiscoveryLeaf.addFacet(BAceSlotTypeEnum.max.getTag(), f, sysFacets);
            f = BAcePointDiscoveryLeaf.addFacet(BAceSlotTypeEnum.radix.getTag(), f, sysFacets);
            f = BAcePointDiscoveryLeaf.addFacet(BAceSlotTypeEnum.precision.getTag(), f, sysFacets);
            String units = sysFacets.gets(BAceSlotTypeEnum.unit.getTag(), "");
            if (units.length() > 0) {
                try {
                    f = BFacets.make((BFacets)f, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)units)));
                }
                catch (Exception e) {
                    LOG.warning("invalid units for " + this.getCompName() + ":" + this.getPropName() + "|" + units);
                }
            }
        } else if (cp instanceof BBooleanPoint) {
            f = BAcePointDiscoveryLeaf.addFacet(BAceSlotTypeEnum.falseText.getTag(), f, sysFacets);
            f = BAcePointDiscoveryLeaf.addFacet(BAceSlotTypeEnum.trueText.getTag(), f, sysFacets);
        }
        if (f != null) {
            pext.setDeviceFacets(f);
            cp.setFacets(f);
        }
        cp.setProxyExt((BAbstractProxyExt)pext);
    }

    private static BFacets addFacet(String key, BFacets f, BFacets sysFacets) {
        BIDataValue value = (BIDataValue)sysFacets.get(key);
        if (value == null) {
            return f;
        }
        if (f == null) {
            return BFacets.make((String)key, (BIDataValue)value);
        }
        return BFacets.make((BFacets)f, (String)key, (BIDataValue)value);
    }

    public boolean isExisting(BComponent target) {
        if (!(target instanceof BControlPoint)) {
            return false;
        }
        BControlPoint cp = (BControlPoint)target;
        BAbstractProxyExt ext = cp.getProxyExt();
        if (!(ext instanceof BAceProxyExt)) {
            return false;
        }
        BAceProxyExt aceExt = (BAceProxyExt)cp.getProxyExt();
        return Objects.equals(aceExt.getCompName(), this.getCompName()) && Objects.equals(aceExt.getPropName(), this.getPropName());
    }

    private void setDefault(BValue v) {
        try {
            String def = v.getType().getTypeSpec().toString() + "|" + ((BIEncodable)v).encodeToString();
            this.setDefaultValue(def);
        }
        catch (Exception e) {
            this.setDefaultValue("");
        }
    }

    private BValue getDefault() {
        String def = this.getDefaultValue();
        if (def.isEmpty()) {
            return null;
        }
        try {
            String[] sa = TextUtil.split((String)def, (char)'|');
            BObject val = ((BIEncodable)Sys.getType((String)sa[0]).getInstance()).decodeFromString(sa[1]);
            return (BValue)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public BIcon getDiscoveryIcon() {
        if (this.getSlotType() == BAceSlotTypeEnum.action) {
            return BIcon.std((String)"action.png");
        }
        switch (this.getDataType().getOrdinal()) {
            case 1: 
            case 8: {
                return BIcon.std((String)"statusBoolean.png");
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                if (this.isEnum()) {
                    return BIcon.std((String)"statusEnum.png");
                }
                return BIcon.std((String)"statusNumeric.png");
            }
            case 12: 
            case 13: {
                return BIcon.std((String)"statusString.png");
            }
        }
        return null;
    }
}

