/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.app.AceAppReader;
import com.tridium.ace.app.App;
import com.tridium.ace.app.Component;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.point.BasePointGatherer;
import com.tridium.ace.point.ComponentCollector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;

public class OfflinePointGatherer
extends BasePointGatherer {
    private final BOrd appOrd;

    public OfflinePointGatherer(BOrd appOrd, Catalog catalog) {
        super(catalog);
        this.appOrd = appOrd;
    }

    @Override
    public void gatherAllAppComponents(ComponentCollector collector) throws Exception {
        InputStream appFileStream;
        try {
            appFileStream = AccessController.doPrivileged(() -> {
                BIFile appFile = (BIFile)this.appOrd.resolve().get();
                return appFile.getInputStream();
            });
        }
        catch (PrivilegedActionException e) {
            appFileStream = null;
        }
        if (appFileStream != null) {
            int len;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = appFileStream.read(buf)) > -1) {
                output.write(buf, 0, len);
            }
            output.flush();
            JAppReader appReader = new JAppReader();
            Catalog catalog = ((AceAppReader)appReader).decodeCatalog(new ByteArrayInputStream(output.toByteArray()));
            appFileStream.reset();
            App aceApp = ((AceAppReader)appReader).decode(new ByteArrayInputStream(output.toByteArray()), catalog);
            Component root = aceApp.getRootComponent();
            if (root != null) {
                this.gatherChildAppComponents(collector, root, null);
            }
        }
    }

    private void gatherChildAppComponents(ComponentCollector collector, Component parent, String parentFullName) {
        for (Component child : parent.getChildren()) {
            int childId = child.getId();
            String typeName = child.getKitName() + "::" + child.getTypeName();
            String fullName = (parentFullName == null ? "" : parentFullName + ".") + child.getName();
            collector.foundAppComponentId(childId);
            collector.foundAppComponentTypeName(childId, typeName);
            collector.foundAppComponentFullName(childId, fullName);
            if (!collector.hasKitComponent(typeName)) {
                this.gatherKitComponentPoints(collector, typeName);
            }
            this.gatherChildAppComponents(collector, child, fullName);
        }
    }
}

