/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.util;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.enums.BAceCovRegisterTypeEnum;
import com.tridium.ace.message.AceCovRegistration;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.point.BAceProxyExt;
import com.tridium.ndriver.comm.NMessage;
import java.util.logging.Level;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;

public class CovReg
implements Runnable {
    public static final int KEY_PROP_SHIFT = 13;
    AceCovRegistration regMsg;
    AceCovRegistration unregMsg;
    CoalesceQueue q;
    BAceDevice dev;
    boolean posted = false;
    boolean done;

    public CovReg(BAceDevice dev) {
        this.dev = dev;
        this.q = new CoalesceQueue(5050);
    }

    public void add(BAceComponent cp) {
        if (cp.getObjectId() < 0) {
            return;
        }
        this.q.enqueue((Object)cp);
        this.checkRun();
    }

    public void delete(BAceComponent cp) {
        if (cp.getObjectId() < 0) {
            return;
        }
        this.q.enqueue((Object)new Remove(cp.getObjectId(), 255));
        this.checkRun();
    }

    public void add(BAceProxyExt pext) {
        this.q.enqueue((Object)pext);
        this.checkRun();
    }

    public void delete(BAceProxyExt pext) {
        this.q.enqueue((Object)new Remove(pext.getCompId(), pext.getPropId()));
        this.checkRun();
    }

    private synchronized void checkRun() {
        if (!this.posted) {
            this.posted = true;
            this.dev.getAceNetwork().postAsync(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CovReg covReg = this;
        synchronized (covReg) {
            this.posted = false;
            this.regMsg = null;
            this.unregMsg = null;
            this.done = false;
            while (!this.done && !this.q.isEmpty()) {
                boolean needsReg;
                Object o = this.q.dequeue();
                int objectId = 0;
                int propId = 255;
                if (o instanceof BAceComponent) {
                    BAceComponent cp = (BAceComponent)o;
                    boolean bl = needsReg = cp.getSubscribers().length > 0;
                    if (cp.verifyRegistration(needsReg)) continue;
                    objectId = cp.getObjectId();
                    if (!needsReg) {
                        this.dev.getPoints().reassertProxyCov(objectId);
                    }
                } else if (o instanceof BAceProxyExt) {
                    BAceProxyExt pext = (BAceProxyExt)((Object)o);
                    needsReg = pext.getParentPoint().isSubscribed();
                    objectId = pext.getCompId();
                    propId = pext.getPropId();
                } else {
                    if (!(o instanceof Remove)) continue;
                    Remove rem = (Remove)o;
                    needsReg = false;
                    objectId = rem.objectId;
                    propId = rem.propId;
                }
                if (needsReg) {
                    this.addRegister(objectId, propId);
                    continue;
                }
                this.addUnregister(objectId, propId);
            }
        }
        if (this.unregMsg != null) {
            this.sendReg(this.unregMsg, this.regMsg == null);
        }
        if (this.regMsg != null) {
            this.sendReg(this.regMsg, true);
        }
        if (!this.q.isEmpty()) {
            this.checkRun();
        }
    }

    private void addRegister(int objectId, int propId) {
        if (this.regMsg == null) {
            this.regMsg = AceCovRegistration.make(BAceCovRegisterTypeEnum.Register);
            this.regMsg.setAddress(this.dev.getAddress());
        }
        this.regMsg.addObjProp(objectId, propId);
        if (this.regMsg.isMaxCount()) {
            this.done = true;
        }
    }

    private void addUnregister(int objectId, int propId) {
        if (this.unregMsg == null) {
            this.unregMsg = AceCovRegistration.make(BAceCovRegisterTypeEnum.Unregister);
            this.unregMsg.setAddress(this.dev.getAddress());
        }
        this.unregMsg.addObjProp(objectId, propId);
        if (this.unregMsg.isMaxCount()) {
            this.done = true;
        }
    }

    private void sendReg(AceMessage msg, boolean request) {
        try {
            if (BAceNetwork.COV_LOG.isLoggable(Level.FINE)) {
                BAceNetwork.COV_LOG.fine("send:" + msg.toTraceString());
            }
            if (request) {
                AceMessage response = (AceMessage)this.dev.comm().sendRequest((NMessage)msg);
                if (BAceNetwork.COV_LOG.isLoggable(Level.FINE)) {
                    BAceNetwork.COV_LOG.fine("rcv:" + response.toTraceString());
                }
            } else {
                this.dev.comm().sendMessage((NMessage)msg);
            }
        }
        catch (Exception e) {
            BAceDevice.ACE_LOG.warning("Error sending " + msg.getClass().getName() + ":" + e.getMessage());
        }
    }

    static class Remove
    implements ICoalesceable {
        int objectId;
        int propId;

        public Remove(int o, int p) {
            this.objectId = o;
            this.propId = p;
        }

        public Object getCoalesceKey() {
            return (this.propId << 13) + this.objectId;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return this;
        }
    }
}

