/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.util;

import com.tridium.sys.Nre;
import java.util.Locale;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class LicenseUtil {
    public static final int MAX_COMPONENT_LIMIT = 5000;
    protected static Logger LOG = Logger.getLogger("AceNetwork");
    public static Lexicon lex = Lexicon.make((String)"ace");

    public static final int getComponentLimit() {
        int limit = 5000;
        boolean isEdge10 = Nre.getHostModel().toLowerCase(Locale.US).equals("edge10");
        try {
            String limitString = LicenseUtil.getComponentLimitString();
            if (limitString == null || limitString.equals("null")) {
                return isEdge10 ? 5000 : 0;
            }
            if (!limitString.equals("none") && (limit = Integer.parseInt(limitString)) > 5000) {
                limit = 5000;
            }
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return limit;
    }

    private static String getComponentLimitString() {
        try {
            Feature ft = Sys.getLicenseManager().getFeature("tridium", "ace");
            return ft.get("component.limit");
        }
        catch (FeatureNotLicensedException e) {
            LOG.info(lex.getText("ace.featureNotLicensed"));
            return "null";
        }
    }
}

