/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.util;

import javax.baja.util.BWsAnnotation;

public class Meta {
    private int meta;
    private static int SECGROUPS_BIT_OFFSET = 0;
    private static int X_BIT_OFFSET = 8;
    private static int Y_BIT_OFFSET = 16;
    private static int WIDTH_BIT_OFFSET = 24;
    private static int SECGROUPS_BIT_LENGTH = 4;
    private static int X_BIT_LENGTH = 8;
    private static int Y_BIT_LENGTH = 8;
    private static int WIDTH_BIT_LENGTH = 5;
    public static int MAX_X = (int)Math.pow(2.0, X_BIT_LENGTH) - 1;
    public static int MAX_Y = (int)Math.pow(2.0, Y_BIT_LENGTH) - 1;

    public static Meta make(int meta) {
        return new Meta(meta);
    }

    private Meta(int meta) {
        this.meta = meta;
    }

    public int getSecurityGroup() {
        return this.get(SECGROUPS_BIT_LENGTH, SECGROUPS_BIT_OFFSET);
    }

    public int getX() {
        return this.get(X_BIT_LENGTH, X_BIT_OFFSET);
    }

    public int getY() {
        return this.get(Y_BIT_LENGTH, Y_BIT_OFFSET);
    }

    public int getWidth() {
        return this.get(WIDTH_BIT_LENGTH, WIDTH_BIT_OFFSET);
    }

    public void setSecurityGroup(int v) {
        this.set(v, SECGROUPS_BIT_LENGTH, SECGROUPS_BIT_OFFSET);
    }

    public void setX(int v) {
        this.set(v, X_BIT_LENGTH, X_BIT_OFFSET);
    }

    public void setY(int v) {
        this.set(v, Y_BIT_LENGTH, Y_BIT_OFFSET);
    }

    public void setWidth(int v) {
        this.set(v, WIDTH_BIT_LENGTH, WIDTH_BIT_OFFSET);
    }

    public int getMeta() {
        return this.meta;
    }

    public static BWsAnnotation toWsAnnotation(int meta) {
        Meta m = Meta.make(meta);
        return BWsAnnotation.make((int)m.getX(), (int)m.getY(), (int)m.getWidth());
    }

    private int get(int bitCount, int offset) {
        int mask = this.mask(bitCount);
        return this.meta >> offset & mask;
    }

    private void set(int val, int bitCount, int offset) {
        int mask = this.mask(bitCount);
        this.meta &= ~(mask << offset);
        this.meta |= (val &= mask) << offset;
    }

    private int mask(int len) {
        int mask = 1;
        while (--len > 0) {
            mask = mask << 1 | 1;
        }
        return mask;
    }
}

