/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hx;

import com.tridium.ui.theme.Theme;
import com.vykon.vykonPro.history.BPeakTracker;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.util.UiLexicon;

public class BHxPeakTrackerView
extends BHxView {
    public static final BHxPeakTrackerView INSTANCE = new BHxPeakTrackerView();
    public static final Type TYPE = Sys.loadType(BHxPeakTrackerView.class);
    public static final UiLexicon monthLex = UiLexicon.makeUiLexicon(BMonth.class);
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BHxPeakTrackerView.class);
    private String borderColor;
    private String rowColor;
    private String headerColor;
    private String altRowColor;

    public Type getType() {
        return TYPE;
    }

    public BWidget[] getChildWidgets(BWidget widget, Context cx) {
        return new BWidget[0];
    }

    public void write(HxOp op) throws Exception {
        String themeName;
        HtmlWriter out = op.getHtmlWriter();
        op.setDynamic();
        BDynamicEnum theme = (BDynamicEnum)op.getProfileConfig().get("selectedHxTheme");
        String string = themeName = theme == null ? null : theme.getTag();
        if (themeName != null && !themeName.isEmpty()) {
            op.addStyleSheet("module://theme" + themeName + "/ux/theme.css");
        }
        this.borderColor = Theme.table().getGridBrush().encodeToString();
        this.rowColor = Theme.table().getBandBrush().encodeToString();
        this.headerColor = Theme.gridPane().getControlHeader().encodeToString();
        this.altRowColor = lexicon.getText("zonelistView.altRowColor");
        BPeakTracker base = (BPeakTracker)op.get();
        base.lease(1);
        BAbsTime[] tstamps = base.getTimestamps();
        BStatusNumeric[] peaks = base.getPeaks();
        BFacets f = BFacets.make((BFacets)base.getFacets(), (BFacets)op.getFacets());
        out.w((Object)"<div class=\"PeakTrackerView\" >");
        out.w((Object)("<table height='100%' width='100%' cellspacing='0' cellpadding='5' style='border-collapse: collapse; border: 1px solid " + this.borderColor + ";'>"));
        out.w((Object)("<tr style='background-color: " + this.headerColor + ";'><th style='border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)lexicon.getText("trackerView.month")).w((Object)("</th><th style='border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)lexicon.getText("trackerView.timestamp"));
        out.w((Object)("</th><th style='border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)lexicon.getText("trackerView.value"));
        out.w((Object)"</th></tr>");
        for (int i = 0; i < peaks.length; ++i) {
            String month = monthLex.getText(BMonth.make((int)i).getTag());
            if (i % 2 == 0) {
                this.writePeakRow(op, month, tstamps[i], peaks[i].valueToString((Context)f), this.rowColor);
                continue;
            }
            this.writePeakRow(op, month, tstamps[i], peaks[i].valueToString((Context)f), this.altRowColor);
        }
        out.w((Object)"</table>");
        out.w((Object)"</div>");
    }

    protected void writePeakRow(HxOp op, String month, BAbsTime tstamp, String value, String color) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String rowClass = "hx-table-row";
        out.w((Object)("<tr class=\"" + rowClass + "\" style='background-color: " + color + ";'>"));
        out.w((Object)("<td style='text-align: left; border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)month);
        out.w((Object)"</td>");
        out.w((Object)("<td style='text-align: left; border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)tstamp.toString((Context)op.getFacets()));
        out.w((Object)"</td>");
        out.w((Object)("<td style='text-align: left; border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)value);
        out.w((Object)"</tr>");
    }
}

