/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hx;

import com.vykon.vykonPro.ui.BToolTipBinding;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.gx.IRectGeom;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.hx.px.binding.BHxPxBinding;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public class BHxPxToolTipBinding
extends BHxPxBinding
implements BIAgent {
    public static final BHxPxToolTipBinding INSTANCE = new BHxPxToolTipBinding();
    public static final Type TYPE = Sys.loadType(BHxPxToolTipBinding.class);
    public static final Logger log = Logger.getLogger("hx.px");

    public Type getType() {
        return TYPE;
    }

    protected BHxPxToolTipBinding() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        HxOp widgetOp = (HxOp)op.getBase().getBase();
        BToolTipBinding toolTipBinding = (BToolTipBinding)op.get();
        BHxPxWidget hxPxWidget = BHxPxWidget.makeFor((BObject)toolTipBinding.getWidget());
        MouseEventCommand mouseHandler = hxPxWidget.getMouseEventHandler();
        if (mouseHandler != null) {
            hxPxWidget.registerEvent((Event)mouseHandler, "mouseEventHandler");
            if (hxPxWidget.isEventRegistered((Event)hxPxWidget.mouseEventCommand)) {
                Writer writer = HxUtil.startOnloadWriter((HxOp)op);
                try {
                    PropertiesCollection.Events events = new PropertiesCollection.Events();
                    events.add("onmouseenter", "if(!hx.$('" + widgetOp.getPath() + "').$entered){ hx.$('" + widgetOp.getPath() + "').$entered=true;" + mouseHandler.getInvokeCode(504, widgetOp) + "}");
                    events.add("onmouseleave", "hx.$('" + widgetOp.getPath() + "').$entered=false;" + mouseHandler.getInvokeCode(505, widgetOp));
                    events.write(widgetOp);
                }
                finally {
                    HxUtil.finishOnloadWriter((Writer)writer, (HxOp)op);
                }
            }
        }
    }

    public void handle(BInputEvent event, HxOp op) throws Exception {
        if (event.getId() == 504 || event.getId() == 505) {
            BMouseEvent mouseEvent = (BMouseEvent)event;
            BToolTipBinding toolTipBinding = (BToolTipBinding)op.get();
            HxOp widgetOp = (HxOp)op.getBase().getBase();
            BHxPxWidget hxPxWidget = BHxPxWidget.makeFor((BObject)toolTipBinding.getWidget());
            IRectGeom geom = hxPxWidget.getGeom(toolTipBinding.getWidget(), widgetOp);
            toolTipBinding.mouseEvent(mouseEvent);
            this.update((int)geom.bounds().width(), (int)geom.bounds().height(), true, op);
        }
    }

    public void update(int width, int height, boolean forceUpdate, HxOp op) throws IOException {
        BToolTipBinding binding = (BToolTipBinding)op.get();
        HxOp baseOp = (HxOp)op.getBase().getBase();
        if (binding.getOrd() != BOrd.NULL) {
            BObject obj;
            BOrd bindingOrd = binding.getOrd();
            try {
                obj = BOrd.make((BOrd)op.getOrd(), (BOrd)bindingOrd).resolve(op.getWebOp().get(), (Context)op).get();
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("tool tip binding unresolved: " + binding.getOrd());
                }
                return;
            }
            String tip = "";
            if (obj instanceof BComponent) {
                BComponent comp = (BComponent)obj;
                comp.lease(binding.getLeaseDepth());
                tip = binding.getToolTip().format((Object)comp, (Context)op);
            } else {
                tip = "The ToolTipBinding ord must resolve to a BComponent type";
            }
            PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
            properties.addUnsafe("title", tip);
            properties.write(baseOp);
        }
    }
}

