/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hx.ux;

import com.tridium.ui.theme.Theme;
import com.tridium.web.WebUtil;
import com.vykon.vykonPro.ui.BEnhancedLabel;
import java.io.IOException;
import java.security.AccessController;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.style.IStylable;
import javax.servlet.http.HttpServletRequest;

public final class UxEnhancedLabelUtil {
    private static boolean LEGACY_LABEL = AccessController.doPrivileged(() -> Boolean.getBoolean("hx.label.legacy"));

    private UxEnhancedLabelUtil() {
    }

    public static void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        op.addStyleSheet(BOrd.make((String)"module://vykonPro/rc/vykonPro.css"));
        op.addStyleSheet(BOrd.make((String)"module://bajaui/rc/bajaui.css"));
        out.w((Object)"<div ").attr("id", op.scope("EnhancedLabel-col")).attr(" class", "ux-EnhancedLabel-content").w((Object)">");
        out.w((Object)"<span ").attr("id", op.scope("EnhancedLabel-image")).attr(" class", "-v-EnhancedLabel-image").attr(" style", "display: none;").w((Object)">");
        HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://hx/com/tridium/hx/images/spacer.gif")), (String)"style='border: 0px; display: none;'", (HxOp)op);
        out.w((Object)"</span>");
        UxEnhancedLabelUtil.writeLabelText(op);
        out.w((Object)"</div>");
    }

    public static void writeLabelText(HxOp op) throws IOException {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ").attr("id", op.scope("EnhancedLabel-text")).attr(" class", "-v-EnhancedLabel-text").w((Object)">");
        out.w((Object)"</span>");
    }

    public static void update(int width, int height, HxOp op) throws Exception {
        UxEnhancedLabelUtil.update(width, height, op.getPath(), true, op);
    }

    public static void update(int width, int height, String rootScope, boolean applyBackground, HxOp op) throws Exception {
        UxEnhancedLabelUtil.update(width, height, rootScope, applyBackground, null, op);
    }

    public static void update(int width, int height, String rootScope, boolean applyBackground, BInsets padding, HxOp op) throws Exception {
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles rootStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles divStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles textStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties textProperties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles imgStyle = new PropertiesCollection.Styles();
        BEnhancedLabel label = (BEnhancedLabel)op.get();
        textProperties.add("innerHTML", label.getText());
        rootStyle.add("justifyContent", UxEnhancedLabelUtil.toHAlign(label.getHalign().getTag()));
        rootStyle.add("alignItems", UxEnhancedLabelUtil.toVAlign(label.getValign().getTag()));
        divStyle.add("flexDirection", UxEnhancedLabelUtil.toFlexDirection(label.getTextToIconAlign().getTag()));
        textStyle.add("textAlign", UxEnhancedLabelUtil.toHAlignForText(label.getHalign().getTag()));
        BFont font = label.getFont();
        BBrush foreground = label.getForeground();
        if (!label.getEnabled()) {
            foreground = Theme.label().getTextDisabled((IStylable)label);
            properties.append("className", "bajaux-disabled");
        }
        boolean wordWrapEnabled = label.getWordWrapEnabled();
        if (!label.getLabelLayout().requiresMultipleLines()) {
            wordWrapEnabled = false;
        }
        HxUtil.makeFont((BBrush)foreground, (BFont)font, (PropertiesCollection)textStyle, (PropertiesCollection)properties, (boolean)wordWrapEnabled, (HxOp)op);
        if (applyBackground) {
            if (label.getParentWidget() instanceof BBorderPane && label == ((BBorderPane)label.getParentWidget()).getLabel()) {
                HxUtil.makeBackground((BBrush)label.getBackground(), (BBrush)BBrush.makeSolid((BColor)BColor.white), (PropertiesCollection)rootStyle, (HxOp)op);
            } else {
                HxUtil.makeBackground((BBrush)label.getBackground(), null, (PropertiesCollection)rootStyle, (HxOp)op);
            }
        }
        properties.append("className", "ux-Label ux-EnhancedLabel");
        boolean isCentered = label.getTextToIconAlign().getTag() == "center";
        boolean setCenterImage = false;
        BImage image = label.getImage();
        if (!image.isNull()) {
            if (!label.getText().isEmpty() && isCentered) {
                textProperties.append("className", "-v-EnhancedLabel-textToIconAlignCenter");
                image.syncDimensions();
                textStyle.setSnoopEnabled(false);
                textStyle.add("backgroundImage", "url(" + HxUtil.escapeJsStringLiteral((String)WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)image.getOrdList().get(0))) + ") ");
                textStyle.add("minWidth", image.getWidth() + "px");
                textStyle.add("minHeight", image.getHeight() + "px");
                setCenterImage = true;
                imgStyle.add("display", "none");
            } else {
                if (!label.getText().isEmpty()) {
                    UxEnhancedLabelUtil.toTextAlignMargin((PropertiesCollection)imgStyle, label.getTextToIconAlign().getTag(), label.getTextIconGap());
                }
                imgStyle.add("display", "");
                HxUtil.changeImageJS((String)op.scope("EnhancedLabel-image"), (BImage)image, (String)"style='display:block;'", (HxOp)op);
            }
        } else {
            imgStyle.add("display", "none");
            HxUtil.changeImageJS((String)op.scope("EnhancedLabel-image"), (BImage)BImage.make((BOrd)BOrd.make((String)"module://hx/com/tridium/hx/images/spacer.gif")), (String)"style='display:none;'", (HxOp)op);
        }
        if (!setCenterImage) {
            textStyle.add("backgroundImage", "");
            textStyle.add("minWidth", "");
            textStyle.add("minHeight", "");
        }
        op.getHtmlWriter().w((Object)("px.toggleBlink([document.getElementById('" + op.getPath() + "')], " + (label.getBlink() && HxUtil.isWidgetEffectivelyVisible((BWidget)label, (int)width, (int)height)) + ");"));
        if (padding != null) {
            HxUtil.makeMargin((BInsets)padding, (PropertiesCollection)divStyle);
        }
        properties.write(rootScope, op);
        rootStyle.write(rootScope, op);
        textProperties.write(op.scope("EnhancedLabel-text"), op);
        textStyle.write(op.scope("EnhancedLabel-text"), op);
        imgStyle.write(op.scope("EnhancedLabel-image"), op);
        divStyle.write(op.scope("EnhancedLabel-col"), op);
    }

    public static boolean hasLegacyLabel(HxOp op) {
        String param = UxEnhancedLabelUtil.getLegacyLabelParam(op);
        if ("true".equals(param)) {
            return true;
        }
        if ("false".equals(param)) {
            return false;
        }
        return LEGACY_LABEL;
    }

    private static String getLegacyLabelParam(HxOp op) {
        ViewQuery query = op.getViewQuery();
        return query != null ? query.getParameter("legacyLabel", null) : null;
    }

    private static String toFlexDirection(String tag) {
        switch (tag) {
            case "top": {
                return "column-reverse";
            }
            case "left": {
                return "row-reverse";
            }
            case "bottom": {
                return "column";
            }
            case "right": {
                return "row";
            }
            case "center": {
                return "";
            }
        }
        return "";
    }

    private static String toHAlign(String tag) {
        switch (tag) {
            case "center": 
            case "fill": {
                return "center";
            }
            case "left": {
                return "flex-start";
            }
            case "right": {
                return "flex-end";
            }
        }
        return "";
    }

    private static String toVAlign(String tag) {
        switch (tag) {
            case "fill": 
            case "center": {
                return "center";
            }
            case "top": {
                return "flex-start";
            }
            case "bottom": {
                return "flex-end";
            }
        }
        return "";
    }

    private static String toHAlignForText(String tag) {
        switch (tag) {
            case "center": 
            case "fill": {
                return "center";
            }
            case "left": 
            case "right": {
                return tag;
            }
        }
        return "";
    }

    private static void toTextAlignMargin(PropertiesCollection style, String tag, double textIconGap) {
        switch (tag) {
            case "top": {
                style.append("marginTop", textIconGap + "px");
                return;
            }
            case "left": {
                style.append("marginLeft", textIconGap + "px");
                return;
            }
            case "bottom": {
                style.append("marginBottom", textIconGap + "px");
                return;
            }
            case "right": {
                style.append("marginRight", textIconGap + "px");
            }
        }
    }
}

