/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.ui;

import com.tridium.ui.UiEnv;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.vykon.vykonPro.ui.BIAppletLinks;
import java.net.URL;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;

public class BEnhancedHyperlinkBinding
extends BBinding {
    public static final Property hyperlink = BEnhancedHyperlinkBinding.newProperty((int)5, (BValue)BOrd.NULL, null);
    public static final Property hyperlinkFormat = BEnhancedHyperlinkBinding.newProperty((int)0, (BValue)BFormat.make((String)"%slotPath%"), null);
    public static final Property wbTarget = BEnhancedHyperlinkBinding.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BHyperlinkMode.TYPE)), null);
    public static final Property browserTarget = BEnhancedHyperlinkBinding.newProperty((int)0, (String)"_self", null);
    public static final Action mouseEvent = BEnhancedHyperlinkBinding.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BEnhancedHyperlinkBinding.class);
    boolean isOver;
    MouseCursor restoreCursor;

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd v) {
        this.set(hyperlink, (BValue)v, null);
    }

    public BFormat getHyperlinkFormat() {
        return (BFormat)this.get(hyperlinkFormat);
    }

    public void setHyperlinkFormat(BFormat v) {
        this.set(hyperlinkFormat, (BValue)v, null);
    }

    public BEnum getWbTarget() {
        return (BEnum)this.get(wbTarget);
    }

    public void setWbTarget(BEnum v) {
        this.set(wbTarget, (BValue)v, null);
    }

    public String getBrowserTarget() {
        return this.getString(browserTarget);
    }

    public void setBrowserTarget(String v) {
        this.setString(browserTarget, v, null);
    }

    public void mouseEvent(BMouseEvent event) {
        this.invoke(mouseEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        super.started();
        if (this.getWidget() != null) {
            this.linkTo((BComponent)this.getWidget(), (Slot)BWidget.mouseEvent, (Slot)mouseEvent);
        }
    }

    public void resolveHyperlink() {
        BOrd hOrd = BOrd.make((String)this.getHyperlinkFormat().format((Object)this.get()));
        this.setHyperlink(hOrd);
    }

    public void resolveHyperlink(Context cx) {
        BOrd hOrd = BOrd.make((String)this.getHyperlinkFormat().format((Object)this.get(), cx));
        this.setHyperlink(hOrd);
    }

    public void doMouseEvent(BMouseEvent event) {
        if (!this.getWidget().isEnabled()) {
            return;
        }
        switch (event.getId()) {
            case 504: {
                this.entered(event);
                break;
            }
            case 505: {
                this.exited(event);
                break;
            }
            case 501: {
                this.pressed(event);
                break;
            }
            case 502: {
                this.released(event);
            }
        }
    }

    private void entered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = true;
        if (shell != null && !Sys.isStation()) {
            if (!this.isBound()) {
                return;
            }
            this.resolveHyperlink();
            shell.showStatus(this.toShowStatus());
            this.restoreCursor = !this.getHyperlink().isNull() && UiEnv.get().hasMouse() ? this.getWidget().setMouseCursor(MouseCursor.hand) : null;
        }
    }

    private void exited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = false;
        if (shell != null && !Sys.isStation()) {
            shell.showStatus("");
        }
        if (this.restoreCursor != null) {
            this.getWidget().setMouseCursor(this.restoreCursor);
        }
    }

    private void pressed(BMouseEvent event) {
    }

    private void released(BMouseEvent event) {
        if (this.isOver && !this.getHyperlink().isNull() && !Sys.isStation()) {
            BOrd ord = this.getHyperlink();
            BWidgetShell shell = this.getShell();
            if (shell instanceof BNiagaraWbApplet) {
                try {
                    BNiagaraWbApplet wbapp = (BNiagaraWbApplet)shell;
                    URL url = wbapp.ordToUrl(ord);
                    BIAppletLinks.hyperlink(wbapp, url, this.getBrowserTarget());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (shell instanceof BIHyperlinkShell) {
                switch (this.getWbTarget().getOrdinal()) {
                    case 0: {
                        ord = BOrd.make((BOrd)((BWbShell)shell).getActiveOrd(), (BOrd)ord).normalize();
                        ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
                        break;
                    }
                    case 2: {
                        BHyperlinkMode hyperlinkmode = BHyperlinkMode.make((String)"newShell");
                        ord = BOrd.make((BOrd)((BWbShell)shell).getActiveOrd(), (BOrd)ord).normalize();
                        ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, hyperlinkmode));
                        break;
                    }
                    case 1: {
                        BHyperlinkMode hyperlinkmode = BHyperlinkMode.make((String)"newTab");
                        ord = BOrd.make((BOrd)((BWbShell)shell).getActiveOrd(), (BOrd)ord).normalize();
                        ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, hyperlinkmode));
                    }
                }
            }
        }
    }

    String toShowStatus() {
        BOrd hyperlink = this.getHyperlink();
        if (hyperlink.isNull()) {
            return "";
        }
        BWidgetShell shell = this.getShell();
        if (shell instanceof BNiagaraWbApplet) {
            return "Link to " + hyperlink + " | target " + this.getBrowserTarget();
        }
        if (shell instanceof BIHyperlinkShell) {
            return "Link to " + hyperlink + " | target " + this.getWbTarget();
        }
        return "Link to ";
    }
}

