/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.util.point;

import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="updateInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)")})
public abstract class BPeriodicNumericPoint
extends BNumericPoint {
    @Generated
    public static final Property enabled = BPeriodicNumericPoint.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property updateInterval = BPeriodicNumericPoint.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPeriodicNumericPoint.class);
    private Clock.Ticket ticket = null;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRelTime getUpdateInterval() {
        return (BRelTime)this.get(updateInterval);
    }

    @Generated
    public void setUpdateInterval(BRelTime v) {
        this.set(updateInterval, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.initTimer();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == updateInterval || prop == enabled) {
            if (this.getUpdateInterval().getMillis() < 1000L) {
                this.setUpdateInterval(BRelTime.make((long)1000L));
            }
            if (this.isRunning()) {
                this.initTimer();
            }
        }
    }

    private void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.getEnabled()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateInterval(), (Action)execute, null);
        }
    }
}

