/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.device;

import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferResult;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.gx.BImage;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.mgr.MgrController;

public class DeviceMatchArtifact
implements CommandArtifact {
    static final BImage clockIcon = BImage.make((String)"module://icons/x32/clock.png");
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexPleaseWait = this.lex.getText("pleaseWait");
    BDeviceManager manager;
    Object[] discovered;
    BDevice[] deployed;
    Context context;
    TransferResult result;

    public DeviceMatchArtifact(BDeviceManager manager, Object[] discovered, BDevice[] deployed, Context cx) {
        this.manager = manager;
        this.discovered = discovered;
        this.deployed = deployed;
        this.context = cx;
    }

    public TransferResult getResult() {
        return this.result;
    }

    public String[] getInsertNames() {
        return this.getResult().getInsertNames();
    }

    public void undo() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void redo() throws Exception {
        MatchStrategy strategy = new MatchStrategy();
        if (strategy == null) {
            throw new LocalizableException("bajaui", "transfer.noStrategy");
        }
        new Worker().match(strategy);
    }

    class MatchStrategy {
        TransferListener listener;

        MatchStrategy() {
        }

        TransferResult match() throws Exception {
            for (int i = 0; i < DeviceMatchArtifact.this.deployed.length; ++i) {
                if (DeviceMatchArtifact.this.discovered[i] == null || DeviceMatchArtifact.this.deployed[i] == null) continue;
                this.updateStatus("Matching device: " + DeviceMatchArtifact.this.deployed[i].getName());
                try {
                    DeviceMatchArtifact.this.manager.getController().doMatch(DeviceMatchArtifact.this.discovered[i], (BComponent)DeviceMatchArtifact.this.deployed[i], MgrController.quickContext);
                    DeviceMatchArtifact.this.deployed[i].setEnabled(true);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return DeviceMatchArtifact.this.result;
        }

        public TransferListener getListener() {
            return this.listener;
        }

        public void setListener(TransferListener listener) {
            this.listener = listener;
        }

        public void updateStatus(String msg) {
            try {
                if (this.listener != null) {
                    this.listener.updateStatus(msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Worker
    extends Thread
    implements TransferListener {
        MatchStrategy strategy;
        Exception exception;
        BDialog dialog;
        BLabel status;
        Object lock = new Object();
        boolean done;
        boolean isDialogOpen = false;

        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void match(MatchStrategy strategy) throws Exception {
            this.strategy = strategy;
            strategy.setListener(this);
            this.status = new BLabel(clockIcon, DeviceMatchArtifact.this.lexPleaseWait);
            this.status.setHalign(BHalign.left);
            BConstrainedPane pane = new BConstrainedPane((BWidget)this.status);
            pane.setMinHeight(20.0);
            pane.setMinWidth(450.0);
            this.dialog = new BDialog((BWidget)DeviceMatchArtifact.this.manager, DeviceMatchArtifact.this.lexPleaseWait, true, (BWidget)new BBorderPane((BWidget)pane));
            this.start();
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(1000L);
            }
            if (!this.done) {
                this.dialog.setBoundsCenteredOnOwner();
                this.isDialogOpen = true;
                this.dialog.open();
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void updateStatus(String msg) {
            if (this.status == null) {
                return;
            }
            this.status.setText(msg);
            this.status.relayout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DeviceMatchArtifact.this.result = this.strategy.match();
            }
            catch (Exception e) {
                this.exception = e;
            }
            Object object = this.lock;
            synchronized (object) {
                this.done = true;
                this.lock.notifyAll();
            }
            this.dialog.close();
        }
    }
}

