/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.device;

import com.tridium.sys.transfer.DeployToComp;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.workbench.transfer.TransferArtifact;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceMatchArtifact;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderModel;

public class DeviceModel
extends FolderModel {
    BIDeviceFolder folder;
    Type deviceType = BDevice.TYPE;
    Type folderType = BDeviceFolder.TYPE;

    public DeviceModel(BDeviceManager manager) {
        super((BFolderManager)manager);
    }

    public Type getFolderType() {
        return this.folderType;
    }

    public Type getBaseNewType() {
        return BDevice.TYPE;
    }

    public MgrTypeInfo[] getNewTypes() {
        return MgrTypeInfo.makeArray((Type)this.deviceType);
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Path(2), new MgrColumn.Name(), new MgrColumn.Type(), new MgrColumn.Prop(BDevice.status), new MgrColumn.Prop(BDevice.enabled, 3), new MgrColumn.Prop(BDevice.health), new MgrColumn.Prop(BDevice.faultCause)};
    }

    public Type[] getIncludeTypes() {
        return new Type[]{this.deviceType, this.folderType};
    }

    public void load(BComponent target) {
        this.folder = (BIDeviceFolder)target;
        try {
            this.deviceType = this.folder.getDeviceType();
            this.folderType = this.folder.getDeviceFolderType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.load(target);
    }

    public Object[] prepareDeployMatch(Object[] discObj, BDevice[] addedDevices, Context cx) {
        return discObj;
    }

    public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
        if (this.getManager().getController().templateMode.isSelected() && this.getManager().getMgrTemplate().getTable().getSelectedObjects().length == 1) {
            return this.addDevTemplateInstances(rows, cx);
        }
        return super.addInstances(rows, cx);
    }

    public CommandArtifact addDevTemplateInstances(MgrEditRow[] rows, Context cx) {
        TemplateManager.TemplateInfo templateInfo = (TemplateManager.TemplateInfo)this.getManager().getMgrTemplate().getTable().getSelectedObject();
        BNtplFile selDevTemplate = templateInfo.getNtplFile();
        BWbDeployableNtplFile selDevDeployableTemplate = BWbDeployableNtplFile.make((BNtplFile)selDevTemplate);
        BComponent target = this.getManager().getTarget();
        String deployName = selDevDeployableTemplate.getDeployName();
        BDevice[] addedDevices = new BDevice[rows.length];
        String[] addedNames = new String[addedDevices.length];
        String[] deployNames = new String[addedDevices.length];
        BWbDeployableNtplFile[] templates = new BWbDeployableNtplFile[rows.length];
        Object[] discoverObjs = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            templates[i] = selDevDeployableTemplate;
            deployNames[i] = deployName;
            discoverObjs[i] = rows[i].getDiscovery();
        }
        try {
            Mark mark = new Mark((BObject[])templates, deployNames);
            TransferArtifact art = new TransferArtifact((BWidget)this.getManager(), 16, mark, (BObject)target, null, DeployToComp.NoPostConfigEdit);
            art.redo();
            if (art.getResult() == null) {
                return null;
            }
            TransferResult tr = art.getResult();
            addedNames = tr.getInsertNames();
            for (int i = 0; i < addedDevices.length; ++i) {
                addedDevices[i] = (BDevice)target.get(addedNames[i]);
            }
            Object[] processedObjects = this.prepareDeployMatch(discoverObjs, addedDevices, cx);
            DeviceMatchArtifact matchArt = new DeviceMatchArtifact((BDeviceManager)this.getManager(), processedObjects, addedDevices, cx);
            matchArt.redo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getManager().getModel().getTable().selectByName(addedNames);
        try {
            MgrController mgrController = this.getManager().getController();
            if (mgrController instanceof DeviceController) {
                ((DeviceController)mgrController).doEditTemplate(cx);
            }
            mgrController.doEdit(cx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

