/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.history;

import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ImportModel
extends ArchiveModel {
    static final Lexicon histLex = Lexicon.make((String)"history");

    public ImportModel(BHistoryImportManager manager) {
        super(manager);
    }

    public int getSubscribeDepth() {
        return 2;
    }

    public Type[] getIncludeTypes() {
        BObject val;
        BArchiveManager mgr = (BArchiveManager)this.getManager();
        if (mgr.supportsArchiveFolders() && (val = mgr.getCurrentValue()) instanceof BIArchiveFolder) {
            BIArchiveFolder folder = (BIArchiveFolder)val;
            Type folderType = folder.getArchiveFolderType();
            return new Type[]{BHistoryImport.TYPE, folderType};
        }
        return new Type[]{BHistoryImport.TYPE};
    }

    public MgrTypeInfo[] getNewTypes() {
        return MgrTypeInfo.makeArray((Type)BHistoryImport.TYPE);
    }

    public BComponent newInstance(MgrTypeInfo type) throws Exception {
        BHistoryImport result = (BHistoryImport)super.newInstance(type);
        BComponent overrides = result.getConfigOverrides();
        overrides.add("capacity", (BValue)BCapacity.UNLIMITED, 0);
        overrides.add("fullPolicy", (BValue)BFullPolicy.roll, 0);
        return result;
    }

    @Override
    protected MgrColumn[] makeColumns() {
        MgrColumn[] cols = super.makeColumns();
        MgrColumn[] result = new MgrColumn[cols.length + 2];
        System.arraycopy(cols, 0, result, 0, cols.length);
        result[result.length - 2] = new ConfigColumn("capacity", histLex.getText("HistoryConfig.capacity"), 3, (BValue)BCapacity.UNLIMITED);
        result[result.length - 1] = new ConfigColumn("fullPolicy", histLex.getText("HistoryConfig.fullPolicy"), 3, (BValue)BFullPolicy.roll);
        return result;
    }

    public static class ConfigColumn
    extends MgrColumn {
        String propName;
        BValue defaultValue;

        public ConfigColumn(String propName, String displayName, int flags, BValue defaultValue) {
            super(displayName, flags);
            this.propName = propName;
            this.defaultValue = defaultValue;
        }

        public Object get(Object row) {
            BHistoryImport desc = (BHistoryImport)row;
            return desc.getConfigOverrides().get(this.propName);
        }

        public BValue load(MgrEditRow row) {
            BValue value = (BValue)this.get(row.getTarget());
            if (value == null) {
                value = this.defaultValue;
            }
            return value.newCopy();
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BHistoryImport desc = (BHistoryImport)row.getTarget();
            BComponent configOverrides = desc.getConfigOverrides();
            Property prop = configOverrides.getProperty(this.propName);
            if (prop == null) {
                configOverrides.add(this.propName, value);
            } else {
                configOverrides.set(prop, value, cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            BValue val = rows[0].getCell(colIndex);
            Property prop = BHistoryImport.configOverrides;
            BFacets facets = prop.getFacets();
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)facets);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, (Context)facets);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }
}

