/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.schedule;

import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.driver.ui.schedule.BScheduleImportManager;
import javax.baja.driver.util.BDescriptor;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTriggerSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ScheduleImportModel
extends MgrModel {
    public MgrColumn nameCol;
    public Ext idCol;
    BScheduleDeviceExt devicelet;

    public ScheduleImportModel(BScheduleImportManager manager) {
        super((BAbstractManager)manager);
    }

    public MgrTypeInfo[] getNewTypes() {
        return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanSchedule.TYPE), MgrTypeInfo.make((Type)BNumericSchedule.TYPE), MgrTypeInfo.make((Type)BEnumSchedule.TYPE), MgrTypeInfo.make((Type)BStringSchedule.TYPE), MgrTypeInfo.make((Type)BCalendarSchedule.TYPE), MgrTypeInfo.make((Type)BTriggerSchedule.TYPE)};
    }

    public int getSubscribeDepth() {
        return 3;
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BAbstractSchedule.TYPE};
    }

    public boolean accept(BComponent c) {
        return ScheduleImportModel.ext(c) != null;
    }

    public void load(BComponent target) {
        this.devicelet = (BScheduleDeviceExt)target;
        super.load(target);
    }

    public BComponent newInstance(MgrTypeInfo type) throws Exception {
        BAbstractSchedule ret = (BAbstractSchedule)type.newInstance();
        BScheduleImportExt ext = this.devicelet.makeImportExt();
        ret.add("ext", (BValue)ext);
        return ret;
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] mgrColumnArray = new MgrColumn[11];
        mgrColumnArray[0] = this.nameCol = new MgrColumn.Name();
        mgrColumnArray[1] = new MgrColumn.Type(4);
        this.idCol = new Ext(BScheduleImportExt.supervisorId, 1);
        mgrColumnArray[2] = this.idCol;
        mgrColumnArray[3] = new Ext(BDescriptor.state, 4);
        mgrColumnArray[4] = new Ext(BDescriptor.status, 4);
        mgrColumnArray[5] = new Ext(BDescriptor.enabled, 3);
        mgrColumnArray[6] = new TimeCol(2);
        mgrColumnArray[7] = new Ext(BDescriptor.lastAttempt, 6);
        mgrColumnArray[8] = new Ext(BDescriptor.lastSuccess, 4);
        mgrColumnArray[9] = new Ext(BDescriptor.lastFailure, 6);
        mgrColumnArray[10] = new Ext(BDescriptor.faultCause, 6);
        return mgrColumnArray;
    }

    private static BScheduleImportExt ext(Object o) {
        return BScheduleDeviceExt.getExt((BAbstractSchedule)((BAbstractSchedule)o));
    }

    public static class TimeCol
    extends MgrColumn {
        public TimeCol(int flags) {
            super(BDescriptor.executionTime.getDefaultDisplayName(null), flags);
        }

        public Object get(Object row) {
            return TimeCol.trig(row).getTriggerMode();
        }

        public BValue load(MgrEditRow row) {
            return TimeCol.trig(row.getTarget()).getTriggerMode().newCopy();
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAbstractSchedule sch = (BAbstractSchedule)row.getTarget();
            BScheduleDeviceExt.getExt((BAbstractSchedule)sch);
            BTriggerMode cur = TimeCol.trig(row.getTarget()).getTriggerMode();
            if (!cur.equals((Object)value)) {
                TimeCol.trig(row.getTarget()).setTriggerMode((BTriggerMode)value.newCopy());
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BTriggerMode val = TimeCol.trig(rows[0].getTarget()).getTriggerMode();
            Class<?> cls = val.getClass();
            for (int i = 1; i < rows.length; ++i) {
                if (TimeCol.trig(rows[i].getTarget()).getTriggerMode().getClass() == cls) continue;
                return null;
            }
            BFacets facets = rows.length == 1 ? TimeCol.trig(rows[0].getTarget()).getSlotFacets((Slot)BTimeTrigger.triggerMode) : BTimeTrigger.triggerMode.getFacets();
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)facets);
            editor.loadValue((BObject)TimeCol.trig(rows[0].getTarget()).getTriggerMode());
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (MgrEditRow row : rows) {
                row.setCell(colIndex, val);
            }
        }

        private static BTimeTrigger trig(Object row) {
            BAbstractSchedule sch = (BAbstractSchedule)row;
            BScheduleImportExt ext = BScheduleDeviceExt.getExt((BAbstractSchedule)sch);
            return ext.getExecutionTime();
        }
    }

    public static class Ext
    extends MgrColumn {
        Property prop;

        public Ext(Property prop, int flags) {
            super(prop.getDefaultDisplayName(null), flags);
            this.prop = prop;
        }

        public Object get(Object row) {
            return ScheduleImportModel.ext(row).get(this.prop);
        }

        public BValue load(MgrEditRow row) {
            return ((BValue)this.get(row.getTarget())).newCopy();
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BScheduleImportExt target = ScheduleImportModel.ext(row.getTarget());
            BValue old = target.get(this.prop);
            if (!old.equivalent((Object)value)) {
                target.set(this.prop, value.newCopy(), cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BScheduleImportExt val = ScheduleImportModel.ext(rows[0].getTarget());
            BFacets facets = val.getSlotFacets((Slot)this.prop);
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val.get(this.prop), (Context)facets);
            editor.loadValue((BObject)val.get(this.prop));
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (MgrEditRow row : rows) {
                row.setCell(colIndex, val);
            }
        }
    }
}

