/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.ui;

import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.ObjectIdentifiers;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.ui.NMgrLearn;
import com.tridium.ndriver.ui.point.BNPointManager;
import com.tridium.ndriver.ui.point.NPointController;
import com.tridium.ndriver.ui.point.NPointModel;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.point.BOpcUaClientPointFolder;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.point.BOpcUaLearnBase;
import com.tridium.opcUaClient.point.BOpcUaMethod;
import com.tridium.opcUaClient.point.BOpcUaMethodProxyExt;
import com.tridium.opcUaClient.point.BOpcUaNodeLearnEntry;
import com.tridium.opcUaClient.point.BOpcUaObject;
import com.tridium.opcUaClient.ui.BNodeIdDialog;
import com.tridium.opcUaCore.util.OpcUaCoreUtil;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.gx.RectGeom;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"opcUaClient:OpcUaClientPointDeviceExt", "opcUaClient:OpcUaClientPointFolder", "opcUaClient:OpcUaClientArrayFolder"})})
public class BOpcUaClientPointManager
extends BNPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaClientPointManager.class);
    private static final Lexicon LEX = Lexicon.make(BOpcUaClientPointManager.class);
    private static final Logger LOGGER = Logger.getLogger("opcUaClient.opcUaClientPointManager");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colNodeId = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaClientProxyExt.uaNodeId}, 1);
    MgrColumn colArrayDimensions = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaClientProxyExt.arrayDimensions}, 3);
    MgrColumn colArrayIndex = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaClientProxyExt.arrayIndex}, 1);
    MgrColumn colStatusCode = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaClientProxyExt.uaStatusCode}, 4);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colToString, this.colNodeId, this.colArrayDimensions, this.colArrayIndex, this.colStatusCode, this.colEnabled, this.colFacets, this.colTuning, this.colDeviceFacets, this.colConversion, this.colFaultCause, this.colReadValue, this.colWriteValue};
    Type proxyExtType = BOpcUaClientProxyExt.TYPE;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn((BAbstractManager)this);
    }

    class Learn
    extends NMgrLearn {
        public Learn(BAbstractManager manager) {
            super(manager);
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public boolean hasChildren(Object discovery) {
            return this.getChildren(discovery).length > 0;
        }

        public Object[] getChildren(Object discovery) {
            ArrayList<BOpcUaLearnBase> list = new ArrayList<BOpcUaLearnBase>();
            BOpcUaLearnBase[] children = (BOpcUaLearnBase[])((BComponent)discovery).getChildren(BOpcUaLearnBase.class);
            if (children == null) {
                return new Object[0];
            }
            for (BOpcUaLearnBase child : children) {
                if (!child.isAddable() && !child.getHasAddableDescendant()) continue;
                list.add(child);
            }
            return list.toArray();
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BLearnTable table = this.getTable();
            TreeTableModel model = table.getTreeTableModel();
            TreeTableNode root = model.getRoot(0);
            root.setExpanded(true);
        }

        public void load(BComponent target) {
            this.loadLearnData();
        }

        private BOrd getLearnOrd() {
            BComponent target = this.getTarget();
            if (target instanceof BIPointFolder) {
                BOpcUaDevice device = (BOpcUaDevice)((BIPointFolder)target).getDevice();
                device.lease(Integer.MAX_VALUE);
                BValue learnRoot = device.get("serverRoot");
                if (learnRoot != null && learnRoot instanceof BOpcUaNodeLearnEntry) {
                    return ((BOpcUaNodeLearnEntry)learnRoot).getSlotPathOrd();
                }
            }
            return BOrd.NULL;
        }

        public void loadLearnData() {
            BComponent target = this.getTarget();
            if (target instanceof BIPointFolder) {
                BLearnTable table;
                TreeTableModel model;
                int rootCount;
                BOpcUaDevice device = (BOpcUaDevice)((BIPointFolder)target).getDevice();
                device.lease(Integer.MAX_VALUE);
                BValue learnRoot = device.get("serverRoot");
                if (learnRoot != null && learnRoot instanceof BOpcUaNodeLearnEntry) {
                    this.updateRoots(device.getLearnedPoints());
                }
                if ((rootCount = (model = (table = this.getTable()).getTreeTableModel()).getRootCount()) > 0) {
                    TreeTableNode root = model.getRoot(0);
                    root.setExpanded(true);
                }
            }
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            if (discovery instanceof BINDiscoveryLeaf) {
                BINDiscoveryLeaf discoveryLeaf = (BINDiscoveryLeaf)discovery;
                TypeInfo[] validDbTypes = discoveryLeaf.getValidDatabaseTypes();
                return MgrTypeInfo.makeArray((TypeInfo[])validDbTypes);
            }
            return MgrTypeInfo.makeArray((TypeInfo[])new TypeInfo[0]);
        }

        public void syncTo(BOpcUaClientProxyExt proxyExt) {
            BLearnTable table = this.getTable();
            TreeTableModel model = table.getTreeTableModel();
            TreeTableNode root = model.getRoot(0);
            root.setExpanded(true);
            Object[] roots = this.getRoots();
            BOpcUaLearnBase matchNodeId = null;
            for (BOpcUaLearnBase learnBase : (BOpcUaLearnBase[])CompUtil.getDescendants((BComponent)((BComponent)roots[0]), BOpcUaLearnBase.class)) {
                String arrayIndex = proxyExt.getArrayIndex();
                if (!learnBase.getUaNodeId().equals(proxyExt.getUaNodeId()) || !arrayIndex.isEmpty() && !arrayIndex.equals(learnBase.getArrayIndex())) continue;
                matchNodeId = learnBase;
                SlotPath slotPath = learnBase.getSlotPath();
                break;
            }
            if (matchNodeId != null) {
                ArrayList<String> names = new ArrayList<String>();
                names.add(matchNodeId.getUaNodeName());
                for (BComplex parent = matchNodeId.getParent(); parent != null && parent instanceof BOpcUaLearnBase; parent = parent.getParent()) {
                    String name = ((BOpcUaLearnBase)parent).getUaNodeName();
                    names.add(name);
                }
                int start = names.size() - 1;
                StringBuilder sb = new StringBuilder();
                for (int i = start; i >= 0; --i) {
                    String nodeName = (String)names.get(i);
                    sb.append(nodeName).append('/');
                }
                String s = sb.toString();
                String[] namePath = s.split("/");
                int depth = 0;
                boolean done = false;
                boolean found = false;
                while (!done || !found) {
                    if (depth == 0) {
                        String name = namePath[depth];
                        String valueAt = root.getValueAt(0).toString();
                        if (valueAt.equals(name)) {
                            root.setExpanded(true);
                            ++depth;
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    int childCount = root.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        TreeTableNode child = root.getChild(i);
                        String valueAt = child.getValueAt(0).toString();
                        if (!valueAt.equals(namePath[depth])) continue;
                        child.setExpanded(true);
                        root = child;
                        if (++depth != namePath.length) break;
                        found = true;
                        int row = model.nodeToRow(child);
                        table.getSelection().deselectAll();
                        table.getSelection().select(row);
                        boolean isVisible = model.isNodeVisibleRow(child);
                        RectGeom r = new RectGeom(0.0, 0.0, BOpcUaClientPointManager.this.getWidth(), BOpcUaClientPointManager.this.getHeight());
                        table.scrollToVisible(r);
                        break;
                    }
                    done = true;
                }
            }
        }
    }

    class Controller
    extends NPointController {
        boolean useDefaultDiscovery;

        Controller(BNPointManager mgr) {
            super(mgr);
            this.useDefaultDiscovery = true;
        }

        public BMenu makePopup(BLearnTable table, TreeTableSubject subject, BMenu menu) {
            menu = super.makePopup(table, subject, menu);
            menu.add("sync", (Command)new SyncDiscovered((BWidget)table, subject != null, "syncDisovered"));
            return menu;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            MgrEdit edit = this.makeEdit(this.add.getLabel());
            for (Object o : discovery) {
                BOpcUaLearnBase dis = (BOpcUaLearnBase)o;
                MgrTypeInfo[] types = this.getManager().getLearn().toTypes((Object)dis);
                String discoveryName = dis.getDiscoveryName();
                if (types == null || types.length == 0) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Skipping " + discoveryName + " - no learn types found");
                    continue;
                }
                BComponent newComp = types[0].newInstance();
                if (newComp.getType().is(BOpcUaObject.TYPE)) {
                    int confirm = BDialog.confirm((BWidget)this.getManager(), (Object)LEX.getText("opcUaDevice.pointManager.doAdd.addFolderDialog.msg.folderName", new Object[]{discoveryName}));
                    BComponent target = this.getManager().getTarget();
                    ((BOpcUaObject)newComp).setUaNodeId(dis.getUaNodeId());
                    if (confirm != 4) continue;
                    target.add(SlotPath.escape((String)discoveryName), (BValue)newComp);
                    target.lease();
                    dis.lease();
                    BOpcUaObject folder = (BOpcUaObject)target.get(SlotPath.escape((String)discoveryName));
                    boolean isArrayFolderSupported = ((Version)folder.fw(404, (Object)"opcUaClient", (Object)"rt", null, null)).compareTo(OpcUaCoreUtil.ADDING_ARRAYS_DIRECTLY_FIRST_VERSION) >= 0;
                    this.addPointFolder((BOpcUaClientPointFolder)folder, dis, isArrayFolderSupported);
                    continue;
                }
                MgrEditRow row = edit.addRow((Object)dis, types);
                BOpcUaClientPointManager.this.getLearn().toRow((Object)dis, row);
            }
            return edit.invoke(cx);
        }

        private void addPointFolder(BOpcUaClientPointFolder folder, BOpcUaLearnBase dis, boolean isArrayFolderSupported) {
            BOpcUaLearnBase[] children;
            dis.lease();
            for (BOpcUaLearnBase child : children = (BOpcUaLearnBase[])dis.getChildren(BOpcUaLearnBase.class)) {
                BOpcUaClientPointFolder childFolder;
                if (child.isArray() && !isArrayFolderSupported) {
                    BOpcUaLearnBase[] addArray;
                    for (BOpcUaLearnBase addEntry : addArray = child.getArray()) {
                        BControlPoint addPoint = addEntry.makePoint();
                        if (addPoint == null) continue;
                        folder.add(SlotPath.escape((String)addEntry.getDiscoveryName()), (BValue)addPoint);
                    }
                } else {
                    BControlPoint addPoint = child.makePoint();
                    if (addPoint != null) {
                        folder.add(SlotPath.escape((String)child.getDiscoveryName()), (BValue)addPoint);
                    }
                }
                if ((childFolder = child.makePointFolder(isArrayFolderSupported)) == null) continue;
                String childFolderName = child.getDiscoveryName();
                folder.add(SlotPath.escape((String)childFolderName), (BValue)childFolder);
                BOpcUaClientPointFolder subFolder = (BOpcUaClientPointFolder)folder.get(childFolderName);
                this.addPointFolder(subFolder, child, isArrayFolderSupported);
            }
        }

        public void updateCommands() {
            try {
                super.updateCommands();
            }
            catch (Exception exception) {
                // empty catch block
            }
            MgrLearn learn = BOpcUaClientPointManager.this.getLearn();
            BLearnTable table = learn.getTable();
            if (table == null) {
                return;
            }
            Object[] selectedObjects = table.getSelectedObjects();
            if (selectedObjects.length == 0) {
                return;
            }
            boolean enable = true;
            for (Object selectedObject : selectedObjects) {
                boolean isUaObject;
                if (!(selectedObject instanceof BOpcUaLearnBase)) continue;
                BOpcUaLearnBase selObj = (BOpcUaLearnBase)selectedObject;
                String typeSpec = selObj.getTypeSpec();
                String nodeClass = selObj.getNodeClass();
                boolean bl = isUaObject = nodeClass.equals("Object") || nodeClass.equals("Method");
                if (isUaObject || !typeSpec.isEmpty()) continue;
                enable = false;
                break;
            }
            this.add.setEnabled(this.add.isEnabled() && enable);
        }

        public CommandArtifact doSyncDiscovered() throws Exception {
            BAbstractProxyExt proxyExt;
            BComponent selectedComponent = BOpcUaClientPointManager.this.getModel().getTable().getSelectedComponent();
            if (selectedComponent instanceof BControlPoint && (proxyExt = ((BControlPoint)selectedComponent).getProxyExt()) instanceof BOpcUaClientProxyExt) {
                BOpcUaClientProxyExt opcProxy = (BOpcUaClientProxyExt)proxyExt;
                ((Learn)BOpcUaClientPointManager.this.getLearn()).syncTo(opcProxy);
            }
            return null;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            BComponent target = this.getTarget();
            if (target instanceof BIPointFolder) {
                NodeId loadedNodeId;
                BOpcUaDevice device = (BOpcUaDevice)((BIPointFolder)target).getDevice();
                try {
                    loadedNodeId = NodeId.parseNodeId((String)device.getLearnRootNodeIdString());
                }
                catch (IllegalArgumentException ignored) {
                    loadedNodeId = ObjectIdentifiers.RootFolder;
                }
                BNodeIdDialog dialog = new BNodeIdDialog((BWidget)this.getManager(), loadedNodeId, this.useDefaultDiscovery);
                dialog.setBoundsCenteredOnOwner();
                dialog.setResizable(true);
                dialog.open();
                if (dialog.wasCancelled()) {
                    return null;
                }
                this.useDefaultDiscovery = dialog.getLastUseDefault();
                device.setLearnRootNodeIdString(dialog.getNodeId().toString());
            }
            return super.doDiscover(cx);
        }

        private class SyncDiscovered
        extends MgrController.MgrCommand {
            SyncDiscovered(BWidget owner, boolean enable, String label) {
                super(owner, label);
                this.setEnabled(enable);
            }

            public CommandArtifact doInvoke() throws Exception {
                return Controller.this.doSyncDiscovered();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }
    }

    class Model
    extends NPointModel {
        Model(BNPointManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BOpcUaClientPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BComponent newComp = type.newInstance();
            BOpcUaClientProxyExt proxyExt = new BOpcUaClientProxyExt();
            if (newComp instanceof BOpcUaMethod) {
                proxyExt = new BOpcUaMethodProxyExt();
            }
            if (newComp instanceof BControlPoint) {
                BControlPoint pt = (BControlPoint)newComp;
                pt.setProxyExt((BAbstractProxyExt)proxyExt);
            }
            return newComp;
        }
    }
}

