/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.ui;

import com.tridium.opcUaCore.enums.BSecurityMode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"opcUaCore:SecurityMode"})})
public class BSecurityModeFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BSecurityModeFE.class);
    private final BListDropDown securityModeDropDown = new BListDropDown();
    private BSecurityMode clientSecurityMode = null;
    public static final Lexicon lex = Lexicon.make(BSecurityModeFE.class);
    private final String dialog = lex.getText("opcUaClient.securityDialog");
    private final String message = lex.getText("opcUaClient.securityMessage");
    private static final String NONE = lex.getText("opcUaClient.securityMode.text.none");
    private static final String SIGN_BASIC256 = lex.getText("opcUaClient.securityMode.text.signBasic256");
    private static final String SIGN_BASIC128_RSA15 = lex.getText("opcUaClient.securityMode.text.signBasic128Rsa15");
    private static final String SIGN_BASIC256_SHA256 = lex.getText("opcUaClient.securityMode.text.signBasic256Sha256");
    private static final String SIGN_ENCRYPT_BASIC256 = lex.getText("opcUaClient.securityMode.text.signAndEncryptBasic256");
    private static final String SIGN_ENCRYPT_BASIC128_RSA15 = lex.getText("opcUaClient.securityMode.text.signAndEncryptBasic128Rsa15");
    private static final String SIGN_ENCRYPT_BASIC256_SHA256 = lex.getText("opcUaClient.securityMode.text.signAndEncryptBasic256Sha256");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSecurityModeFE() {
        this.setContent((BWidget)this.securityModeDropDown);
        this.linkTo((BComponent)this.securityModeDropDown, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.securityModeDropDown, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doLoadValue(BObject value, Context paramContext) throws Exception {
        this.clientSecurityMode = (BSecurityMode)value;
        this.securityModeDropDown.getList().removeAllItems();
        this.securityModeDropDown.getList().addItem((Object)SIGN_ENCRYPT_BASIC256_SHA256);
        this.securityModeDropDown.getList().addItem((Object)SIGN_ENCRYPT_BASIC128_RSA15);
        this.securityModeDropDown.getList().addItem((Object)SIGN_ENCRYPT_BASIC256);
        this.securityModeDropDown.getList().addItem((Object)SIGN_BASIC256_SHA256);
        this.securityModeDropDown.getList().addItem((Object)SIGN_BASIC128_RSA15);
        this.securityModeDropDown.getList().addItem((Object)SIGN_BASIC256);
        this.securityModeDropDown.getList().addItem((Object)NONE);
        this.securityModeDropDown.setSelectedItem((Object)BSecurityModeFE.getModeText(this.clientSecurityMode));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BSecurityMode securityMode = this.clientSecurityMode = BSecurityModeFE.getMode((String)this.securityModeDropDown.getSelectedItem());
        if (this.clientSecurityMode instanceof BSecurityMode && BSecurityMode.none.equals((Object)this.clientSecurityMode)) {
            int confirm = BDialog.confirm((BWidget)this, (String)this.dialog, (Object)this.message);
            securityMode = confirm == 4 ? this.clientSecurityMode : (BSecurityMode)this.securityModeDropDown.getList().getItem(0);
        }
        return securityMode;
    }

    public static String getModeText(BSecurityMode mode) {
        if (BSecurityMode.none.equals((Object)mode)) {
            return NONE;
        }
        if (BSecurityMode.signBasic256.equals((Object)mode)) {
            return SIGN_BASIC256;
        }
        if (BSecurityMode.signBasic128Rsa15.equals((Object)mode)) {
            return SIGN_BASIC128_RSA15;
        }
        if (BSecurityMode.signBasic256Sha256.equals((Object)mode)) {
            return SIGN_BASIC256_SHA256;
        }
        if (BSecurityMode.signEcriptBasic256.equals((Object)mode)) {
            return SIGN_ENCRYPT_BASIC256;
        }
        if (BSecurityMode.signEcriptBasic128Rsa15.equals((Object)mode)) {
            return SIGN_ENCRYPT_BASIC128_RSA15;
        }
        return SIGN_ENCRYPT_BASIC256_SHA256;
    }

    public static BSecurityMode getMode(String modeText) {
        if (NONE.equals(modeText)) {
            return BSecurityMode.none;
        }
        if (SIGN_BASIC256.equals(modeText)) {
            return BSecurityMode.signBasic256;
        }
        if (SIGN_BASIC128_RSA15.equals(modeText)) {
            return BSecurityMode.signBasic128Rsa15;
        }
        if (SIGN_BASIC256_SHA256.equals(modeText)) {
            return BSecurityMode.signBasic256Sha256;
        }
        if (SIGN_ENCRYPT_BASIC256.equals(modeText)) {
            return BSecurityMode.signEcriptBasic256;
        }
        if (SIGN_ENCRYPT_BASIC128_RSA15.equals(modeText)) {
            return BSecurityMode.signEcriptBasic128Rsa15;
        }
        return BSecurityMode.signEcriptBasic256Sha256;
    }
}

