/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BUploadRegionParams;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupReadRegionDataMessage;
import com.tridium.aapup.messages.PupRegionDataResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileStore;
import java.io.OutputStream;
import javax.baja.file.FilePath;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BPupUploadRegionJob
extends BSimpleJob
implements AaPupConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BPupUploadRegionJob.class);
    String host;
    FilePath path;
    String user;
    private BPupNetwork network;
    private BPupDevice device;
    private BUploadRegionParams params;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPupUploadRegionJob() {
    }

    public BPupUploadRegionJob(BPupDevice device, BUploadRegionParams params) {
        this.device = device;
        this.params = params;
        this.network = device.pupNetwork();
    }

    public void run(Context cx) throws Exception {
        boolean problem = true;
        if (this.device == null) {
            throw new IllegalStateException("Must submit thru PupDevice.submitUploadRegionJob()");
        }
        String sessionId = this.params.getPostSessionId();
        FoxSession session = Fox.getSession((String)sessionId);
        if (session == null) {
            throw new Exception("Invalid fox session id: " + sessionId);
        }
        BFoxConnection conn = (BFoxConnection)session.conn();
        BFileChannel chan = conn.getChannels().getFileChannel();
        this.host = session.getRemoteHost();
        this.path = new FilePath(this.params.getPostPath());
        this.user = cx == null ? "unknown" : String.valueOf(cx.getUser());
        this.logMessage("Host: " + this.host);
        this.logMessage("Path: " + this.path);
        this.logMessage("User: " + this.user);
        int regionNumber = this.params.getRegionNumber();
        System.out.println("uploading region number " + regionNumber);
        String regionName = this.params.getRegionName();
        int regionSize = this.params.getRegionSize();
        String errorMsg = "";
        byte[] splBytes = new byte[regionSize];
        int address = this.device.getUnitNumber();
        if (!this.isAlive()) {
            return;
        }
        this.logMessage("Preparing to upload region " + this.params.getRegionName() + " to file " + this.params.getPostPath());
        this.progress(0);
        PupResponse rsp = (PupResponse)this.network.sendSync(new PupHelloMessage(this.device.getSerialNumber() | 0x8000));
        if (rsp != null && rsp.getIn().verifyChecksum() && rsp instanceof PupAckResponse) {
            address = this.device.getSerialNumber() | 0x8000;
        }
        int lastBytesRead = 0;
        int offset = 0;
        while (offset < regionSize) {
            int bytesToRead = regionSize - offset;
            if (bytesToRead > 512) {
                bytesToRead = 512;
            }
            if ((rsp = (PupResponse)this.network.sendSync(new PupReadRegionDataMessage(address, regionNumber, offset, bytesToRead), BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * 3L)), this.network.getRetryCount())) != null) {
                if (rsp.getIn().verifyChecksum()) {
                    if (rsp instanceof PupRegionDataResponse) {
                        PupRegionDataResponse regRsp = (PupRegionDataResponse)rsp;
                        System.out.println("  --regRsp.getBytes().length:" + regRsp.getBytes().length);
                        System.out.println("  --regRsp.getOffset():" + regRsp.getOffset());
                        lastBytesRead = regRsp.getBytes().length;
                        try {
                            System.arraycopy(regRsp.getBytes(), 0, splBytes, regRsp.getOffset(), lastBytesRead);
                            problem = false;
                        }
                        catch (Exception e) {
                            System.out.println("failed arraycopy");
                            e.printStackTrace();
                            this.failed(new Throwable("error writing region data: " + errorMsg));
                            return;
                        }
                        offset += lastBytesRead;
                    }
                    if (rsp instanceof PupErrorResponse) {
                        PupErrorResponse errRsp = (PupErrorResponse)rsp;
                        errorMsg = errRsp.getError();
                    } else {
                        errorMsg = "incorrect response message type";
                    }
                } else {
                    errorMsg = "bad checksum";
                }
            } else {
                errorMsg = "no response";
            }
            if (!problem) continue;
            this.failed(new Throwable("error writing region data: " + errorMsg));
            return;
        }
        this.progress(90);
        this.logMessage("finished uploading region:" + regionNumber + "(" + regionName + ")");
        chan.makeFile(null, this.path);
        try (OutputStream out = chan.write(new BFoxFileStore(null, this.path));){
            out.write(splBytes);
        }
        this.logMessage("saved region:" + regionNumber + "(" + regionName + ") to file ");
        this.progress(100);
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.network != null) {
            int severity = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Upload Region Job:" + message);
            this.network.getLog().setSeverity(severity);
        }
    }
}

