/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupAcknowledgeTransactionMessage
extends PupMessage
implements AaPupConst {
    private int transaction;

    public PupAcknowledgeTransactionMessage(int targetUnitNumber, int transaction) {
        super(targetUnitNumber);
        this.transaction = transaction;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(7);
        out.write(13);
        out.writeInt(this.transaction);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -127) {
            return new PupAckResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupAcknowledgeTransactionMessage " + this.transaction;
    }
}

