/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupFreeRegionMessage
extends PupMessage
implements AaPupConst {
    private int regionNumber;
    private boolean action;

    public PupFreeRegionMessage(int targetUnitNumber, int regionNumber, boolean action) {
        super(targetUnitNumber);
        this.regionNumber = regionNumber;
        this.action = action;
    }

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int num) {
        this.regionNumber = num;
        if (num < 0) {
            this.regionNumber = 0;
        }
        if (num > 255) {
            this.regionNumber = 255;
        }
    }

    public boolean getAction() {
        return this.action;
    }

    public void setAction(boolean action) {
        this.action = action;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(7);
        out.write(29);
        out.write(this.regionNumber);
        out.write(this.action ? 1 : 0);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -127) {
            return new PupAckResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupFreeRegionMessage::unit:" + this.unitNumber + " regionNumber:" + this.regionNumber + " action:" + (this.action ? "free region" : " unlock region");
    }
}

