/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReadChannelsResponse;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupReadChannelsMessage
extends PupMessage
implements AaPupConst {
    private int index;

    public PupReadChannelsMessage(int unitNumber, int index) {
        super(unitNumber);
        this.index = index;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(7);
        out.write(35);
        out.writeInt(this.index);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -120) {
            return new PupReadChannelsResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupReadChannelsMessage to " + this.getUnitNumber() + (this.index == 0 ? " ,reading channel list" : " ,reading channel at index " + this.index);
    }
}

