/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.sys.BAbsTime;

public class PupTimeSyncMessage
extends PupMessage
implements AaPupConst {
    private BAbsTime synctime;
    private boolean holiday = false;

    public PupTimeSyncMessage(int targetUnitNumber, BAbsTime synctime) {
        super(targetUnitNumber);
        this.synctime = synctime;
        this.holiday = false;
    }

    public PupTimeSyncMessage(boolean holiday) {
        super(65535);
        this.synctime = BAbsTime.now();
        this.holiday = holiday;
        this.setResponseExpected(false);
    }

    public boolean getHoliday() {
        return this.holiday;
    }

    public void setHoliday(boolean holiday) {
        this.holiday = holiday;
    }

    public BAbsTime getTime() {
        return this.synctime;
    }

    public void setTime(BAbsTime synctime) {
        this.synctime = synctime;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(12);
        out.write(0);
        out.writeTime(this.synctime, this.holiday);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -127) {
            return new PupAckResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupTimeSyncMessage::unitNumber:" + this.unitNumber + " time:" + this.synctime;
    }
}

