/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupWriteTextAttributeMessage
extends PupMessage
implements AaPupConst {
    private int channel;
    private String attribute;
    private String strData;

    public PupWriteTextAttributeMessage(int targetUnitNumber, int channel, String attribute, String strData) {
        super(targetUnitNumber);
        this.channel = channel;
        this.attribute = attribute;
        this.strData = strData.trim();
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute.substring(0, 2);
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(9 + this.strData.length());
        out.write(30);
        out.writeInt(this.channel);
        out.writeAttribute(this.attribute, false, false);
        out.writeString(this.strData);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -127) {
            return new PupAckResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupWriteTextAttributeMessage::unit:" + this.unitNumber + " [" + this.channel + ":" + this.attribute + "]";
    }
}

