/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.point;

import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import com.tridium.aapup.messages.PupWriteAttributeMessage;
import com.tridium.aapup.point.BPupProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BPupEnumProxyExt
extends BPupProxyExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BPupEnumProxyExt.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BEnumPoint;
    }

    @Override
    public void setValue(PupResponse rsp) {
        if (rsp instanceof PupNumericDataResponse) {
            PupNumericDataResponse numRsp = (PupNumericDataResponse)rsp;
            BDouble value = numRsp.getDouble();
            this.setAttributeValue(numRsp.getString().getString());
            BStatusEnum sv = (BStatusEnum)this.getReadValue().newCopy();
            BDynamicEnum en = sv.getValue();
            sv.setValue(en.getRange().get((int)value.getDouble()));
            this.readOk((BStatusValue)sv);
            return;
        }
        if (rsp instanceof PupTextDataResponse) {
            PupTextDataResponse txtRsp = (PupTextDataResponse)rsp;
            BEnum myEnum = txtRsp.getEnum(((BControlPoint)this.getParent()).getFacets());
            if (myEnum == null) {
                this.readFail("could not convert enum value");
                return;
            }
            this.setAttributeValue(txtRsp.getString().getString());
            BStatusEnum sv = (BStatusEnum)this.getReadValue().newCopy();
            sv.setValue(myEnum);
            this.readOk((BStatusValue)sv);
            return;
        }
        this.readFail("message type incorrect");
    }

    @Override
    boolean updateOutput(BStatusValue out) {
        if (!this.prewriteAttribute()) {
            this.writeFail("unable to set override or manual");
            return false;
        }
        double dataOut = Double.NaN;
        if (!(out instanceof BStatusEnum)) {
            this.writeFail("attempt to write non-enum data to enum point");
            return false;
        }
        BDynamicEnum dataEnum = ((BStatusEnum)out).getValue();
        dataOut = dataEnum.getOrdinal();
        PupWriteAttributeMessage msg = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), dataOut);
        PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(msg);
        if (!this.isValidWriteResponse(rsp)) {
            return false;
        }
        if (rsp instanceof PupAckResponse) {
            this.getPupLog().fine("Write Succeeded on " + this);
            this.writeOk(out);
            return true;
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            this.getPupLog().fine("Received error response writing " + this);
            this.writeFail(errRsp.getError());
            return false;
        }
        this.getPupLog().fine("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }
}

