/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tlsMinProtocol", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1_2", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="verifySubjectInCertificate", type="BBoolean", defaultValue="BBoolean.make(true)", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public abstract class BEncryptableTransportRdbms
extends BRdbms {
    @Generated
    public static final Property tlsMinProtocol = BEncryptableTransportRdbms.newProperty((int)0, (BValue)BSslTlsEnum.tlsv1_2, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property verifySubjectInCertificate = BEncryptableTransportRdbms.newProperty((int)0, (boolean)((BBoolean)BBoolean.make((boolean)true).as(BBoolean.class)).getBoolean(), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BEncryptableTransportRdbms.class);

    @Generated
    public BSslTlsEnum getTlsMinProtocol() {
        return (BSslTlsEnum)this.get(tlsMinProtocol);
    }

    @Generated
    public void setTlsMinProtocol(BSslTlsEnum v) {
        this.set(tlsMinProtocol, (BValue)v, null);
    }

    @Generated
    public boolean getVerifySubjectInCertificate() {
        return this.getBoolean(verifySubjectInCertificate);
    }

    @Generated
    public void setVerifySubjectInCertificate(boolean v) {
        this.setBoolean(verifySubjectInCertificate, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void rdbmsStarted() throws Exception {
        super.rdbmsStarted();
        this.initializeTrustStore();
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && (useEncryptedConnection.equals(property) || this.getServerCertificateProperty() != null && this.getServerCertificateProperty().equals(property))) {
            BValue serverCertPropValue = this.get(this.getServerCertificateProperty());
            String serverCertificateAlias = serverCertPropValue != null ? serverCertPropValue.toString() : null;
            this.updateCertificateInTrustStore(serverCertificateAlias, context);
        }
        this.propertyChanged(property, context);
    }

    protected void propertyChanged(Property property, Context context) {
    }

    protected void initializeTrustStore() throws IOException {
    }

    protected abstract void loadTrustStore(KeyStore var1, Context var2) throws IOException;

    protected abstract void saveTrustStore(KeyStore var1, Context var2) throws IOException;

    protected void updateCertificateInTrustStore(String serverCertificateAlias, Context context) {
        block6: {
            try {
                KeyStore ks = KeyStore.getInstance(this.getTrustStoreType());
                this.loadTrustStore(ks, context);
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    ks.deleteEntry(aliases.nextElement());
                }
                if (this.getUseEncryptedConnection() && serverCertificateAlias != null && !serverCertificateAlias.isEmpty()) {
                    X509Certificate serverCertificateFromUserTrustStore = this.getServerCertificateFromSource(serverCertificateAlias);
                    if (serverCertificateFromUserTrustStore == null) {
                        throw new CertificateException(this.getLexicon().getText("rdb.error.invalidCertificate", new Object[]{serverCertificateAlias, this.getDisplayName(context)}));
                    }
                    ks.setCertificateEntry(serverCertificateAlias, serverCertificateFromUserTrustStore);
                }
                this.saveTrustStore(ks, context);
                if (!this.isFatalFault()) {
                    this.configOk();
                }
            }
            catch (IOException | GeneralSecurityException e) {
                String faultText = this.getLexicon().getText("rdb.error.trustStoreUpdateFailure", new Object[]{this.getDisplayName(context)});
                this.configFail(faultText);
                if (!this.getLogger().isLoggable(Level.FINE)) break block6;
                this.getLogger().log(Level.FINE, faultText, e);
            }
        }
    }

    protected X509Certificate getServerCertificateFromSource(String serverCertificateAlias) throws GeneralSecurityException {
        try {
            return CertManagerFactory.getInstance().getUserTrustStore().getCertificate(serverCertificateAlias);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
    }

    protected abstract Property getServerCertificateProperty();

    public String getTrustStoreType() {
        return SecurityInitializer.getInstance().getCryptoProvider().getDefaultKeyStoreType();
    }

    public abstract Path getTrustStorePath();

    public abstract String getServerCertificateSubjectIdentifier();

    protected static byte[] getTrustStorePasswordFromKeyRing(String trustStorePasswordKeyRingAlias) {
        try {
            KeyRing keyRing = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
            byte[] k = keyRing.getKey(trustStorePasswordKeyRingAlias);
            if (k == null) {
                try (SecretChars secretChars = BPassword.DEFAULT.getSecretChars();
                     SecretBytes secretBytes = secretChars.asSecretBytes();){
                    keyRing.setKey(trustStorePasswordKeyRingAlias, secretBytes.get(), true);
                }
                k = keyRing.getKey(trustStorePasswordKeyRingAlias);
            }
            return k;
        }
        catch (Exception e) {
            throw new SecurityException(e.getCause());
        }
    }
}

