/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.BIAgent;
import javax.baja.history.BTrendFlags;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
public abstract class BRdbmsDeprecatedDialect
extends BObject
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsDeprecatedDialect.class);
    private static final int VARCHAR_SIZE = 500;
    public static final String WIDTH = "width";
    public static final String RESULT_SIZE_COLUMN = "RST_SZ_R0B";
    public static final String LAST_ID_COLUMN = "LST_ID_R0B";
    private static final String SELECT_DESC_QUERY_BY_HISTORY_ID = "WITH recs AS (SELECT %s, ID FROM %s WHERE %s >= ? AND %s <= ? ORDER BY %s DESC LIMIT %s), rStats AS (SELECT MIN(recs.ID) AS LST_ID_R0B, COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, LST_ID_R0B, RST_SZ_R0B from recs, rStats";
    private static final String SELECT_ASC_QUERY_BY_HISTORY_ID = "WITH recs AS (SELECT %s FROM %s WHERE %s >= ? AND %s <= ? ORDER BY %s DESC LIMIT %s), rStats AS (SELECT COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, RST_SZ_R0B from recs, rStats ORDER BY %s ASC";
    private static final String SELECT_DESC_QUERY_BY_HISTORY_TYPE = "WITH recs AS (SELECT %s, ID FROM %s WHERE %s = ? AND %s >= ? AND %s <= ? ORDER BY %s DESC LIMIT %s), rStats AS (SELECT MIN(recs.ID) AS LST_ID_R0B, COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, LST_ID_R0B, RST_SZ_R0B from recs, rStats";
    private static final String SELECT_ASC_QUERY_BY_HISTORY_TYPE = "WITH recs AS (SELECT %s FROM %s WHERE %s = ? AND %s >= ? AND %s <= ? ORDER BY %s DESC LIMIT %s), rStats AS (SELECT COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, RST_SZ_R0B from recs, rStats ORDER BY %s ASC";
    private static final String BOUNDARY_REC_QUERY_BY_HISTORY_ID = "SELECT %s FROM %s WHERE %s %s ? ORDER BY %s %s LIMIT 1";
    private static final String BOUNDARY_REC_QUERY_BY_HISTORY_TYPE = "SELECT %s FROM %s WHERE %s = ? AND %s %s ? ORDER BY %s %s LIMIT 1";
    private static final String INDIVIDUAL_REC_QUERY = "SELECT %s FROM %s WHERE ID = ?";
    private static final Logger LOG = Logger.getLogger("rdb");
    protected BTimeZone timeZone = null;
    protected Calendar historyConfigCalendar = null;
    protected static final Calendar utcCalender = Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone());
    protected static final Calendar localCalender = Calendar.getInstance(BTimeZone.getLocal().getJavaTimeZone());
    protected static final Object lock = new Object();
    protected BRdbms database;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BRdbmsDeprecatedDialect make(Type dbType) {
        AgentInfo info = Sys.getRegistry().getAgents(dbType.getTypeInfo()).filter(AgentFilter.is((Type)TYPE)).getDefault();
        return (BRdbmsDeprecatedDialect)info.getAgentType().getTypeSpec().getInstance();
    }

    public static BRdbmsDeprecatedDialect make(BRdbms database) {
        BRdbmsDeprecatedDialect dialect = BRdbmsDeprecatedDialect.make(database.getType());
        dialect.database = database;
        return dialect;
    }

    public abstract boolean tableExists(BRdbms var1, Connection var2, String var3) throws SQLException;

    public String getSqlType(Property prop) {
        return this.getSqlType(prop.getType(), prop.getFacets());
    }

    public abstract String getSqlType(Type var1, BFacets var2);

    public abstract long getTimestampAccuracy();

    public abstract String getPrimaryKeySql();

    public abstract int getMaxTableName();

    public abstract int getMaxIndexName();

    public abstract int getMaxColumnName();

    public abstract int getMaxSequenceName();

    public abstract boolean hasSequences();

    public abstract boolean allowsUnicode();

    public String makeColumnName(String name) {
        return "\"" + name + "\"";
    }

    public boolean supportsTimestamp() {
        return true;
    }

    public int getVarcharSize(BFacets facets) {
        if (facets != null && !facets.isNull()) {
            return facets.geti(WIDTH, 500);
        }
        return 500;
    }

    public String makeCreateTableSql(String name, Property[] template, String[] extraFields, Type[] extraFieldTypes, BFacets[] extraFacets) {
        return this.makeCreateTableSql(name, true, template, extraFields, extraFieldTypes, extraFacets);
    }

    public String makeCreateTableSql(String name, boolean autoKey, Property[] template, String[] extraFields, Type[] extraFieldTypes, BFacets[] extraFacets) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(name);
        sql.append(" (");
        if (autoKey) {
            sql.append("ID ").append(this.getPrimaryKeySql());
        }
        String[] fieldNames = this.getTemplateColumnNames(template, extraFields);
        for (i = 0; i < template.length; ++i) {
            if (i > 0 || autoKey) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(fieldNames[i]));
            sql.append(" ").append(this.getSqlType(template[i]));
        }
        for (i = 0; i < extraFields.length; ++i) {
            sql.append(", ").append(this.makeColumnName(extraFields[i]));
            sql.append(" ").append(this.getSqlType(extraFieldTypes[i], extraFacets[i]));
        }
        sql.append(")");
        return sql.toString();
    }

    public String makeInsertSql(String tableName, Property[] template, String[] extraFields) {
        return this.makeInsertSql(tableName, true, template, extraFields);
    }

    public String makeInsertSql(String tableName, boolean autokey, Property[] template, String[] extraFields) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        int n = 0;
        sql.append(" (");
        if (this.hasSequences() && autokey) {
            sql.append("ID");
            ++n;
        }
        String[] fieldNames = this.getTemplateColumnNames(template, extraFields);
        for (i = 0; i < template.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(fieldNames[i]));
        }
        for (i = 0; i < extraFields.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(extraFields[i]));
        }
        sql.append(")");
        n = 0;
        sql.append(" VALUES (");
        if (this.hasSequences() && autokey) {
            sql.append(tableName + "_Q.NEXTVAL");
            ++n;
        }
        for (i = 0; i < template.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        for (i = 0; i < extraFields.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    public String makeUpdateSql(String tableName, Property[] template, String[] extraFields, String keyName) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName);
        int n = 0;
        sql.append(" SET ");
        String[] fieldNames = this.getTemplateColumnNames(template, extraFields);
        for (i = 0; i < template.length; ++i) {
            if (fieldNames[i].equals(keyName)) continue;
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(fieldNames[i]));
            sql.append(" = ?");
        }
        for (i = 0; i < extraFields.length; ++i) {
            if (extraFields[i].equals(keyName)) continue;
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(extraFields[i]));
            sql.append(" = ?");
        }
        sql.append(" WHERE ");
        sql.append(keyName);
        sql.append(" = ?");
        return sql.toString();
    }

    public String makeAddColumnSql(String tableName, String columnName, BSqlType columnType, int columnSize, String defaultValue) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(tableName).append(" ");
        sql.append("ADD ").append(columnName).append(" ").append(this.getDataType(columnType));
        if (columnSize > -1) {
            sql.append("(" + columnSize + ") ");
        } else {
            sql.append(" ");
        }
        sql.append("NOT NULL DEFAULT ");
        if (columnType.equals((Object)BSqlType.sqlVarchar) || columnType.equals((Object)BSqlType.sqlNVarchar)) {
            defaultValue = "'" + defaultValue + "'";
        }
        sql.append(defaultValue);
        return sql.toString();
    }

    public abstract String makeAlterColumnTypeSql(String var1, String var2, BSqlType var3, int var4);

    public Pair<String, String> getNewIndexNameAndColumns(String tableId) {
        switch (this.database.getExportMode().getOrdinal()) {
            case 0: {
                return new Pair((Object)("ID_" + tableId + "_TS"), (Object)"TIMESTAMP");
            }
            case 1: {
                return new Pair((Object)("IDX_" + tableId + "_ID_TS"), (Object)"HISTORY_ID, TIMESTAMP");
            }
        }
        throw new IllegalStateException("Unsupported RDB export mode");
    }

    public String makeCreateIndexSql(String indexName, String tableName, String columnNames, boolean online) {
        String idx = "CREATE INDEX " + indexName + " ON " + tableName + " (" + columnNames + ')';
        return idx;
    }

    public boolean supportsOnlineIndexCreation() {
        return false;
    }

    public abstract String makeDropIndexSql(String var1, String var2);

    public String makeTimeQuerySql(String columns, String tableName, boolean isDescendingQuery, int limit) {
        String timestampCol = this.makeColumnName("TIMESTAMP");
        switch (this.database.getExportMode().getOrdinal()) {
            case 0: {
                if (isDescendingQuery) {
                    return String.format(SELECT_DESC_QUERY_BY_HISTORY_ID, columns, tableName, timestampCol, timestampCol, timestampCol, limit, columns);
                }
                return String.format(SELECT_ASC_QUERY_BY_HISTORY_ID, columns, tableName, timestampCol, timestampCol, timestampCol, limit, columns, timestampCol);
            }
            case 1: {
                String historyIdCol = this.makeColumnName("HISTORY_ID");
                if (isDescendingQuery) {
                    return String.format(SELECT_DESC_QUERY_BY_HISTORY_TYPE, columns, tableName, historyIdCol, timestampCol, timestampCol, timestampCol, limit, columns);
                }
                return String.format(SELECT_ASC_QUERY_BY_HISTORY_TYPE, columns, tableName, historyIdCol, timestampCol, timestampCol, timestampCol, limit, columns, timestampCol);
            }
        }
        throw new IllegalStateException("Unsupported RDB export mode");
    }

    public String makeBoundaryRecordQuerySql(String columns, String tableName, boolean newestOrOldest) {
        String timestampCol = this.makeColumnName("TIMESTAMP");
        switch (this.database.getExportMode().getOrdinal()) {
            case 0: {
                return String.format(BOUNDARY_REC_QUERY_BY_HISTORY_ID, columns, tableName, timestampCol, newestOrOldest ? ">" : "<", timestampCol, newestOrOldest ? "ASC" : "DESC");
            }
            case 1: {
                String historyIdCol = this.makeColumnName("HISTORY_ID");
                return String.format(BOUNDARY_REC_QUERY_BY_HISTORY_TYPE, columns, tableName, historyIdCol, timestampCol, newestOrOldest ? ">" : "<", timestampCol, newestOrOldest ? "ASC" : "DESC");
            }
        }
        throw new IllegalStateException("Unsupported RDB export mode");
    }

    public String makeIndividualRecordQuerySql(String columns, String tableName) {
        return String.format(INDIVIDUAL_REC_QUERY, columns, tableName);
    }

    public String getDataType(BSqlType type) {
        switch (type.getOrdinal()) {
            case 0: {
                return this.getSqlType(BInteger.TYPE, null);
            }
            case 1: {
                return this.getSqlType(BLong.TYPE, null);
            }
            case 2: {
                return this.getSqlType(BFloat.TYPE, null);
            }
            case 3: {
                return this.getSqlType(BDouble.TYPE, null);
            }
            case 5: {
                return this.getSqlType(BAbsTime.TYPE, null);
            }
        }
        String stringType = this.getSqlType(BString.TYPE, null);
        return stringType.substring(0, stringType.indexOf("("));
    }

    public BValue readField(ResultSet rs, Type propType, int columnIdx, BTimeZone tz) throws SQLException {
        BString propVal = null;
        if (propType.is(BString.TYPE)) {
            String strVal = rs.getString(columnIdx);
            propVal = strVal == null ? BString.DEFAULT : BString.make((String)strVal);
        } else if (propType.is(BInteger.TYPE)) {
            propVal = BInteger.make((int)rs.getInt(columnIdx));
        } else if (propType.is(BLong.TYPE)) {
            propVal = BLong.make((long)rs.getLong(columnIdx));
        } else if (propType.is(BFloat.TYPE)) {
            Object val;
            float floatVal = rs.getFloat(columnIdx);
            if (floatVal == 0.0f && (val = rs.getObject(columnIdx)) == null) {
                return BFloat.NaN;
            }
            if (floatVal >= this.getMaxFloat()) {
                floatVal = Float.POSITIVE_INFINITY;
            } else if (floatVal <= this.getMinFloat()) {
                floatVal = Float.NEGATIVE_INFINITY;
            }
            propVal = BFloat.make((float)floatVal);
        } else if (propType.is(BDouble.TYPE)) {
            Object val;
            double doubleVal = rs.getDouble(columnIdx);
            if (doubleVal == 0.0 && (val = rs.getObject(columnIdx)) == null) {
                return BDouble.NaN;
            }
            if (doubleVal >= this.getMaxDouble()) {
                doubleVal = Double.POSITIVE_INFINITY;
            } else if (doubleVal <= this.getMinDouble()) {
                doubleVal = Double.NEGATIVE_INFINITY;
            }
            propVal = BDouble.make((double)doubleVal);
        } else if (propType.is(BAbsTime.TYPE)) {
            if (this.supportsTimestamp()) {
                Timestamp timestamp = rs.getTimestamp(columnIdx);
                if (timestamp == null) {
                    propVal = BAbsTime.NULL;
                } else {
                    long millis = timestamp.getTime();
                    if (millis == 0L && BTimeZone.getLocal() == tz) {
                        return BAbsTime.NULL;
                    }
                    propVal = BAbsTime.make((long)millis, (BTimeZone)tz);
                }
            } else {
                long longVal = rs.getLong(columnIdx);
                if (longVal == 0L && BTimeZone.getLocal() == tz) {
                    return BAbsTime.NULL;
                }
                propVal = BAbsTime.make((long)longVal, (BTimeZone)tz);
            }
        } else if (propType.is(BRelTime.TYPE)) {
            propVal = BRelTime.make((long)rs.getLong(columnIdx));
        } else if (propType.is(BBoolean.TYPE)) {
            propVal = BBoolean.make((boolean)rs.getBoolean(columnIdx));
        } else if (propType.is(BStatus.TYPE)) {
            propVal = BStatus.make((int)rs.getInt(columnIdx));
        } else if (propType.is(BTrendFlags.TYPE)) {
            propVal = BTrendFlags.make((int)rs.getInt(columnIdx));
        } else if (propType.is(BTimeZone.TYPE)) {
            String tzString = rs.getString(columnIdx);
            if (tzString != null) {
                try {
                    int idx = tzString.lastIndexOf(" (");
                    propVal = BTimeZone.getTimeZone((String)tzString.substring(0, idx));
                }
                catch (Exception e) {
                    try {
                        propVal = BTimeZone.getTimeZone((String)tzString);
                    }
                    catch (Exception ex) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Failed to read BTimeZone value from a ResultSet. Reverting to local timezone.", e);
                        }
                        propVal = BTimeZone.getLocal();
                    }
                }
            } else {
                propVal = BTimeZone.getLocal();
            }
        } else if (propType.is(BIEncodable.TYPE)) {
            try {
                String strVal = rs.getString(columnIdx);
                if (strVal == null) {
                    strVal = "";
                }
                propVal = (BValue)((BIEncodable)propType.getInstance()).decodeFromString(strVal);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Unexpected exception when reading a BIEncodable value from a ResultSet.", ioe);
                }
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unexpected type encountered when reading a value from a ResultSet: " + propType);
        }
        return propVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadField(PreparedStatement ps, int paramIdx, BObject field, BFacets facets) throws SQLException {
        Type type = field.getType();
        if (field instanceof BString) {
            ps.setString(paramIdx, TextUtil.truncate((String)((BString)field).getString(), (int)this.getVarcharSize(facets)));
        } else if (field instanceof BInteger) {
            ps.setInt(paramIdx, ((BInteger)field).getInt());
        } else if (field instanceof BLong) {
            ps.setLong(paramIdx, ((BLong)field).getLong());
        } else if (field instanceof BFloat) {
            float floatVal = ((BFloat)field).getFloat();
            if (Float.isNaN(floatVal)) {
                ps.setNull(paramIdx, 7);
            } else if (floatVal == Float.POSITIVE_INFINITY) {
                ps.setFloat(paramIdx, this.getMaxFloat());
            } else if (floatVal == Float.NEGATIVE_INFINITY) {
                ps.setFloat(paramIdx, this.getMinFloat());
            } else {
                ps.setFloat(paramIdx, floatVal);
            }
        } else if (field instanceof BDouble) {
            double doubleVal = ((BDouble)field).getDouble();
            if (Double.isNaN(doubleVal)) {
                ps.setNull(paramIdx, 6);
            } else if (doubleVal == Double.POSITIVE_INFINITY) {
                ps.setDouble(paramIdx, this.getMaxDouble());
            } else if (doubleVal == Double.NEGATIVE_INFINITY) {
                ps.setDouble(paramIdx, this.getMinDouble());
            } else {
                ps.setDouble(paramIdx, doubleVal);
            }
        } else if (field instanceof BAbsTime) {
            if (this.supportsTimestamp()) {
                Timestamp ts = new Timestamp(((BAbsTime)field).getMillis());
                Calendar tsCalender = this.getCalendarForTimestamps();
                Object object = lock;
                synchronized (object) {
                    ps.setTimestamp(paramIdx, ts, tsCalender);
                }
            } else {
                BAbsTime time = (BAbsTime)field;
                long utcMillis = time.getMillis();
                ps.setLong(paramIdx, utcMillis);
            }
        } else if (field instanceof BRelTime) {
            ps.setLong(paramIdx, ((BRelTime)field).getMillis());
        } else if (field instanceof BBoolean) {
            ps.setBoolean(paramIdx, ((BBoolean)field).getBoolean());
        } else if (field instanceof BStatus) {
            ps.setInt(paramIdx, ((BStatus)field).getBits());
        } else if (field instanceof BTrendFlags) {
            ps.setInt(paramIdx, ((BTrendFlags)field).getBits());
        } else if (field instanceof BTimeZone) {
            ps.setString(paramIdx, TextUtil.truncate((String)field.toString(), (int)this.getVarcharSize(facets)));
        } else if (field instanceof BSimple) {
            try {
                ps.setString(paramIdx, ((BSimple)field).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ps.setString(paramIdx, TextUtil.truncate((String)field.toString(), (int)this.getVarcharSize(facets)));
        }
    }

    protected float getMaxFloat() {
        return Float.MAX_VALUE;
    }

    protected float getMinFloat() {
        return -3.4028235E38f;
    }

    protected double getMaxDouble() {
        return Double.MAX_VALUE;
    }

    protected double getMinDouble() {
        return -1.7976931348623157E308;
    }

    public void insertRecord(PreparedStatement ps, BComplex comp, Property[] template, BObject[] extraValues, BFacets[] extraFacets) throws SQLException {
        int i;
        int n = 1;
        if (comp != null) {
            for (i = 0; i < template.length; ++i) {
                this.loadField(ps, n++, (BObject)comp.get(template[i]), template[i].getFacets());
            }
        }
        for (i = 0; i < extraValues.length; ++i) {
            this.loadField(ps, n++, extraValues[i], extraFacets[i]);
        }
        ps.addBatch();
    }

    public void updateRecord(PreparedStatement ps, BComplex comp, Property[] template, BObject[] extraValues, BFacets[] extraFacets, String keyName, BObject keyValue) throws SQLException {
        int i;
        int n = 1;
        String[] fieldNames = this.getTemplateColumnNames(template, new String[0]);
        for (i = 0; i < template.length; ++i) {
            if (fieldNames[i].equals(keyName)) continue;
            this.loadField(ps, n++, (BObject)comp.get(template[i]), template[i].getFacets());
        }
        for (i = 0; i < extraValues.length; ++i) {
            this.loadField(ps, n++, extraValues[i], extraFacets[i]);
        }
        this.loadField(ps, n++, keyValue, BFacets.NULL);
        ps.addBatch();
    }

    public String[] getTemplateColumnNames(Property[] template, String[] extraFields) {
        int max = this.getMaxColumnName();
        Array arr = new Array(String.class, template.length);
        HashSet<String> set = new HashSet<String>();
        set.addAll(new Array((Object[])extraFields).list());
        for (int i = 0; i < template.length; ++i) {
            String fullName = this.mangleIdentifier(template[i].getName());
            String name = TextUtil.truncate((String)fullName, (int)max);
            if (set.contains(name)) {
                String nn;
                int n = 1;
                while (set.contains(name = TextUtil.truncate((String)fullName, (int)(max - (nn = Integer.toString(n++)).length())) + nn)) {
                }
            }
            set.add(name);
            arr.add((Object)name);
        }
        return (String[])arr.trim();
    }

    public String mangleIdentifier(String name) {
        if ((name = name.toUpperCase()).equals("ID")) {
            return "ID_";
        }
        if (name.equals("SCHEMA")) {
            return "SCHEMA_";
        }
        if (name.equals("INTERVAL")) {
            return "INTERVAL_";
        }
        StringBuilder sb = new StringBuilder();
        char c = name.charAt(0);
        if (this.allowsUnicode() && Character.isLetter(c) || BRdbmsDeprecatedDialect.isAsciiLetter(c) || c == '_') {
            sb.append(c);
        }
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if ((!this.allowsUnicode() || !Character.isLetterOrDigit(c)) && !BRdbmsDeprecatedDialect.isAsciiLetterOrDigit(c) && c != '_') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isAsciiLetter(char c) {
        return 'A' <= c && c <= 'Z';
    }

    private static boolean isAsciiLetterOrDigit(char c) {
        return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    public void setTimeZone(BTimeZone timeZone) {
        this.timeZone = timeZone;
        this.historyConfigCalendar = new GregorianCalendar(timeZone.getJavaTimeZone());
    }

    public Calendar getCalendarForTimestamps() {
        RdbmsDialect context = (RdbmsDialect)this.database.getRdbmsContext();
        return context.useUtcTimestamps() ? utcCalender : (this.timeZone != null ? this.historyConfigCalendar : localCalender);
    }

    public List<String> getCatalogs(DatabaseMetaData metaData) throws SQLException {
        ArrayList<String> catalogList = new ArrayList<String>();
        try (ResultSet resultSet = metaData.getCatalogs();){
            while (resultSet.next()) {
                String catalog = resultSet.getString("TABLE_CAT");
                if (catalog == null) continue;
                catalogList.add(catalog);
            }
        }
        return catalogList;
    }

    public ResultSet getTables(DatabaseMetaData metaData, String catalog, String[] typeFilter) throws SQLException {
        return metaData.getTables(catalog, null, null, typeFilter);
    }
}

