/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.baja.sys.BajaRuntimeException;

public abstract class RdbmsUtil {
    private static List<String> BLACKLIST_PROPERTIES;

    public static void checkSqlBody(String body) {
        body = body.toLowerCase();
        for (String BLACKLIST_PROPERTY : BLACKLIST_PROPERTIES) {
            if (!body.contains(BLACKLIST_PROPERTY)) continue;
            throw new BajaRuntimeException();
        }
    }

    public static boolean isBlacklistProperty(String propertyName) {
        return BLACKLIST_PROPERTIES.contains(propertyName);
    }

    static {
        String systemPropBlacklist = AccessController.doPrivileged(() -> System.getProperty("niagara.sqlSchemeBlacklist.properties", null));
        BLACKLIST_PROPERTIES = new ArrayList<String>();
        BLACKLIST_PROPERTIES.add("pinnumber");
        if (systemPropBlacklist != null) {
            StringTokenizer tokenizer = new StringTokenizer(systemPropBlacklist, ";");
            while (tokenizer.hasMoreTokens()) {
                try {
                    BLACKLIST_PROPERTIES.add(tokenizer.nextToken().toLowerCase());
                }
                catch (Exception e) {
                    System.out.println("Could not parse properties for sql scheme blacklist.");
                    e.printStackTrace();
                }
            }
        }
    }
}

