/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.fox;

import com.tridium.collection.GenericColumnList;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import java.io.DataOutput;
import java.io.DataOutputStream;
import javax.baja.collection.Column;
import javax.baja.io.BIEncodable;
import javax.baja.rdb.sql.SqlSchemeConsumer;
import javax.baja.sys.BComponent;

public class BSqlSchemeResultEncoder
implements SqlSchemeConsumer {
    private FoxCircuit circuit;
    private boolean firstRow = true;
    private Column[] columns;
    private DataOutputStream out;

    BSqlSchemeResultEncoder() {
    }

    void init(FoxCircuit circuit) {
        this.out = new DataOutputStream(circuit.getOutputStream());
        this.circuit = circuit;
    }

    public boolean isResolved() {
        return !this.firstRow;
    }

    @Override
    public void acceptRow(BComponent row) throws Exception {
        if (this.firstRow) {
            FoxMessage resp = new FoxMessage();
            resp.add("resolved", true);
            this.circuit.writeMessage(resp);
            this.circuit.flush();
            this.columns = new GenericColumnList(new BComponent[]{row}).list();
            this.firstRow = false;
            int colCount = this.columns.length;
            this.out.writeInt(colCount);
            for (Column column : this.columns) {
                this.out.writeUTF(column.getName());
                char dataTypeSymbol = column.getType().getDataTypeSymbol();
                this.out.writeInt(dataTypeSymbol);
                if (dataTypeSymbol != '\u0000') continue;
                String dataType = column.getType().toString();
                this.out.writeUTF(dataType);
            }
        } else {
            this.out.writeBoolean(false);
        }
        for (Column column : this.columns) {
            BIEncodable cell = (BIEncodable)row.get(column.getName());
            cell.encode((DataOutput)this.out);
        }
    }

    void destroy() throws Exception {
        if (this.firstRow) {
            FoxMessage resp = new FoxMessage();
            resp.add("resolved", true);
            this.circuit.writeMessage(resp);
            this.circuit.flush();
            this.out.writeInt(0);
        }
        if (this.out != null) {
            this.out.writeBoolean(true);
            this.out.flush();
            this.out.close();
        }
    }
}

