/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.batik;

import java.net.URI;
import javax.baja.naming.BOrd;
import org.apache.batik.util.ParsedURL;
import org.owasp.encoder.Encode;

public class BatikOrdUtils {
    private static final String PREFIX = "ord://svgBatik/?ord=";

    public static String toBatikUrl(ParsedURL purl) {
        String urlString = purl.toString();
        if (urlString.startsWith("ord:svgBatik")) {
            urlString = "ord://svgBatik" + urlString.substring("ord:svgBatik".length());
        }
        return urlString;
    }

    public static String toBatikUrl(BOrd ord) {
        return BatikOrdUtils.toBatikUrl(ord, null);
    }

    public static String toBatikUrl(BOrd ord, String ref) {
        String query = ord.encodeToString();
        String hash = ref != null && !ref.isEmpty() ? "#" + ref : "";
        return PREFIX + Encode.forUriComponent((String)query) + hash;
    }

    public static String fromBatikUrl(String url) {
        return URI.create(url).getQuery().substring("ord=".length());
    }

    public static String fromBatikUrl(ParsedURL purl) {
        return BatikOrdUtils.fromBatikUrl(BatikOrdUtils.toBatikUrl(purl));
    }

    public static String relativize(ParsedURL purl, String subUrl) {
        return BatikOrdUtils.relativize(BatikOrdUtils.toBatikUrl(purl), subUrl);
    }

    public static String relativize(String batikUrl, String subUrl) {
        int slashIdx;
        if (subUrl.startsWith("ord://")) {
            return subUrl;
        }
        String baseOrdStr = BatikOrdUtils.fromBatikUrl(batikUrl);
        int hashIdx = subUrl.indexOf("#");
        String hash = null;
        if (hashIdx >= 0) {
            hash = subUrl.substring(hashIdx + 1);
            subUrl = subUrl.substring(0, hashIdx);
        }
        if (!subUrl.isEmpty() && (slashIdx = baseOrdStr.lastIndexOf("/")) > 0) {
            baseOrdStr = baseOrdStr.substring(0, slashIdx + 1);
        }
        return BatikOrdUtils.toBatikUrl(BOrd.make((String)(baseOrdStr + subUrl)), hash);
    }
}

