/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import com.tridium.util.TimeFormat;
import javax.baja.agent.BIAgent;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Adapter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType(agent={@AgentOn(types={"baja:ConversionLink"})}, adapter=@Adapter(from="baja:AbsTime", to="baja:StatusString"))
@NiagaraProperty(name="format", type="String", defaultValue="YYYY-MM-DDTHH:mm:ssZ")
public final class BAbsTimeToStatusString
extends BConverter
implements BIAgent {
    @Generated
    public static final Property format = BAbsTimeToStatusString.newProperty((int)0, (String)"YYYY-MM-DDTHH:mm:ssZ", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbsTimeToStatusString.class);
    private static final BFacets CONVERSION_FACETS;

    @Generated
    public String getFormat() {
        return this.getString(format);
    }

    @Generated
    public void setFormat(String v) {
        this.setString(format, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusString statusString = (BStatusString)to;
        BAbsTime absTime = (BAbsTime)from;
        if (absTime.isNull()) {
            statusString.setStatus(BStatus.nullStatus);
        } else {
            BFacets facets;
            String format = this.getFormat();
            BFacets bFacets = facets = cx != null ? cx.getFacets() : BFacets.DEFAULT;
            if (format.length() > 0) {
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)format)));
            }
            facets = BFacets.make((BFacets)facets, (BFacets)CONVERSION_FACETS);
            statusString.setValue(TimeFormat.format((BAbsTime)absTime, (Context)facets));
            statusString.setStatus(BStatus.ok);
        }
        return statusString;
    }

    static {
        BFacets facets = BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE);
        facets = BFacets.make((BFacets)facets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
        facets = BFacets.make((BFacets)facets, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
        facets = BFacets.make((BFacets)facets, (String)"showTimeZone", (BIDataValue)BBoolean.TRUE);
        CONVERSION_FACETS = facets = BFacets.make((BFacets)facets, (String)"showTime", (BIDataValue)BBoolean.TRUE);
    }
}

